/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Point;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record EntityVelocityPacket(int entityId, short velocityX, short velocityY, short velocityZ) implements ServerPacket
{
    public EntityVelocityPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.SHORT), reader.read(NetworkBuffer.SHORT), reader.read(NetworkBuffer.SHORT));
    }

    public EntityVelocityPacket(int entityId, Point velocity) {
        this(entityId, (short)MathUtils.clamp(velocity.x(), -32768.0, 32767.0), (short)MathUtils.clamp(velocity.y(), -32768.0, 32767.0), (short)MathUtils.clamp(velocity.z(), -32768.0, 32767.0));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        writer.write(NetworkBuffer.SHORT, this.velocityX);
        writer.write(NetworkBuffer.SHORT, this.velocityY);
        writer.write(NetworkBuffer.SHORT, this.velocityZ);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.ENTITY_VELOCITY;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

