/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ComponentHoldingServerPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record SetSlotPacket(byte windowId, int stateId, short slot, @NotNull ItemStack itemStack) implements ComponentHoldingServerPacket
{
    public SetSlotPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.BYTE), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.SHORT), reader.read(NetworkBuffer.ITEM));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.BYTE, this.windowId);
        writer.write(NetworkBuffer.VAR_INT, this.stateId);
        writer.write(NetworkBuffer.SHORT, this.slot);
        writer.write(NetworkBuffer.ITEM, this.itemStack);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.SET_SLOT;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        ArrayList<Component> components = new ArrayList<Component>(this.itemStack.getLore());
        Component displayname = this.itemStack.getDisplayName();
        if (displayname != null) {
            components.add(displayname);
        }
        return List.copyOf(components);
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        return new SetSlotPacket(this.windowId, this.stateId, this.slot, this.itemStack.withDisplayName(operator).withLore(lines -> {
            ArrayList translatedComponents = new ArrayList();
            lines.forEach(component -> translatedComponents.add((Component)operator.apply((Component)component)));
            return translatedComponents;
        }));
    }

    @NotNull
    public static SetSlotPacket createCursorPacket(@NotNull ItemStack cursorItem) {
        return new SetSlotPacket(-1, 0, -1, cursorItem);
    }
}

