/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Point;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record SpawnPositionPacket(@NotNull Point position, float angle) implements ServerPacket
{
    public SpawnPositionPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.BLOCK_POSITION), reader.read(NetworkBuffer.FLOAT).floatValue());
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.BLOCK_POSITION, this.position);
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.angle));
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.SPAWN_POSITION;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

