/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record TimeUpdatePacket(long worldAge, long timeOfDay) implements ServerPacket
{
    public TimeUpdatePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.LONG), reader.read(NetworkBuffer.LONG));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.LONG, this.worldAge);
        writer.write(NetworkBuffer.LONG, this.timeOfDay);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.TIME_UPDATE;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

