/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.ping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minestom.server.MinecraftServer;
import net.minestom.server.utils.identity.NamedAndIdentified;
import org.jetbrains.annotations.NotNull;

public class ResponseData {
    private static final Component DEFAULT_DESCRIPTION = Component.text((String)"Minestom Server");
    private final List<NamedAndIdentified> entries = new ArrayList<NamedAndIdentified>();
    private String version = "1.20.4";
    private int protocol = 765;
    private int maxPlayer;
    private int online = MinecraftServer.getConnectionManager().getOnlinePlayerCount();
    private Component description;
    private String favicon = "";
    private boolean playersHidden = false;

    public ResponseData() {
        this.maxPlayer = this.online + 1;
        this.description = DEFAULT_DESCRIPTION;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setMaxPlayer(int maxPlayer) {
        this.maxPlayer = maxPlayer;
    }

    public int getMaxPlayer() {
        return this.maxPlayer;
    }

    public void setOnline(int online) {
        this.online = online;
    }

    public int getOnline() {
        return this.online;
    }

    public void setDescription(Component description) {
        this.description = description;
    }

    public Component getDescription() {
        return this.description;
    }

    public void setFavicon(String favicon) {
        this.favicon = favicon;
    }

    public String getFavicon() {
        return this.favicon;
    }

    public void addEntry(@NotNull NamedAndIdentified entry) {
        this.entries.add(entry);
    }

    public void addEntries(NamedAndIdentified ... entries) {
        this.addEntries(Arrays.asList(entries));
    }

    public void addEntries(@NotNull Collection<? extends NamedAndIdentified> entries) {
        this.entries.addAll(entries);
    }

    public void clearEntries() {
        this.entries.clear();
    }

    @NotNull
    public Collection<NamedAndIdentified> getEntries() {
        return this.entries;
    }

    public void setPlayersHidden(boolean playersHidden) {
        this.playersHidden = playersHidden;
    }

    public boolean arePlayersHidden() {
        return this.playersHidden;
    }
}

