/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.tag;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minestom.server.tag.Tag;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTList;
import org.jglrxavpok.hephaistos.nbt.NBTType;

final class TagNbtSeparator {
    static final Map<NBTType<?>, Function<String, Tag<?>>> SUPPORTED_TYPES = Map.ofEntries(Map.entry(NBTType.TAG_Byte, Tag::Byte), Map.entry(NBTType.TAG_Short, Tag::Short), Map.entry(NBTType.TAG_Int, Tag::Integer), Map.entry(NBTType.TAG_Long, Tag::Long), Map.entry(NBTType.TAG_Float, Tag::Float), Map.entry(NBTType.TAG_Double, Tag::Double), Map.entry(NBTType.TAG_String, Tag::String));

    TagNbtSeparator() {
    }

    static void separate(NBTCompound nbtCompound, Consumer<Entry> consumer) {
        for (Map.Entry ent : nbtCompound) {
            TagNbtSeparator.convert(new ArrayList<String>(), (String)ent.getKey(), (NBT)ent.getValue(), consumer);
        }
    }

    static void separate(String key, NBT nbt, Consumer<Entry> consumer) {
        TagNbtSeparator.convert(new ArrayList<String>(), key, nbt, consumer);
    }

    static Entry separateSingle(String key, NBT nbt) {
        assert (!(nbt instanceof NBTCompound));
        AtomicReference entryRef = new AtomicReference();
        TagNbtSeparator.convert(new ArrayList<String>(), key, nbt, entry -> {
            assert (entryRef.getPlain() == null) : "Multiple entries found for nbt tag: " + key + " -> " + String.valueOf(nbt);
            entryRef.setPlain(entry);
        });
        Entry entry2 = (Entry)entryRef.getPlain();
        assert (entry2 != null);
        return entry2;
    }

    private static void convert(List<String> path, String key, NBT nbt, Consumer<Entry> consumer) {
        Function<String, Tag<?>> tagFunction = SUPPORTED_TYPES.get(nbt.getID());
        if (tagFunction != null) {
            Tag<?> tag = tagFunction.apply(key);
            consumer.accept(TagNbtSeparator.makeEntry(path, tag, nbt.getValue()));
        } else if (nbt instanceof NBTCompound) {
            NBTCompound nbtCompound = (NBTCompound)nbt;
            for (Map.Entry ent : nbtCompound) {
                ArrayList<String> newPath = new ArrayList<String>(path);
                newPath.add(key);
                TagNbtSeparator.convert(newPath, (String)ent.getKey(), (NBT)ent.getValue(), consumer);
            }
        } else if (nbt instanceof NBTList) {
            NBTList nbtList = (NBTList)nbt;
            tagFunction = SUPPORTED_TYPES.get(nbtList.getSubtagType());
            if (tagFunction == null) {
                consumer.accept(TagNbtSeparator.makeEntry(path, Tag.NBT(key), nbt));
            } else {
                try {
                    Tag<List<?>> tag = tagFunction.apply(key).list();
                    Object[] values = new Object[nbtList.getSize()];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = nbtList.get(i).getValue();
                    }
                    consumer.accept(TagNbtSeparator.makeEntry(path, (Tag)Tag.class.cast(tag), List.of(values)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    consumer.accept(TagNbtSeparator.makeEntry(path, Tag.NBT(key), nbt));
                }
            }
        } else {
            consumer.accept(TagNbtSeparator.makeEntry(path, Tag.NBT(key), nbt));
        }
    }

    private static <T> Entry<?> makeEntry(List<String> path, Tag<T> tag, T value) {
        return new Entry<T>(tag.path((String[])path.toArray(String[]::new)), value);
    }

    record Entry<T>(Tag<T> tag, T value) {
    }
}

