/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.tag;

import java.util.function.Function;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagNbtSeparator;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.tag.TagSerializer;
import net.minestom.server.tag.TagWritable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;

final class TagSerializerImpl {
    public static final TagSerializer<NBTCompound> COMPOUND = new TagSerializer<NBTCompound>(){

        @Override
        @NotNull
        public NBTCompound read(@NotNull TagReadable reader) {
            return ((TagHandler)reader).asCompound();
        }

        @Override
        public void write(@NotNull TagWritable writer, @NotNull NBTCompound value) {
            TagNbtSeparator.separate(value, entry -> writer.setTag(entry.tag(), entry.value()));
        }
    };

    TagSerializerImpl() {
    }

    static <T> TagSerializer<T> fromCompound(final Function<NBTCompound, T> readFunc, final Function<T, NBTCompound> writeFunc) {
        return new TagSerializer<T>(){

            @Override
            @Nullable
            public T read(@NotNull TagReadable reader) {
                NBTCompound compound = (NBTCompound)COMPOUND.read(reader);
                return readFunc.apply(compound);
            }

            @Override
            public void write(@NotNull TagWritable writer, @NotNull T value) {
                NBTCompound compound = (NBTCompound)writeFunc.apply(value);
                COMPOUND.write(writer, compound);
            }
        };
    }
}

