/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import java.time.Duration;
import net.minestom.server.MinecraftServer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public final class TickUtils {
    public static final int CLIENT_TPS = 20;
    public static final int CLIENT_TICK_MS = 50;

    public static int fromDuration(@NotNull Duration duration) {
        return TickUtils.fromDuration(duration, MinecraftServer.TICK_MS);
    }

    public static int fromDuration(@NotNull Duration duration, int msPerTick) {
        Check.argCondition(duration.isNegative(), "Duration cannot be negative");
        return (int)(duration.toMillis() / (long)msPerTick);
    }

    private TickUtils() {
    }
}

