/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class UniqueIdUtils {
    public static final String UUID_GROUP_REPLACEMENT = "$1-$2-$3-$4-$5";
    public static final Pattern UNIQUE_ID_PATTERN = Pattern.compile("\\b[0-9a-f]{8}\\b-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-\\b[0-9a-f]{12}\\b");

    private UniqueIdUtils() {
    }

    public static boolean isUniqueId(@NotNull String input) {
        return !input.trim().isEmpty() && UNIQUE_ID_PATTERN.matcher(input).matches();
    }
}

