/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.collection;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class MergedMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, V> first;
    private final Map<K, V> second;
    final Set<Map.Entry<K, V>> entrySet = new AbstractSet<Map.Entry<K, V>>(){

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.stream().iterator();
        }

        @Override
        public int size() {
            return (int)this.stream().count();
        }

        @Override
        public Stream<Map.Entry<K, V>> stream() {
            return Stream.concat(MergedMap.this.first.entrySet().stream(), MergedMap.this.secondStream()).map(e -> new AbstractMap.SimpleImmutableEntry(e.getKey(), e.getValue()));
        }

        @Override
        public Stream<Map.Entry<K, V>> parallelStream() {
            return (Stream)this.stream().parallel();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return this.stream().spliterator();
        }
    };

    public MergedMap(Map<K, V> first, Map<K, V> second) {
        this.first = Objects.requireNonNull(first);
        this.second = Objects.requireNonNull(second);
    }

    Stream<Map.Entry<K, V>> secondStream() {
        return this.second.entrySet().stream().filter(e -> !this.first.containsKey(e.getKey()));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.first.containsKey(key) || this.second.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.first.containsValue(value) || this.secondStream().anyMatch(Predicate.isEqual(value));
    }

    @Override
    public V get(Object key) {
        V v = this.first.get(key);
        return v != null ? v : this.second.get(key);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V v = this.first.get(key);
        return v != null ? v : this.second.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.first.forEach(action);
        this.second.forEach((k, v) -> {
            if (!this.first.containsKey(k)) {
                action.accept((K)k, (V)v);
            }
        });
    }
}

