/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.collection;

import net.minestom.server.utils.collection.ObjectArrayImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@ApiStatus.Internal
public sealed interface ObjectArray<T>
permits ObjectArrayImpl.SingleThread, ObjectArrayImpl.Concurrent {
    @NotNull
    public static <T> ObjectArray<T> singleThread(int initialSize) {
        return new ObjectArrayImpl.SingleThread(initialSize);
    }

    @NotNull
    public static <T> ObjectArray<T> singleThread() {
        return ObjectArray.singleThread(0);
    }

    @NotNull
    public static <T> ObjectArray<T> concurrent(int initialSize) {
        return new ObjectArrayImpl.Concurrent(initialSize);
    }

    @NotNull
    public static <T> ObjectArray<T> concurrent() {
        return ObjectArray.concurrent(0);
    }

    public @UnknownNullability T get(int var1);

    public void set(int var1, @Nullable T var2);

    default public void remove(int index) {
        this.set(index, null);
    }

    public void trim();

    public @UnknownNullability T @NotNull [] arrayCopy(@NotNull Class<T> var1);
}

