/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biomes;

import java.util.Locale;
import net.minestom.server.coordinate.Point;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.biomes.BiomeEffects;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;

public final class Biome {
    private static final BiomeEffects DEFAULT_EFFECTS = BiomeEffects.builder().fogColor(12638463).skyColor(7907327).waterColor(4159204).waterFogColor(329011).build();
    private int id;
    private final NamespaceID name;
    private final float depth;
    private final float temperature;
    private final float scale;
    private final float downfall;
    private final boolean hasPrecipitation;
    private final Category category;
    private final BiomeEffects effects;
    private final Precipitation precipitation;
    private final TemperatureModifier temperatureModifier;

    Biome(NamespaceID name, float depth, float temperature, float scale, float downfall, boolean hasPrecipitation, Category category, BiomeEffects effects, Precipitation precipitation, TemperatureModifier temperatureModifier) {
        this.name = name;
        this.depth = depth;
        this.temperature = temperature;
        this.scale = scale;
        this.downfall = downfall;
        this.hasPrecipitation = hasPrecipitation;
        this.category = category;
        this.effects = effects;
        this.precipitation = precipitation;
        this.temperatureModifier = temperatureModifier;
    }

    void setId(int id) {
        this.id = id;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public NBTCompound toNbt() {
        Check.notNull(this.name, "The biome namespace cannot be null");
        Check.notNull(this.effects, "The biome effects cannot be null");
        return NBT.Compound(nbt -> {
            nbt.setString("name", this.name.toString());
            nbt.setInt("id", this.id());
            nbt.set("element", (NBT)NBT.Compound(element -> {
                element.setFloat("depth", this.depth);
                element.setFloat("temperature", this.temperature);
                element.setFloat("scale", this.scale);
                element.setFloat("downfall", this.downfall);
                element.setString("category", this.category.name().toLowerCase(Locale.ROOT));
                if (this.isHasPrecipitation()) {
                    element.setByte("has_precipitation", (byte)1);
                } else {
                    element.setByte("has_precipitation", (byte)0);
                }
                element.setString("precipitation", this.precipitation.name().toLowerCase(Locale.ROOT));
                if (this.temperatureModifier != TemperatureModifier.NONE) {
                    element.setString("temperature_modifier", this.temperatureModifier.name().toLowerCase(Locale.ROOT));
                }
                element.set("effects", (NBT)this.effects.toNbt());
            }));
        });
    }

    public int id() {
        return this.id;
    }

    public NamespaceID name() {
        return this.name;
    }

    public boolean isHasPrecipitation() {
        return this.hasPrecipitation;
    }

    public float depth() {
        return this.depth;
    }

    public float temperature() {
        return this.temperature;
    }

    public float scale() {
        return this.scale;
    }

    public float downfall() {
        return this.downfall;
    }

    public Category category() {
        return this.category;
    }

    public BiomeEffects effects() {
        return this.effects;
    }

    public Precipitation precipitation() {
        return this.precipitation;
    }

    public TemperatureModifier temperatureModifier() {
        return this.temperatureModifier;
    }

    public static enum Category {
        NONE,
        TAIGA,
        EXTREME_HILLS,
        JUNGLE,
        MESA,
        PLAINS,
        SAVANNA,
        ICY,
        THE_END,
        BEACH,
        FOREST,
        OCEAN,
        DESERT,
        RIVER,
        SWAMP,
        MUSHROOM,
        NETHER,
        UNDERGROUND,
        MOUNTAIN;

    }

    public static enum Precipitation {
        NONE,
        RAIN,
        SNOW;

    }

    public static enum TemperatureModifier {
        NONE,
        FROZEN;

    }

    public static final class Builder {
        private NamespaceID name;
        private float depth = 0.2f;
        private float temperature = 0.25f;
        private float scale = 0.2f;
        private float downfall = 0.8f;
        private boolean hasPrecipitation = false;
        private Category category = Category.NONE;
        private BiomeEffects effects = DEFAULT_EFFECTS;
        private Precipitation precipitation = Precipitation.RAIN;
        private TemperatureModifier temperatureModifier = TemperatureModifier.NONE;

        Builder() {
        }

        public Builder name(NamespaceID name) {
            this.name = name;
            return this;
        }

        public Builder showPrecipitation(boolean hasPrecipitation) {
            this.hasPrecipitation = hasPrecipitation;
            return this;
        }

        public Builder depth(float depth) {
            this.depth = depth;
            return this;
        }

        public Builder temperature(float temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder scale(float scale) {
            this.scale = scale;
            return this;
        }

        public Builder downfall(float downfall) {
            this.downfall = downfall;
            return this;
        }

        public Builder category(Category category) {
            this.category = category;
            return this;
        }

        public Builder effects(BiomeEffects effects) {
            this.effects = effects;
            return this;
        }

        public Builder precipitation(Precipitation precipitation) {
            this.precipitation = precipitation;
            return this;
        }

        public Builder temperatureModifier(TemperatureModifier temperatureModifier) {
            this.temperatureModifier = temperatureModifier;
            return this;
        }

        public Biome build() {
            return new Biome(this.name, this.depth, this.temperature, this.scale, this.downfall, this.hasPrecipitation, this.category, this.effects, this.precipitation, this.temperatureModifier);
        }
    }

    public static interface Getter {
        @NotNull
        public Biome getBiome(int var1, int var2, int var3);

        @NotNull
        default public Biome getBiome(@NotNull Point point) {
            return this.getBiome(point.blockX(), point.blockY(), point.blockZ());
        }
    }

    public static interface Setter {
        public void setBiome(int var1, int var2, int var3, @NotNull Biome var4);

        default public void setBiome(@NotNull Point blockPosition, @NotNull Biome biome) {
            this.setBiome(blockPosition.blockX(), blockPosition.blockY(), blockPosition.blockZ(), biome);
        }
    }
}

