/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biomes;

import java.util.Locale;
import java.util.Map;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.world.biomes.BiomeParticle;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;

public record BiomeEffects(int fogColor, int skyColor, int waterColor, int waterFogColor, int foliageColor, int grassColor, GrassColorModifier grassColorModifier, BiomeParticle biomeParticle, NamespaceID ambientSound, MoodSound moodSound, AdditionsSound additionsSound, Music music) {
    public static Builder builder() {
        return new Builder();
    }

    public NBTCompound toNbt() {
        return NBT.Compound(nbt -> {
            nbt.setInt("fog_color", this.fogColor);
            if (this.foliageColor != -1) {
                nbt.setInt("foliage_color", this.foliageColor);
            }
            if (this.grassColor != -1) {
                nbt.setInt("grass_color", this.grassColor);
            }
            nbt.setInt("sky_color", this.skyColor);
            nbt.setInt("water_color", this.waterColor);
            nbt.setInt("water_fog_color", this.waterFogColor);
            if (this.grassColorModifier != null) {
                nbt.setString("grass_color_modifier", this.grassColorModifier.name().toLowerCase(Locale.ROOT));
            }
            if (this.biomeParticle != null) {
                nbt.set("particle", (NBT)this.biomeParticle.toNbt());
            }
            if (this.ambientSound != null) {
                nbt.setString("ambient_sound", this.ambientSound.toString());
            }
            if (this.moodSound != null) {
                nbt.set("mood_sound", (NBT)this.moodSound.toNbt());
            }
            if (this.additionsSound != null) {
                nbt.set("additions_sound", (NBT)this.additionsSound.toNbt());
            }
            if (this.music != null) {
                nbt.set("music", (NBT)this.music.toNbt());
            }
        });
    }

    public static enum GrassColorModifier {
        NONE,
        DARK_FOREST,
        SWAMP;

    }

    public record MoodSound(NamespaceID sound, int tickDelay, int blockSearchExtent, double offset) {
        @NotNull
        public NBTCompound toNbt() {
            return NBT.Compound(Map.of("sound", NBT.String((String)this.sound.toString()), "tick_delay", NBT.Int((int)this.tickDelay), "block_search_extent", NBT.Int((int)this.blockSearchExtent), "offset", NBT.Double((double)this.offset)));
        }
    }

    public record AdditionsSound(NamespaceID sound, double tickChance) {
        @NotNull
        public NBTCompound toNbt() {
            return NBT.Compound(Map.of("sound", NBT.String((String)this.sound.toString()), "tick_chance", NBT.Double((double)this.tickChance)));
        }
    }

    public record Music(NamespaceID sound, int minDelay, int maxDelay, boolean replaceCurrentMusic) {
        @NotNull
        public NBTCompound toNbt() {
            return NBT.Compound(Map.of("sound", NBT.String((String)this.sound.toString()), "min_delay", NBT.Int((int)this.minDelay), "max_delay", NBT.Int((int)this.maxDelay), "replace_current_music", NBT.Boolean((boolean)this.replaceCurrentMusic)));
        }
    }

    public static final class Builder {
        private int fogColor;
        private int skyColor;
        private int waterColor;
        private int waterFogColor;
        private int foliageColor = -1;
        private int grassColor = -1;
        private GrassColorModifier grassColorModifier;
        private BiomeParticle biomeParticle;
        private NamespaceID ambientSound;
        private MoodSound moodSound;
        private AdditionsSound additionsSound;
        private Music music;

        Builder() {
        }

        public Builder fogColor(int fogColor) {
            this.fogColor = fogColor;
            return this;
        }

        public Builder skyColor(int skyColor) {
            this.skyColor = skyColor;
            return this;
        }

        public Builder waterColor(int waterColor) {
            this.waterColor = waterColor;
            return this;
        }

        public Builder waterFogColor(int waterFogColor) {
            this.waterFogColor = waterFogColor;
            return this;
        }

        public Builder foliageColor(int foliageColor) {
            this.foliageColor = foliageColor;
            return this;
        }

        public Builder grassColor(int grassColor) {
            this.grassColor = grassColor;
            return this;
        }

        public Builder grassColorModifier(GrassColorModifier grassColorModifier) {
            this.grassColorModifier = grassColorModifier;
            return this;
        }

        public Builder biomeParticle(BiomeParticle biomeParticle) {
            this.biomeParticle = biomeParticle;
            return this;
        }

        public Builder ambientSound(NamespaceID ambientSound) {
            this.ambientSound = ambientSound;
            return this;
        }

        public Builder moodSound(MoodSound moodSound) {
            this.moodSound = moodSound;
            return this;
        }

        public Builder additionsSound(AdditionsSound additionsSound) {
            this.additionsSound = additionsSound;
            return this;
        }

        public Builder music(Music music) {
            this.music = music;
            return this;
        }

        public BiomeEffects build() {
            return new BiomeEffects(this.fogColor, this.skyColor, this.waterColor, this.waterFogColor, this.foliageColor, this.grassColor, this.grassColorModifier, this.biomeParticle, this.ambientSound, this.moodSound, this.additionsSound, this.music);
        }
    }
}

