/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biomes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.world.biomes.Biome;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BiomeManager {
    private final List<Biome> biomes = new ArrayList<Biome>();
    private static final Logger LOGGER = LoggerFactory.getLogger(BiomeManager.class);

    public synchronized void addBiome(Biome biome) {
        if (this.biomes.stream().anyMatch(listBiome -> listBiome.name().equals(biome.name()))) {
            LOGGER.error("You cannot register the biome because it is already registered. Please remove the biome to overwrite it");
            return;
        }
        this.biomes.add(biome);
    }

    public synchronized void removeBiome(Biome biome) {
        this.biomes.remove(biome);
    }

    public synchronized Collection<Biome> unmodifiableCollection() {
        return Collections.unmodifiableCollection(this.biomes);
    }

    public synchronized Biome getById(int id) {
        return this.biomes.get(id);
    }

    public synchronized Biome getByName(NamespaceID namespaceID) {
        Biome biome = null;
        for (Biome biomeT : this.biomes) {
            if (!biomeT.name().equals(namespaceID)) continue;
            biome = biomeT;
            break;
        }
        return biome;
    }

    public synchronized NBTCompound toNBT() {
        ArrayList<Biome> biomes = new ArrayList<Biome>(this.unmodifiableCollection());
        List<NBTCompound> nbtCompounds = IntStream.range(0, biomes.size()).mapToObj(i -> {
            Biome biome = (Biome)biomes.get(i);
            biome.setId(i);
            return biome;
        }).map(Biome::toNbt).toList();
        return NBT.Compound(Map.of("type", NBT.String((String)"minecraft:worldgen/biome"), "value", NBT.List((NBTType)NBTType.TAG_Compound, nbtCompounds)));
    }
}

