/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biomes;

import net.minestom.server.MinecraftServer;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.world.biomes.Biome;
import net.minestom.server.world.biomes.BiomeEffects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Biomes {
    SNOWY_SLOPES(Biome.builder().name(NamespaceID.from("minecraft:snowy_slopes")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(-0.3f).downfall(0.9f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8560639).build()).build()),
    OLD_GROWTH_PINE_TAIGA(Biome.builder().name(NamespaceID.from("minecraft:old_growth_pine_taiga")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.3f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8168447).build()).build()),
    MUSHROOM_FIELDS(Biome.builder().name(NamespaceID.from("minecraft:mushroom_fields")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.9f).downfall(1.0f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7842047).build()).build()),
    TAIGA(Biome.builder().name(NamespaceID.from("minecraft:taiga")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.25f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233983).build()).build()),
    DEEP_OCEAN(Biome.builder().name(NamespaceID.from("minecraft:deep_ocean")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8103167).build()).build()),
    ERODED_BADLANDS(Biome.builder().name(NamespaceID.from("minecraft:eroded_badlands")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7254527).grassColor(9470285).foliageColor(10387789).build()).build()),
    FROZEN_RIVER(Biome.builder().name(NamespaceID.from("minecraft:frozen_river")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.0f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(3750089).waterFogColor(329011).skyColor(8364543).build()).build()),
    END_HIGHLANDS(Biome.builder().name(NamespaceID.from("minecraft:end_highlands")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.5f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xA080A0).waterColor(4159204).waterFogColor(329011).skyColor(0).build()).build()),
    CHERRY_GROVE(Biome.builder().name(NamespaceID.from("minecraft:cherry_grove")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(6141935).waterFogColor(6141935).skyColor(8103167).grassColor(11983713).foliageColor(11983713).build()).build()),
    SUNFLOWER_PLAINS(Biome.builder().name(NamespaceID.from("minecraft:sunflower_plains")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.8f).downfall(0.4f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7907327).build()).build()),
    BIRCH_FOREST(Biome.builder().name(NamespaceID.from("minecraft:birch_forest")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.6f).downfall(0.6f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8037887).build()).build()),
    WINDSWEPT_HILLS(Biome.builder().name(NamespaceID.from("minecraft:windswept_hills")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.2f).downfall(0.3f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233727).build()).build()),
    BAMBOO_JUNGLE(Biome.builder().name(NamespaceID.from("minecraft:bamboo_jungle")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.95f).downfall(0.9f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7842047).build()).build()),
    WOODED_BADLANDS(Biome.builder().name(NamespaceID.from("minecraft:wooded_badlands")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7254527).grassColor(9470285).foliageColor(10387789).build()).build()),
    BADLANDS(Biome.builder().name(NamespaceID.from("minecraft:badlands")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7254527).grassColor(9470285).foliageColor(10387789).build()).build()),
    SAVANNA_PLATEAU(Biome.builder().name(NamespaceID.from("minecraft:savanna_plateau")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7254527).build()).build()),
    BEACH(Biome.builder().name(NamespaceID.from("minecraft:beach")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.8f).downfall(0.4f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7907327).build()).build()),
    DARK_FOREST(Biome.builder().name(NamespaceID.from("minecraft:dark_forest")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.7f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7972607).build()).build()),
    STONY_PEAKS(Biome.builder().name(NamespaceID.from("minecraft:stony_peaks")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(1.0f).downfall(0.3f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7776511).build()).build()),
    MANGROVE_SWAMP(Biome.builder().name(NamespaceID.from("minecraft:mangrove_swamp")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.8f).downfall(0.9f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(3832426).waterFogColor(5077600).skyColor(7907327).foliageColor(9285927).build()).build()),
    SPARSE_JUNGLE(Biome.builder().name(NamespaceID.from("minecraft:sparse_jungle")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.95f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7842047).build()).build()),
    LUKEWARM_OCEAN(Biome.builder().name(NamespaceID.from("minecraft:lukewarm_ocean")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4566514).waterFogColor(267827).skyColor(8103167).build()).build()),
    RIVER(Biome.builder().name(NamespaceID.from("minecraft:river")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8103167).build()).build()),
    STONY_SHORE(Biome.builder().name(NamespaceID.from("minecraft:stony_shore")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.2f).downfall(0.3f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233727).build()).build()),
    WARPED_FOREST(Biome.builder().name(NamespaceID.from("minecraft:warped_forest")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(1705242).waterColor(4159204).waterFogColor(329011).skyColor(7254527).build()).build()),
    SNOWY_PLAINS(Biome.builder().name(NamespaceID.from("minecraft:snowy_plains")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.0f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8364543).build()).build()),
    DRIPSTONE_CAVES(Biome.builder().name(NamespaceID.from("minecraft:dripstone_caves")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.8f).downfall(0.4f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7907327).build()).build()),
    SNOWY_TAIGA(Biome.builder().name(NamespaceID.from("minecraft:snowy_taiga")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(-0.5f).downfall(0.4f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4020182).waterFogColor(329011).skyColor(8625919).build()).build()),
    GROVE(Biome.builder().name(NamespaceID.from("minecraft:grove")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(-0.2f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8495359).build()).build()),
    SWAMP(Biome.builder().name(NamespaceID.from("minecraft:swamp")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.8f).downfall(0.9f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(6388580).waterFogColor(2302743).skyColor(7907327).foliageColor(6975545).build()).build()),
    JAGGED_PEAKS(Biome.builder().name(NamespaceID.from("minecraft:jagged_peaks")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(-0.7f).downfall(0.9f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8756735).build()).build()),
    COLD_OCEAN(Biome.builder().name(NamespaceID.from("minecraft:cold_ocean")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4020182).waterFogColor(329011).skyColor(8103167).build()).build()),
    FOREST(Biome.builder().name(NamespaceID.from("minecraft:forest")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.7f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7972607).build()).build()),
    LUSH_CAVES(Biome.builder().name(NamespaceID.from("minecraft:lush_caves")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8103167).build()).build()),
    BASALT_DELTAS(Biome.builder().name(NamespaceID.from("minecraft:basalt_deltas")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(6840176).waterColor(4159204).waterFogColor(329011).skyColor(7254527).build()).build()),
    DEEP_COLD_OCEAN(Biome.builder().name(NamespaceID.from("minecraft:deep_cold_ocean")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4020182).waterFogColor(329011).skyColor(8103167).build()).build()),
    ICE_SPIKES(Biome.builder().name(NamespaceID.from("minecraft:ice_spikes")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.0f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8364543).build()).build()),
    END_MIDLANDS(Biome.builder().name(NamespaceID.from("minecraft:end_midlands")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.5f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xA080A0).waterColor(4159204).waterFogColor(329011).skyColor(0).build()).build()),
    FROZEN_OCEAN(Biome.builder().name(NamespaceID.from("minecraft:frozen_ocean")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.0f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(3750089).waterFogColor(329011).skyColor(8364543).build()).build()),
    DESERT(Biome.builder().name(NamespaceID.from("minecraft:desert")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7254527).build()).build()),
    DEEP_FROZEN_OCEAN(Biome.builder().name(NamespaceID.from("minecraft:deep_frozen_ocean")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(3750089).waterFogColor(329011).skyColor(8103167).build()).build()),
    WINDSWEPT_FOREST(Biome.builder().name(NamespaceID.from("minecraft:windswept_forest")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.2f).downfall(0.3f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233727).build()).build()),
    JUNGLE(Biome.builder().name(NamespaceID.from("minecraft:jungle")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.95f).downfall(0.9f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7842047).build()).build()),
    OCEAN(Biome.builder().name(NamespaceID.from("minecraft:ocean")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8103167).build()).build()),
    OLD_GROWTH_SPRUCE_TAIGA(Biome.builder().name(NamespaceID.from("minecraft:old_growth_spruce_taiga")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.25f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233983).build()).build()),
    SNOWY_BEACH(Biome.builder().name(NamespaceID.from("minecraft:snowy_beach")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.05f).downfall(0.3f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4020182).waterFogColor(329011).skyColor(8364543).build()).build()),
    WINDSWEPT_SAVANNA(Biome.builder().name(NamespaceID.from("minecraft:windswept_savanna")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7254527).build()).build()),
    END_BARRENS(Biome.builder().name(NamespaceID.from("minecraft:end_barrens")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.5f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xA080A0).waterColor(4159204).waterFogColor(329011).skyColor(0).build()).build()),
    WARM_OCEAN(Biome.builder().name(NamespaceID.from("minecraft:warm_ocean")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4445678).waterFogColor(270131).skyColor(8103167).build()).build()),
    DEEP_LUKEWARM_OCEAN(Biome.builder().name(NamespaceID.from("minecraft:deep_lukewarm_ocean")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4566514).waterFogColor(267827).skyColor(8103167).build()).build()),
    FLOWER_FOREST(Biome.builder().name(NamespaceID.from("minecraft:flower_forest")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.7f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7972607).build()).build()),
    SOUL_SAND_VALLEY(Biome.builder().name(NamespaceID.from("minecraft:soul_sand_valley")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(1787717).waterColor(4159204).waterFogColor(329011).skyColor(7254527).build()).build()),
    NETHER_WASTES(Biome.builder().name(NamespaceID.from("minecraft:nether_wastes")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0x330808).waterColor(4159204).waterFogColor(329011).skyColor(7254527).build()).build()),
    FROZEN_PEAKS(Biome.builder().name(NamespaceID.from("minecraft:frozen_peaks")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(-0.7f).downfall(0.9f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8756735).build()).build()),
    THE_END(Biome.builder().name(NamespaceID.from("minecraft:the_end")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.5f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xA080A0).waterColor(4159204).waterFogColor(329011).skyColor(0).build()).build()),
    SMALL_END_ISLANDS(Biome.builder().name(NamespaceID.from("minecraft:small_end_islands")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.5f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xA080A0).waterColor(4159204).waterFogColor(329011).skyColor(0).build()).build()),
    OLD_GROWTH_BIRCH_FOREST(Biome.builder().name(NamespaceID.from("minecraft:old_growth_birch_forest")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.6f).downfall(0.6f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8037887).build()).build()),
    CRIMSON_FOREST(Biome.builder().name(NamespaceID.from("minecraft:crimson_forest")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0x330303).waterColor(4159204).waterFogColor(329011).skyColor(7254527).build()).build()),
    THE_VOID(Biome.builder().name(NamespaceID.from("minecraft:the_void")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.5f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8103167).build()).build()),
    DEEP_DARK(Biome.builder().name(NamespaceID.from("minecraft:deep_dark")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.8f).downfall(0.4f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7907327).build()).build()),
    MEADOW(Biome.builder().name(NamespaceID.from("minecraft:meadow")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.5f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(937679).waterFogColor(329011).skyColor(8103167).build()).build()),
    WINDSWEPT_GRAVELLY_HILLS(Biome.builder().name(NamespaceID.from("minecraft:windswept_gravelly_hills")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.2f).downfall(0.3f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233727).build()).build()),
    SAVANNA(Biome.builder().name(NamespaceID.from("minecraft:savanna")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7254527).build()).build()),
    PLAINS(Biome.builder().name(NamespaceID.from("minecraft:plains")).category(Biome.Category.NONE).depth(0.125f).scale(0.05f).temperature(0.8f).downfall(0.4f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7907327).build()).build());

    private static final Biomes[] VALUES;
    private final Biome biome;

    private Biomes(Biome biome) {
        this.biome = biome;
    }

    @NotNull
    public Biome biome() {
        return this.biome;
    }

    @Nullable
    public static Biomes getValue(int id) {
        return VALUES[id];
    }

    public static void registerBiomes() {
        for (Biomes biome : VALUES) {
            MinecraftServer.getBiomeManager().addBiome(biome.biome());
        }
    }

    static {
        VALUES = Biomes.values();
    }
}

