/*
 * BEGIN_HEADER - DO NOT EDIT
 *
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://open-esb.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * https://open-esb.dev.java.net/public/CDDLv1.0.html.
 * If applicable add the following below this CDDL HEADER,
 * with the fields enclosed by brackets "[]" replaced with
 * your own identifying information: Portions Copyright
 * [year] [name of copyright owner]
 */

/*
 * @(#)ModelEngineInstaller.java
 * Copyright 2004-2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 * END_HEADER - DO NOT EDIT
 */
package com.sun.jbi.management.engine;

import javax.jbi.JBIException;
import javax.management.ObjectName;
import javax.jbi.component.Bootstrap;
import javax.jbi.component.InstallationContext;

/**
 * The ModelEngineInstaller implements the management controls for a standard
 * engine installer class, and can be extended to provide full installer
 * functionality for a JBI Framework engine component.
 *
 * @author Sun Microsystems, Inc.
 */
public abstract class ModelEngineInstaller 
    implements Bootstrap
{
    /**
     * Initializes the installation environment for a component. This method is
     * expected to save any information from the installation context that
     * may be needed by other methods.
     * <p>
     * If the component needs to register an optional installer configuration
     * MBean, it MUST do so during execution of this method, or the
     * getExtensionMBean() method.
     * <p>
     * This method must be called after the installation root (available
     * through the installContext parameter) is prepared.
     * 
     * @param installContext the context containing information from the
     *                       install command and from the component installation
     *                       ZIP file; this must be non-null.
     * @exception JBIException when there is an error requiring that
     *            the installation be terminated
     */
    public void init(InstallationContext installContext)
        throws JBIException
    {
    }

    /**
     * Cleans up any resources allocated by the bootstrap implementation,
     * including performing deregistration of the extension MBean, if 
     * applicable.
     * <p>
     * This method must be called after the onInstall() or onUninstall() method
     * is called, whether it succeeds or fails. It must be called after
     * init() is called, if init() fails by throwing an exception.
     * 
     * @exception JBIException if the bootstrap cannot clean up allocated
     *            resources
     */
    public void cleanUp() throws JBIException
    {
    }

    /**
     * Obtains the <code>ObjectName</code> of the optional installer 
     * configuration MBean. If none is provided by this component, this method 
     * must return <code>null</code>.
     * <p>
     * This method must be called before onInstall() (or onUninstall()) is
     * called by the JBI implementation.
     * 
     * @return ObjectName of the optional installer configuration MBean; 
     *         returns <code>null</code> if there is no such MBean
     */
    public ObjectName getExtensionMBeanName()
    {
        return (ObjectName) null;
    }

    /**
     * Called at the beginning of installation of a component to perform any 
     * special installation tasks required by the component. 
     * <p>
     * This method must not be called if the init() method failed with an
     * exception.
     * 
     * @exception JBIException when there is an error requiring that
     *            the installation be terminated
     */
    public void onInstall()
        throws JBIException
    {
    }

    /**
     * Called at the beginning of uninstallation of a component to perform any
     * special uninstallation tasks required by the component.
     * <p>
     * This method must not be called if the init() method failed with an
     * exception.
     * 
     * @exception JBIException when there is an error requiring that
     *            the uninstallation be terminated.
     */
    public void onUninstall()
        throws JBIException
    {
    }
}
