/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.config;

import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.config.RuntimeConfiguration;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.Updater;
import javax.jbi.JBIException;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanInfo;

public class GlobalConfiguration
extends RuntimeConfiguration {
    private static final String DOMAIN = "domain";

    public GlobalConfiguration(ModelMBeanInfo mbeanInfo, ConfigurationCategory category) throws Exception {
        super(mbeanInfo, category, null);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            if (!GlobalConfiguration.getEnvironmentContext().getPlatformContext().isAdminServer()) {
                this.persistDomainConfig();
                Updater updater = this.getRegistry().getUpdater();
                String attrValue = attribute.getValue() == null ? "null" : attribute.getValue().toString();
                updater.setAttribute(DOMAIN, this.mCategory, attribute.getName(), attrValue);
            }
        }
        catch (RegistryException ex) {
            String errMsg = GlobalConfiguration.getTranslator().getString("JBI_ADMIN_SET_GLOBAL_CFG_ATTRIB_FAILED", (Object)attribute.getName(), (Object)this.mCategory.toString(), (Object)ex.getMessage());
            JBIException jbiEx = new JBIException(errMsg);
            throw new MBeanException((Exception)jbiEx, errMsg);
        }
    }

    @Override
    public void persist() throws Exception {
        super.persist();
    }

    @Override
    public void deleteOverride(String attrName) throws Exception {
        Updater updater = this.getRegistry().getUpdater();
        updater.deleteAttribute(this.mCategory, attrName);
    }
}

