/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.internal.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipFactory {
    private byte[] mBuffer;
    private String mDir;

    public ZipFactory(String dir) {
        this.mDir = dir;
        this.mBuffer = new byte[8092];
    }

    public void unZip(File zpFile) throws IOException, ZipException {
        if (!zpFile.getName().endsWith(".zip")) {
            throw new ZipException("Not a zip file? " + zpFile.getName());
        }
        ZipFile zp = new ZipFile(zpFile);
        Enumeration<? extends ZipEntry> all = zp.entries();
        while (all.hasMoreElements()) {
            this.getEntry(zp, all.nextElement());
        }
        zp.close();
    }

    private void getEntry(ZipFile zp, ZipEntry entry) throws IOException {
        String entryName = entry.getName();
        if (entryName.endsWith("/")) {
            new File(this.mDir, entryName).mkdirs();
            return;
        }
        File f = new File(this.mDir, entryName);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        FileOutputStream fostream = new FileOutputStream(f);
        InputStream istream = zp.getInputStream(entry);
        int n = 0;
        while ((n = istream.read(this.mBuffer)) > 0) {
            fostream.write(this.mBuffer, 0, n);
        }
        try {
            istream.close();
            fostream.close();
        }
        catch (IOException e) {
            Logger.getLogger("com.sun.jbi.management.internal.support").log(Level.WARNING, e.getClass().getName(), e);
        }
    }
}

