/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.registry.xml;

import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.descriptor.Component;
import com.sun.jbi.management.descriptor.ComponentDescriptor;
import com.sun.jbi.management.registry.GenericQuery;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.xml.ClusterListType;
import com.sun.jbi.management.registry.xml.ComponentRefType;
import com.sun.jbi.management.registry.xml.Components;
import com.sun.jbi.management.registry.xml.ConfigCategoryType;
import com.sun.jbi.management.registry.xml.ConfigType;
import com.sun.jbi.management.registry.xml.Configs;
import com.sun.jbi.management.registry.xml.DomainComponentType;
import com.sun.jbi.management.registry.xml.DomainEntityType;
import com.sun.jbi.management.registry.xml.DomainSharedLibraryType;
import com.sun.jbi.management.registry.xml.InstalledComponentsListType;
import com.sun.jbi.management.registry.xml.Jbi;
import com.sun.jbi.management.registry.xml.PropertyType;
import com.sun.jbi.management.registry.xml.RegistryImpl;
import com.sun.jbi.management.registry.xml.RegistryUtil;
import com.sun.jbi.management.registry.xml.ServerListType;
import com.sun.jbi.management.registry.xml.ServiceAssemblies;
import com.sun.jbi.management.registry.xml.ServiceAssemblyRefType;
import com.sun.jbi.management.registry.xml.ServiceUnitListType;
import com.sun.jbi.management.registry.xml.ServiceUnitType;
import com.sun.jbi.management.registry.xml.SharedLibraries;
import com.sun.jbi.management.registry.xml.SharedLibraryRefType;
import com.sun.jbi.management.repository.Archive;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.repository.Repository;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.util.LockManager;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class GenericQueryImpl
implements GenericQuery {
    private Jbi mJbiRegistry;
    private RegistryImpl mRegistry;
    private boolean mValidate;
    private boolean mReadonly;
    private ManagementContext mMgtCtx;
    private StringTranslator mTranslator;
    private Logger mLog;
    private LockManager mRegObjLM;
    private RegistryUtil mRegUtil;
    private Map<String, String> mComponentCache;
    private Map<String, String> mSharedLibraryCache;
    private Map<String, String> mServiceAssemblyCache;
    private Map<String, com.sun.jbi.management.descriptor.Jbi> mJbiComponentCache;
    private Map<String, com.sun.jbi.management.descriptor.Jbi> mJbiSharedLibraryCache;
    private Map<String, com.sun.jbi.management.descriptor.Jbi> mJbiServiceAssemblyCache;

    public GenericQueryImpl(Jbi jbi, ManagementContext mgtCtx, boolean validate, RegistryImpl registry) {
        this.mJbiRegistry = jbi;
        this.mRegistry = registry;
        this.mValidate = validate;
        this.mReadonly = registry.getProperty("com.sun.jbi.registry.readonly") != null;
        this.mMgtCtx = mgtCtx;
        this.mLog = mgtCtx.getLogger();
        this.mRegUtil = new RegistryUtil(mgtCtx, registry);
        this.mTranslator = mgtCtx.getEnvironmentContext().getStringTranslator("com.sun.jbi.management");
        this.mComponentCache = Collections.synchronizedMap(new HashMap());
        this.mSharedLibraryCache = Collections.synchronizedMap(new HashMap());
        this.mServiceAssemblyCache = Collections.synchronizedMap(new HashMap());
        this.mJbiComponentCache = Collections.synchronizedMap(new HashMap());
        this.mJbiSharedLibraryCache = Collections.synchronizedMap(new HashMap());
        this.mJbiServiceAssemblyCache = Collections.synchronizedMap(new HashMap());
        this.mRegObjLM = this.mRegistry.getRegistryObjectLockManager();
    }

    @Override
    public List<String> getServersInstallingComponent(String componentName) throws RegistryException {
        ArrayList<String> resServers = new ArrayList<String>();
        if (this.isComponentRegistered(componentName)) {
            this.mRegObjLM.acquireReadLock();
            if (this.mJbiRegistry.getServers() != null) {
                List<InstalledComponentsListType> servers = this.mJbiRegistry.getServers().getServer();
                for (InstalledComponentsListType server : servers) {
                    List<ComponentRefType> refs = server.getComponentRef();
                    for (ComponentRefType compRef : refs) {
                        if (!compRef.getNameRef().equals(componentName)) continue;
                        resServers.add(server.getNameRef());
                    }
                }
            }
            this.mRegObjLM.releaseReadLock();
        }
        return resServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getServersInstallingSharedLibrary(String sharedLibraryName) throws RegistryException {
        ArrayList<String> resServers = new ArrayList<String>();
        if (this.isSharedLibraryRegistered(sharedLibraryName)) {
            this.mRegObjLM.acquireReadLock();
            try {
                if (this.mJbiRegistry.getServers() != null) {
                    List<InstalledComponentsListType> servers = this.mJbiRegistry.getServers().getServer();
                    for (InstalledComponentsListType server : servers) {
                        List<SharedLibraryRefType> refs = server.getSharedLibraryRef();
                        for (SharedLibraryRefType slRef : refs) {
                            if (!slRef.getNameRef().equals(sharedLibraryName)) continue;
                            resServers.add(server.getNameRef());
                        }
                    }
                }
            }
            finally {
                this.mRegObjLM.releaseReadLock();
            }
        }
        return resServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getServersDeployingServiceAssembly(String serviceAssemblyName) throws RegistryException {
        ArrayList<String> resServers = new ArrayList<String>();
        if (this.isServiceAssemblyRegistered(serviceAssemblyName)) {
            this.mRegObjLM.acquireReadLock();
            try {
                if (this.mJbiRegistry.getServers() != null) {
                    List<InstalledComponentsListType> servers = this.mJbiRegistry.getServers().getServer();
                    for (InstalledComponentsListType server : servers) {
                        List<ServiceAssemblyRefType> refs = server.getServiceAssemblyRef();
                        for (ServiceAssemblyRefType saRef : refs) {
                            if (!saRef.getNameRef().equals(serviceAssemblyName)) continue;
                            resServers.add(server.getNameRef());
                        }
                    }
                }
            }
            finally {
                this.mRegObjLM.releaseReadLock();
            }
        }
        return resServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getClustersInstallingComponent(String componentName) throws RegistryException {
        ArrayList<String> resClusters = new ArrayList<String>();
        if (this.isComponentRegistered(componentName)) {
            this.mRegObjLM.acquireReadLock();
            try {
                if (this.mJbiRegistry.getClusters() != null) {
                    List<InstalledComponentsListType> clusters = this.mJbiRegistry.getClusters().getCluster();
                    for (InstalledComponentsListType cluster : clusters) {
                        List<ComponentRefType> refs = cluster.getComponentRef();
                        for (ComponentRefType compRef : refs) {
                            if (!compRef.getNameRef().equals(componentName)) continue;
                            resClusters.add(cluster.getNameRef());
                        }
                    }
                }
            }
            finally {
                this.mRegObjLM.releaseReadLock();
            }
        }
        return resClusters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getClustersInstallingSharedLibrary(String sharedLibraryName) throws RegistryException {
        ArrayList<String> resClusters = new ArrayList<String>();
        if (this.isSharedLibraryRegistered(sharedLibraryName)) {
            this.mRegObjLM.acquireReadLock();
            try {
                if (this.mJbiRegistry.getClusters() != null) {
                    List<InstalledComponentsListType> clusters = this.mJbiRegistry.getClusters().getCluster();
                    for (InstalledComponentsListType cluster : clusters) {
                        List<SharedLibraryRefType> refs = cluster.getSharedLibraryRef();
                        for (SharedLibraryRefType slRef : refs) {
                            if (!slRef.getNameRef().equals(sharedLibraryName)) continue;
                            resClusters.add(cluster.getNameRef());
                        }
                    }
                }
            }
            finally {
                this.mRegObjLM.releaseReadLock();
            }
        }
        return resClusters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getClustersDeployingServiceAssembly(String serviceAssemblyName) throws RegistryException {
        ArrayList<String> resClusters = new ArrayList<String>();
        if (this.isServiceAssemblyRegistered(serviceAssemblyName)) {
            this.mRegObjLM.acquireReadLock();
            try {
                if (this.mJbiRegistry.getClusters() != null) {
                    List<InstalledComponentsListType> clusters = this.mJbiRegistry.getClusters().getCluster();
                    for (InstalledComponentsListType cluster : clusters) {
                        List<ServiceAssemblyRefType> refs = cluster.getServiceAssemblyRef();
                        for (ServiceAssemblyRefType saRef : refs) {
                            if (!saRef.getNameRef().equals(serviceAssemblyName)) continue;
                            resClusters.add(cluster.getNameRef());
                        }
                    }
                }
            }
            finally {
                this.mRegObjLM.releaseReadLock();
            }
        }
        return resClusters;
    }

    @Override
    public String getComponentInstallationDescriptor(String componentName) throws RegistryException {
        String jbiXml = null;
        if (this.isComponentRegistered(componentName)) {
            if (this.mComponentCache.containsKey(componentName)) {
                jbiXml = this.mComponentCache.get(componentName);
            } else {
                Repository repos = this.mMgtCtx.getRepository();
                Archive componentArchive = null;
                componentArchive = repos.getArchive(ArchiveType.COMPONENT, componentName);
                if (componentArchive != null) {
                    jbiXml = componentArchive.getJbiXmlString(true);
                    this.mComponentCache.put(componentName, jbiXml);
                }
            }
        }
        return jbiXml;
    }

    @Override
    public ComponentDescriptor getComponentDescriptor(String componentName) throws RegistryException {
        ComponentDescriptor desc = null;
        com.sun.jbi.management.descriptor.Jbi jbiXml = this.getComponentJbi(componentName);
        if (null != jbiXml) {
            desc = new ComponentDescriptor(jbiXml);
        }
        return desc;
    }

    public com.sun.jbi.management.descriptor.Jbi getComponentJbi(String componentName) throws RegistryException {
        com.sun.jbi.management.descriptor.Jbi jbiXml = null;
        if (this.isComponentRegistered(componentName)) {
            if (this.mJbiComponentCache.containsKey(componentName)) {
                jbiXml = this.mJbiComponentCache.get(componentName);
            } else {
                Repository repos = this.mMgtCtx.getRepository();
                Archive componentArchive = null;
                componentArchive = repos.getArchive(ArchiveType.COMPONENT, componentName);
                if (componentArchive != null) {
                    jbiXml = componentArchive.getJbiXml(true);
                    this.mJbiComponentCache.put(componentName, jbiXml);
                }
            }
        }
        return jbiXml;
    }

    @Override
    public String getSharedLibraryInstallationDescriptor(String sharedLibraryName) throws RegistryException {
        String jbiXml = null;
        if (this.isSharedLibraryRegistered(sharedLibraryName)) {
            if (this.mSharedLibraryCache.containsKey(sharedLibraryName)) {
                jbiXml = this.mSharedLibraryCache.get(sharedLibraryName);
            } else {
                Repository repos = this.mMgtCtx.getRepository();
                Archive sharedLibraryArchive = null;
                sharedLibraryArchive = repos.getArchive(ArchiveType.SHARED_LIBRARY, sharedLibraryName);
                if (sharedLibraryArchive != null) {
                    jbiXml = sharedLibraryArchive.getJbiXmlString(true);
                    this.mSharedLibraryCache.put(sharedLibraryName, jbiXml);
                }
            }
        }
        return jbiXml;
    }

    public com.sun.jbi.management.descriptor.Jbi getSharedLibraryJbi(String sharedLibraryName) throws RegistryException {
        com.sun.jbi.management.descriptor.Jbi jbiXml = null;
        if (this.isSharedLibraryRegistered(sharedLibraryName)) {
            if (this.mJbiSharedLibraryCache.containsKey(sharedLibraryName)) {
                jbiXml = this.mJbiSharedLibraryCache.get(sharedLibraryName);
            } else {
                Repository repos = this.mMgtCtx.getRepository();
                Archive sharedLibraryArchive = null;
                sharedLibraryArchive = repos.getArchive(ArchiveType.SHARED_LIBRARY, sharedLibraryName);
                if (sharedLibraryArchive != null) {
                    jbiXml = sharedLibraryArchive.getJbiXml(true);
                    this.mJbiSharedLibraryCache.put(sharedLibraryName, jbiXml);
                }
            }
        }
        return jbiXml;
    }

    @Override
    public String getServiceAssemblyDeploymentDescriptor(String serviceAssemblyName) throws RegistryException {
        String jbiXml = null;
        if (this.isServiceAssemblyRegistered(serviceAssemblyName)) {
            if (this.mServiceAssemblyCache.containsKey(serviceAssemblyName)) {
                jbiXml = this.mServiceAssemblyCache.get(serviceAssemblyName);
            } else {
                Repository repos = this.mMgtCtx.getRepository();
                Archive serviceAssemblyArchive = repos.getArchive(ArchiveType.SERVICE_ASSEMBLY, serviceAssemblyName);
                if (serviceAssemblyArchive != null) {
                    jbiXml = serviceAssemblyArchive.getJbiXmlString(true);
                    this.mServiceAssemblyCache.put(serviceAssemblyName, jbiXml);
                }
            }
        }
        return jbiXml;
    }

    @Override
    public String getServiceUnitDeploymentDescriptor(String serviceAssemblyName, String serviceUnitName) throws RegistryException {
        String queryStr;
        Repository repos;
        Archive serviceUnitArchive;
        String jbiXml = null;
        if (this.isServiceAssemblyRegistered(serviceAssemblyName) && (serviceUnitArchive = (repos = this.mMgtCtx.getRepository()).getArchive(ArchiveType.SERVICE_UNIT, queryStr = serviceAssemblyName + File.separator + serviceUnitName)) != null) {
            jbiXml = serviceUnitArchive.getJbiXmlString(true);
        }
        return jbiXml;
    }

    public com.sun.jbi.management.descriptor.Jbi getServiceAssemblyJbi(String serviceAssemblyName) throws RegistryException {
        com.sun.jbi.management.descriptor.Jbi jbiXml = null;
        if (this.isServiceAssemblyRegistered(serviceAssemblyName)) {
            if (this.mJbiServiceAssemblyCache.containsKey(serviceAssemblyName)) {
                jbiXml = this.mJbiServiceAssemblyCache.get(serviceAssemblyName);
            } else {
                Repository repos = this.mMgtCtx.getRepository();
                Archive serviceAssemblyArchive = repos.getArchive(ArchiveType.SERVICE_ASSEMBLY, serviceAssemblyName);
                if (serviceAssemblyArchive != null) {
                    jbiXml = serviceAssemblyArchive.getJbiXml(true);
                    this.mJbiServiceAssemblyCache.put(serviceAssemblyName, jbiXml);
                }
            }
        }
        return jbiXml;
    }

    @Override
    public String getServiceAssemblyArchive(String saName) throws RegistryException {
        return this.mRegistry.getRepository().getArchive(ArchiveType.SERVICE_ASSEMBLY, saName).getPath();
    }

    @Override
    public String getComponentArchive(String componentName) throws RegistryException {
        return this.mRegistry.getRepository().getArchive(ArchiveType.COMPONENT, componentName).getPath();
    }

    @Override
    public String getSharedLibraryArchive(String sharedLibraryName) throws RegistryException {
        return this.mRegistry.getRepository().getArchive(ArchiveType.SHARED_LIBRARY, sharedLibraryName).getPath();
    }

    @Override
    public boolean isComponentInstalled(String componentName) throws RegistryException {
        boolean installed = false;
        if (this.isComponentRegistered(componentName)) {
            List<String> servers = this.getServersInstallingComponent(componentName);
            List<String> clusters = this.getClustersInstallingComponent(componentName);
            if (servers.size() > 0 || clusters.size() > 0) {
                installed = true;
            }
        }
        return installed;
    }

    @Override
    public boolean isSharedLibraryInstalled(String sharedLibraryName) throws RegistryException {
        boolean installed = false;
        if (this.isSharedLibraryRegistered(sharedLibraryName)) {
            List<String> servers = this.getServersInstallingSharedLibrary(sharedLibraryName);
            List<String> clusters = this.getClustersInstallingSharedLibrary(sharedLibraryName);
            if (servers.size() > 0 || clusters.size() > 0) {
                installed = true;
            }
        }
        return installed;
    }

    @Override
    public boolean isServiceAssemblyDeployed(String serviceAssemblyName) throws RegistryException {
        boolean deployed = false;
        if (this.isServiceAssemblyRegistered(serviceAssemblyName)) {
            List<String> servers = this.getServersDeployingServiceAssembly(serviceAssemblyName);
            List<String> clusters = this.getClustersDeployingServiceAssembly(serviceAssemblyName);
            if (servers.size() > 0 || clusters.size() > 0) {
                deployed = true;
            }
        }
        return deployed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getServers() throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        ArrayList<String> servers = new ArrayList<String>();
        try {
            ServerListType serverLT = this.mJbiRegistry.getServers();
            if (serverLT != null) {
                List<InstalledComponentsListType> serverList = serverLT.getServer();
                for (InstalledComponentsListType server : serverList) {
                    servers.add(server.getNameRef());
                }
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getClusters() throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        ArrayList<String> clusters = new ArrayList<String>();
        try {
            ClusterListType clusterLT = this.mJbiRegistry.getClusters();
            if (clusterLT != null) {
                List<InstalledComponentsListType> clusterList = clusterLT.getCluster();
                for (InstalledComponentsListType cluster : clusterList) {
                    clusters.add(cluster.getNameRef());
                }
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return clusters;
    }

    boolean isTargetServer(String targetName) throws RegistryException {
        return this.getServers().contains(targetName);
    }

    boolean isTargetCluster(String targetName) throws RegistryException {
        return this.getClusters().contains(targetName);
    }

    boolean isTargetDomain(String targetName) {
        return "domain".equals(targetName);
    }

    public void removeComponentFromCache(String componentName) {
        if (this.mComponentCache.containsKey(componentName)) {
            this.mComponentCache.remove(componentName);
        }
        if (this.mJbiComponentCache.containsKey(componentName)) {
            this.mJbiComponentCache.remove(componentName);
        }
    }

    public void removeServiceAssemblyFromCache(String serviceAssemblyName) {
        if (this.mServiceAssemblyCache.containsKey(serviceAssemblyName)) {
            this.mServiceAssemblyCache.remove(serviceAssemblyName);
        }
        if (this.mJbiServiceAssemblyCache.containsKey(serviceAssemblyName)) {
            this.mJbiServiceAssemblyCache.remove(serviceAssemblyName);
        }
    }

    public void removeSharedLibraryFromCache(String sharedLibraryName) {
        if (this.mSharedLibraryCache.containsKey(sharedLibraryName)) {
            this.mSharedLibraryCache.remove(sharedLibraryName);
        }
        if (this.mJbiSharedLibraryCache.containsKey(sharedLibraryName)) {
            this.mJbiSharedLibraryCache.remove(sharedLibraryName);
        }
    }

    @Override
    public ComponentType getComponentType(String componentName) throws RegistryException {
        com.sun.jbi.management.descriptor.Jbi jbiXML;
        Component comp;
        ComponentType compType = null;
        if (this.isComponentRegistered(componentName) && (comp = (jbiXML = this.getComponentJbi(componentName)).getComponent()) != null) {
            if (comp.getType().equalsIgnoreCase("binding-component")) {
                compType = ComponentType.BINDING;
            } else if (comp.getType().equalsIgnoreCase("service-engine")) {
                compType = ComponentType.ENGINE;
            }
        }
        return compType;
    }

    public ComponentState getComponentState(String componentName, String targetName) throws RegistryException {
        ComponentRefType comp;
        ComponentState compState = ComponentState.UNKNOWN;
        if (this.isComponentRegistered(componentName) && (comp = this.getComponent(componentName, targetName)) != null) {
            compState = ComponentState.valueOfString((String)comp.getState().value());
        }
        return compState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComponentRegistered(String componentName) throws RegistryException {
        boolean isReadLocked = false;
        boolean isInRegistry = false;
        boolean isInRepository = false;
        boolean isRegistered = false;
        this.mRegObjLM.acquireReadLock();
        try {
            isReadLocked = true;
            Components compTypes = this.mJbiRegistry.getComponents();
            if (compTypes != null) {
                List<DomainComponentType> comps = compTypes.getComponent();
                for (DomainComponentType comp : comps) {
                    if (!comp.getName().equals(componentName)) continue;
                    if (this.mReadonly) {
                        this.mRegObjLM.releaseReadLock();
                        isReadLocked = false;
                        boolean bl = true;
                        return bl;
                    }
                    isInRegistry = true;
                    break;
                }
            }
            try {
                Repository repos = this.mMgtCtx.getRepository();
                Archive componentArchive = null;
                componentArchive = repos.getArchive(ArchiveType.COMPONENT, componentName);
                if (componentArchive != null) {
                    isInRepository = true;
                }
                if (isInRegistry != isInRepository) {
                    this.mRegObjLM.releaseReadLock();
                    isReadLocked = false;
                    this.mRegUtil.cleanEntity(ArchiveType.COMPONENT, componentName, isInRegistry, isInRepository);
                }
            }
            catch (Exception ex) {
                this.mLog.warning(ex.getMessage());
            }
            isRegistered = isInRegistry && isInRepository;
        }
        finally {
            if (isReadLocked) {
                this.mRegObjLM.releaseReadLock();
            }
        }
        return isRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSharedLibraryRegistered(String sharedLibraryName) throws RegistryException {
        boolean isReadLocked = false;
        boolean isInRegistry = false;
        boolean isInRepository = false;
        boolean isRegistered = false;
        this.mRegObjLM.acquireReadLock();
        try {
            isReadLocked = true;
            SharedLibraries slsType = this.mJbiRegistry.getSharedLibraries();
            if (slsType != null) {
                List<DomainSharedLibraryType> sls = slsType.getSharedLibrary();
                for (DomainSharedLibraryType sl : sls) {
                    if (!sl.getName().equals(sharedLibraryName)) continue;
                    if (this.mReadonly) {
                        this.mRegObjLM.releaseReadLock();
                        isReadLocked = false;
                        boolean bl = true;
                        return bl;
                    }
                    isInRegistry = true;
                    break;
                }
            }
            try {
                Repository repos = this.mMgtCtx.getRepository();
                Archive slArchive = null;
                slArchive = repos.getArchive(ArchiveType.SHARED_LIBRARY, sharedLibraryName);
                if (slArchive != null) {
                    isInRepository = true;
                }
                if (isInRegistry != isInRepository) {
                    this.mRegObjLM.releaseReadLock();
                    isReadLocked = false;
                    this.mRegUtil.cleanEntity(ArchiveType.SHARED_LIBRARY, sharedLibraryName, isInRegistry, isInRepository);
                }
            }
            catch (Exception ex) {
                this.mLog.warning(ex.getMessage());
            }
            isRegistered = isInRegistry && isInRepository;
        }
        finally {
            if (isReadLocked) {
                this.mRegObjLM.releaseReadLock();
            }
        }
        return isRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isServiceAssemblyRegistered(String serviceAssemblyName) throws RegistryException {
        boolean isReadLocked = false;
        boolean isInRegistry = false;
        boolean isInRepository = false;
        boolean isRegistered = false;
        try {
            this.mRegObjLM.acquireReadLock();
            try {
                Repository repos;
                Archive saArchive;
                isReadLocked = true;
                ServiceAssemblies sasType = this.mJbiRegistry.getServiceAssemblies();
                if (sasType != null) {
                    List<DomainEntityType> sas = sasType.getServiceAssembly();
                    for (DomainEntityType sa : sas) {
                        if (!sa.getName().equals(serviceAssemblyName)) continue;
                        if (this.mReadonly) {
                            this.mRegObjLM.releaseReadLock();
                            isReadLocked = false;
                            boolean bl = true;
                            return bl;
                        }
                        isInRegistry = true;
                        break;
                    }
                }
                boolean bl = isInRepository = (saArchive = (repos = this.mMgtCtx.getRepository()).getArchive(ArchiveType.SERVICE_ASSEMBLY, serviceAssemblyName)) != null;
                if (isInRegistry != isInRepository) {
                    this.mRegObjLM.releaseReadLock();
                    isReadLocked = false;
                    this.mRegUtil.cleanEntity(ArchiveType.SERVICE_ASSEMBLY, serviceAssemblyName, isInRegistry, isInRepository);
                }
            }
            catch (Exception ex) {
                this.mLog.warning(ex.getMessage());
            }
            isRegistered = isInRegistry && isInRepository;
            return isRegistered;
        }
        finally {
            if (isReadLocked) {
                this.mRegObjLM.releaseReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getRegisteredServiceAssemblies() throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        ArrayList<String> saList = new ArrayList<String>();
        try {
            ServiceAssemblies sasType = this.mJbiRegistry.getServiceAssemblies();
            if (sasType != null) {
                List<DomainEntityType> sas = sasType.getServiceAssembly();
                for (DomainEntityType sa : sas) {
                    saList.add(sa.getName());
                }
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return saList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getRegisteredSharedLibraries() throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        ArrayList<String> slList = new ArrayList<String>();
        try {
            SharedLibraries slsType = this.mJbiRegistry.getSharedLibraries();
            if (slsType != null) {
                List<DomainSharedLibraryType> sls = slsType.getSharedLibrary();
                for (DomainSharedLibraryType sl : sls) {
                    slList.add(sl.getName());
                }
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return slList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getRegisteredComponents() throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        ArrayList<String> compList = new ArrayList<String>();
        try {
            Components compTypes = this.mJbiRegistry.getComponents();
            if (compTypes != null) {
                List<DomainComponentType> comps = compTypes.getComponent();
                for (DomainComponentType comp : comps) {
                    compList.add(comp.getName());
                }
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return compList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSystemComponent(String componentName) throws RegistryException {
        boolean isSystemComponent;
        block5: {
            this.mRegObjLM.acquireReadLock();
            isSystemComponent = false;
            try {
                Components compTypes = this.mJbiRegistry.getComponents();
                if (compTypes == null) break block5;
                List<DomainComponentType> comps = compTypes.getComponent();
                for (DomainComponentType comp : comps) {
                    if (!comp.getName().equals(componentName)) continue;
                    if (comp.isDefaultInstall()) {
                        isSystemComponent = true;
                    }
                    break;
                }
            }
            finally {
                this.mRegObjLM.releaseReadLock();
            }
        }
        return isSystemComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSystemSharedLibrary(String sharedLibraryName) throws RegistryException {
        boolean isSystemSharedLibrary;
        block5: {
            this.mRegObjLM.acquireReadLock();
            isSystemSharedLibrary = false;
            try {
                SharedLibraries sharedLibTypes = this.mJbiRegistry.getSharedLibraries();
                if (sharedLibTypes == null) break block5;
                List<DomainSharedLibraryType> sharedLibs = sharedLibTypes.getSharedLibrary();
                for (DomainSharedLibraryType sharedLib : sharedLibs) {
                    if (!sharedLib.getName().equals(sharedLibraryName)) continue;
                    if (sharedLib.isDefaultInstall()) {
                        isSystemSharedLibrary = true;
                    }
                    break;
                }
            }
            finally {
                this.mRegObjLM.releaseReadLock();
            }
        }
        return isSystemSharedLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesComponentDeployServiceAssembly(ComponentRefType componentRef, String serviceAssemblyName) throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        boolean deploys = false;
        try {
            ServiceUnitListType suList = componentRef.getServiceUnits();
            if (suList != null) {
                List<ServiceUnitType> sus = suList.getServiceUnit();
                for (ServiceUnitType su : sus) {
                    if (!su.getServiceAssemblyRef().equals(serviceAssemblyName)) continue;
                    deploys = true;
                }
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return deploys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainComponentType getComponent(String componentName) throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        DomainComponentType component = null;
        try {
            if (this.mJbiRegistry.getComponents() != null) {
                List<DomainComponentType> comps = this.mJbiRegistry.getComponents().getComponent();
                for (DomainComponentType comp : comps) {
                    if (!comp.getName().equals(componentName)) continue;
                    component = comp;
                }
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentRefType getComponent(String componentName, String targetName) throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        ComponentRefType compRefType = null;
        try {
            InstalledComponentsListType target = this.getInstalledEntities(targetName);
            if (target != null) {
                List<ComponentRefType> compRefs = target.getComponentRef();
                for (ComponentRefType compRef : compRefs) {
                    if (!compRef.getNameRef().equals(componentName)) continue;
                    compRefType = compRef;
                }
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return compRefType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainSharedLibraryType getSharedLibrary(String slName) throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        DomainSharedLibraryType sharedLibrary = null;
        try {
            if (this.mJbiRegistry.getSharedLibraries() != null) {
                List<DomainSharedLibraryType> sls = this.mJbiRegistry.getSharedLibraries().getSharedLibrary();
                for (DomainSharedLibraryType sl : sls) {
                    if (!sl.getName().equals(slName)) continue;
                    sharedLibrary = sl;
                }
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return sharedLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedLibraryRefType getSharedLibrary(String slName, String targetName) throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        SharedLibraryRefType slRefType = null;
        try {
            InstalledComponentsListType target = this.getInstalledEntities(targetName);
            if (target != null) {
                List<SharedLibraryRefType> slRefs = target.getSharedLibraryRef();
                for (SharedLibraryRefType slRef : slRefs) {
                    if (!slRef.getNameRef().equals(slName)) continue;
                    slRefType = slRef;
                }
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return slRefType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainEntityType getServiceAssembly(String saName) throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        DomainEntityType serviceAssembly = null;
        try {
            if (this.mJbiRegistry.getServiceAssemblies() != null) {
                List<DomainEntityType> sas = this.mJbiRegistry.getServiceAssemblies().getServiceAssembly();
                for (DomainEntityType sa : sas) {
                    if (!sa.getName().equals(saName)) continue;
                    serviceAssembly = sa;
                }
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return serviceAssembly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceAssemblyRefType getServiceAssembly(String saName, String targetName) throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        ServiceAssemblyRefType saRefType = null;
        try {
            InstalledComponentsListType target = this.getInstalledEntities(targetName);
            if (target != null) {
                List<ServiceAssemblyRefType> saRefs = target.getServiceAssemblyRef();
                for (ServiceAssemblyRefType saRef : saRefs) {
                    if (!saRef.getNameRef().equals(saName)) continue;
                    saRefType = saRef;
                }
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return saRefType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getComponentFileName(String componentName) throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        String fname = null;
        try {
            DomainComponentType comp = this.getComponent(componentName);
            if (comp != null) {
                fname = comp.getFileName();
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return fname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSharedLibraryFileName(String slName) throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        String fname = null;
        try {
            DomainSharedLibraryType sl = this.getSharedLibrary(slName);
            if (sl != null) {
                fname = sl.getFileName();
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return fname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getServiceAssemblyFileName(String saName) throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        String fname = null;
        try {
            DomainEntityType sa = this.getServiceAssembly(saName);
            if (sa != null) {
                fname = sa.getFileName();
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return fname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getComponentTimestamp(String componentName) throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        long timestamp = 0L;
        try {
            DomainComponentType comp = this.getComponent(componentName);
            if (comp != null) {
                timestamp = comp.getTimestamp().longValue();
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSharedLibraryTimestamp(String slName) throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        long timestamp = 0L;
        try {
            DomainSharedLibraryType sl = this.getSharedLibrary(slName);
            if (sl != null) {
                timestamp = sl.getTimestamp().longValue();
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getServiceAssemblyTimestamp(String saName) throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        long timestamp = 0L;
        try {
            DomainEntityType sa = this.getServiceAssembly(saName);
            if (sa != null) {
                timestamp = sa.getTimestamp().longValue();
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstalledComponentsListType getInstalledEntities(String targetName) throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        InstalledComponentsListType target = null;
        try {
            if (this.isTargetServer(targetName)) {
                List<InstalledComponentsListType> servers = this.mJbiRegistry.getServers().getServer();
                for (InstalledComponentsListType server : servers) {
                    if (!server.getNameRef().equals(targetName)) continue;
                    target = server;
                }
            } else if (this.isTargetCluster(targetName)) {
                List<InstalledComponentsListType> clusters = this.mJbiRegistry.getClusters().getCluster();
                for (InstalledComponentsListType cluster : clusters) {
                    if (!cluster.getNameRef().equals(targetName)) continue;
                    target = cluster;
                }
            }
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigInteger getComponentUpgradeNumber(String componentName) throws RegistryException {
        BigInteger upgradeNumber;
        block4: {
            this.mRegObjLM.acquireReadLock();
            upgradeNumber = null;
            try {
                Components compTypes = this.mJbiRegistry.getComponents();
                if (compTypes == null) break block4;
                List<DomainComponentType> comps = compTypes.getComponent();
                for (DomainComponentType comp : comps) {
                    if (!comp.getName().equals(componentName)) continue;
                    upgradeNumber = comp.getUpgradeNumber();
                    break;
                }
            }
            finally {
                this.mRegObjLM.releaseReadLock();
            }
        }
        return upgradeNumber;
    }

    @Override
    public String getAttribute(ConfigurationCategory type, String name) throws RegistryException {
        GenericQueryImpl genericQueryImpl = this;
        String target = genericQueryImpl.mMgtCtx.getEnvironmentContext().getPlatformContext().getTargetName();
        return this.getAttribute(target, type, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttribute(String targetName, ConfigurationCategory type, String name) throws RegistryException {
        this.mRegObjLM.acquireReadLock();
        String value = null;
        try {
            Map<String, String> attribs = null;
            attribs = this.isAttributeOverriden(targetName, type, name) ? this.getConfigurationAttributes(targetName, type) : this.getConfigurationAttributes("domain", type);
            value = attribs.get(name);
        }
        finally {
            this.mRegObjLM.releaseReadLock();
        }
        return value;
    }

    @Override
    public boolean isGlobalConfigurationDefined() {
        return this.getConfig("domain") != null;
    }

    public String getConfigName(String targetName) {
        StringBuffer configName = new StringBuffer(targetName);
        configName.append("-config");
        return configName.toString();
    }

    @Override
    public boolean isAttributeOverriden(String targetName, ConfigurationCategory type, String name) {
        boolean isOverrriden = false;
        ConfigCategoryType configType = this.getConfigCategory(targetName, type);
        if (configType != null) {
            Map propertyMap = this.getPropertyMap(configType.getProperty());
            isOverrriden = propertyMap.get(name.trim()) != null;
        }
        return isOverrriden;
    }

    public Map getPropertyMap(List<PropertyType> propertyList) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (PropertyType property : propertyList) {
            propertyMap.put(property.getName().trim(), property.getValue().trim());
        }
        return propertyMap;
    }

    public ConfigCategoryType getConfigCategory(String targetName, ConfigurationCategory type) {
        ConfigCategoryType cfgType = null;
        ConfigType config = this.getConfig(targetName);
        if (config != null) {
            List<ConfigCategoryType> configTypes = config.getConfigType();
            for (ConfigCategoryType configType : configTypes) {
                ConfigurationCategory category = ConfigurationCategory.valueOf((String)configType.getCategory().value());
                if (category != type) continue;
                cfgType = configType;
            }
        }
        return cfgType;
    }

    public ConfigType getConfig(String targetName) {
        ConfigType cfg = null;
        String configName = this.getConfigName(targetName);
        Configs cfgs = this.mJbiRegistry.getConfigs();
        if (cfgs != null) {
            List<ConfigType> configs = cfgs.getConfig();
            for (ConfigType config : configs) {
                if (!config.getName().equals(configName)) continue;
                cfg = config;
            }
        }
        return cfg;
    }

    private Map<String, String> getConfigurationAttributes(String targetName, ConfigurationCategory type) {
        ConfigCategoryType category = this.getConfigCategory(targetName, type);
        Map attributes = category != null ? this.getPropertyMap(category.getProperty()) : new HashMap();
        return attributes;
    }
}

