/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.system;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentManager;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.component.InstallationContext;
import com.sun.jbi.framework.FrameworkWarningException;
import com.sun.jbi.management.ComponentInstallationContext;
import com.sun.jbi.management.InstallationServiceMBean;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.descriptor.ComponentDescriptor;
import com.sun.jbi.management.descriptor.SharedLibraryDescriptor;
import com.sun.jbi.management.internal.support.JarFactory;
import com.sun.jbi.management.internal.support.XmlReader;
import com.sun.jbi.management.message.MessageBuilder;
import com.sun.jbi.management.message.MessageHelper;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.xml.GenericQueryImpl;
import com.sun.jbi.management.repository.Archive;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.repository.RepositoryException;
import com.sun.jbi.management.support.JbiNameInfo;
import com.sun.jbi.management.system.AdminService;
import com.sun.jbi.management.system.BuildManagementMessageImpl;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.system.ManagementException;
import com.sun.jbi.management.system.ManagementMessageHolder;
import com.sun.jbi.management.system.ModelSystemService;
import com.sun.jbi.management.util.FileHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.ObjectName;
import org.w3c.dom.DocumentFragment;

public class InstallationService
extends ModelSystemService
implements InstallationServiceMBean {
    private static final String PATH_TO_JBI_XML_FILE = "META-INF/jbi.xml";
    private static final String INSTALL_ROOT = "install_root";
    private static final String WORKSPACE = "workspace";
    private static final String LOGGER_CONFIG = "config";
    private static final String DELETE_ME = ".DELETE_ME";
    private static final String REPOSITORY_SERVICE_ASSEMBLY_STORE = "service-assemblies";
    private static final String TMP_DIR = "tmp";
    private static final String UPGRADE_TMP_DIR = "tmp_install_root";
    private static final String UNDERSCORE = "_";
    private static final String SU_BACKUP = "su";
    private static final String JAR = "jar";
    private static final String FILE = "file";
    private static final int BYTE_ARRAY_SIZE = 4096;
    private final JbiNameInfo mJbiNameInfo = new JbiNameInfo("InstallationService");
    private ManagementContext mContext = null;
    private BuildManagementMessageImpl mMMImpl = null;

    public InstallationService(ManagementContext anEnv) throws JBIException {
        this.mContext = anEnv;
        this.initModelSystemService(anEnv.getEnvironmentContext());
        InstallationService installationService = this;
        this.mMMImpl = installationService.mContext.getManagementMessageObject();
    }

    protected void initModelSystemService(EnvironmentContext anEnv) {
        String loggerName = "com.sun.jbi.management.InstallationService";
        Logger logger = Logger.getLogger(loggerName);
        super.initModelSystemService(anEnv, logger, this.mJbiNameInfo);
        this.mStartMBeans.add(this.mInstallServiceMBeanName, InstallationServiceMBean.class, this);
    }

    private File unjar(JarFile aJarFile, String aFileToFind) throws JBIException {
        if (null == aJarFile) {
            String errMsg = this.mTranslator.getString("IS_JAR_FILE_NULL");
            this.mLogger.fine(errMsg);
            String jbiTaskStr = this.managementMessageExcep("unjar", "IS_JAR_FILE_NULL", errMsg);
            throw new JBIException(jbiTaskStr);
        }
        Enumeration<JarEntry> entries = aJarFile.entries();
        byte[] buffer = new byte[4096];
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            FileOutputStream fos = null;
            InputStream is = null;
            if (entry.isDirectory() || !entry.getName().equals(aFileToFind)) continue;
            try {
                File retFile = File.createTempFile("jbi", ".xml");
                fos = new FileOutputStream(retFile);
                is = aJarFile.getInputStream(entry);
                int len = is.read(buffer);
                while (0 < len) {
                    fos.write(buffer, 0, len);
                    len = is.read(buffer);
                }
                is.close();
                is = null;
                File file = retFile;
                return file;
            }
            catch (IOException ioEx) {
                String errMsg = this.mTranslator.getString("IS_IO_EXCEP", (Object)ioEx.getMessage());
                this.mLogger.fine(errMsg);
                String jbiTaskStr = this.managementMessageExcep("unjar", "IS_IO_EXCEP", errMsg, ioEx);
                throw new JBIException(jbiTaskStr);
            }
            finally {
                try {
                    if (null != is) {
                        is.close();
                    }
                    if (null != fos) {
                        fos.close();
                    }
                }
                catch (IOException ioEx) {
                    this.mLogger.finest(this.mTranslator.getString("IS_IO_EXCEP", (Object)ioEx.getMessage()));
                }
            }
        }
        return null;
    }

    private void unjar(JarFile aJarFile, File aDirectory) throws JBIException {
        Enumeration<JarEntry> entries = aJarFile.entries();
        byte[] buffer = new byte[4096];
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            FileOutputStream fos = null;
            InputStream is = null;
            if (entry.isDirectory()) {
                File subdir = new File(aDirectory, entry.getName());
                if (subdir.mkdir()) continue;
                String logMessage = this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)("Could not create subdirectory " + entry.getName()));
                this.mLogger.fine(logMessage);
                continue;
            }
            try {
                File newFile = new File(aDirectory, entry.getName());
                fos = new FileOutputStream(newFile);
                is = aJarFile.getInputStream(entry);
                int len = is.read(buffer);
                while (0 < len) {
                    fos.write(buffer, 0, len);
                    len = is.read(buffer);
                }
                is.close();
                is = null;
            }
            catch (IOException ioEx) {
                String errMsg = this.mTranslator.getString("IS_IO_EXCEP", (Object)ioEx.getMessage());
                this.mLogger.fine(errMsg);
                String jbiTaskStr = this.managementMessageExcep("unjar", "IS_IO_EXCEP", errMsg, ioEx);
                throw new JBIException(jbiTaskStr);
            }
            finally {
                try {
                    if (null != is) {
                        is.close();
                    }
                    if (null == fos) continue;
                    fos.close();
                }
                catch (IOException ioEx) {
                    String errMsg = this.mTranslator.getString("IS_IO_EXCEP", (Object)ioEx.getMessage());
                    this.mLogger.fine(errMsg);
                }
            }
        }
    }

    public synchronized ObjectName loadNewInstaller(String installZipURL) {
        String compName = null;
        this.mLogger.finer(this.mTranslator.getString("METHOD_ENTERED", (Object)"loadNewInstaller", (Object)("(" + installZipURL + ")")));
        try {
            URL compURL = this.convertToProperURL(installZipURL);
            if (!this.mEnv.getPlatformContext().isAdminServer()) {
                File ar = new File(compURL.toURI());
                Archive compArchive = new Archive(ar, false);
                this.getRegistry().getRepository().addArchive(compArchive);
                compName = compArchive.getJbiName();
                this.getRegistry().getUpdater().addComponent(compArchive.getJbiName(), compArchive.getFileName(), compArchive.getUploadTimestamp());
                String path = compArchive.getPath();
                compURL = this.convertToProperURL(new File(path).toURL().toString());
                ar.delete();
            }
            ObjectName mbName = this.bootStrapComponent(compURL);
            this.mLogger.finer(this.mTranslator.getString("METHOD_EXITED", (Object)"loadNewInstaller", (Object)("(" + installZipURL + ") -> " + mbName)));
            return mbName;
        }
        catch (MalformedURLException URLsEx) {
            String errMsg = this.mTranslator.getString("IS_URL_EXCEP", (Object)URLsEx.getMessage());
            this.mLogger.fine(errMsg);
            String jbiTaskStr = this.managementMessageExcep("loadNewInstaller", "IS_URL_EXCEP", errMsg, URLsEx);
            throw new RuntimeException(jbiTaskStr);
        }
        catch (URISyntaxException uriEx) {
            String errMsg = this.mTranslator.getString("IS_URL_EXCEP", (Object)uriEx.getMessage());
            this.mLogger.fine(errMsg);
            String jbiTaskStr = this.managementMessageExcep("loadNewInstaller", "IS_URL_EXCEP", errMsg, uriEx);
            throw new RuntimeException(jbiTaskStr);
        }
        catch (IOException ioex) {
            String errMsg = this.mTranslator.getString("IS_IO_EXCEP", (Object)ioex.getMessage());
            this.mLogger.fine(errMsg);
            String jbiTaskStr = this.managementMessageExcep("loadNewInstaller", "IS_IO_EXCEP", errMsg, ioex);
            throw new RuntimeException(jbiTaskStr);
        }
        catch (JBIException jbiEx) {
            if (!this.mEnv.getPlatformContext().isAdminServer()) {
                try {
                    this.getRegistry().getRepository().removeArchive(ArchiveType.COMPONENT, compName);
                    this.getRegistry().getUpdater().removeComponent("domain", compName);
                }
                catch (Exception exp) {
                    this.mLogger.fine(MessageHelper.getMsgString(exp));
                    throw new RuntimeException(exp.getMessage());
                }
            }
            this.mLogger.fine(MessageHelper.getMsgString((Exception)((Object)jbiEx)));
            throw new RuntimeException(jbiEx.getMessage());
        }
    }

    public ObjectName loadInstaller(String componentName) {
        return this.loadInstaller(componentName, false);
    }

    public synchronized ObjectName loadInstaller(String componentName, boolean force) {
        ObjectName mbName = null;
        this.mLogger.finer(this.mTranslator.getString("METHOD_ENTERED", (Object)"loadInstaller", (Object)("(" + componentName + "," + force + ")")));
        try {
            if (this.mContext.getComponentQuery().getComponentInfo(componentName) == null) {
                this.mLogger.warning(this.mTranslator.getString("IS_COMPONENT_NOT_INSTALLED", (Object)componentName));
            } else {
                mbName = this.reloadInstaller(componentName, force);
            }
            this.mLogger.finer(this.mTranslator.getString("METHOD_EXITED", (Object)"loadInstaller", (Object)("(" + componentName + ") -> " + mbName)));
            return mbName;
        }
        catch (JBIException jbiEx) {
            this.mLogger.fine(MessageHelper.getMsgString((Exception)((Object)jbiEx)));
            throw new RuntimeException(jbiEx.getMessage());
        }
    }

    public synchronized boolean unloadInstaller(String componentName, boolean isToBeDeleted) {
        this.mLogger.finer(this.mTranslator.getString("METHOD_ENTERED", (Object)"unloadInstaller", (Object)("(" + componentName + "," + isToBeDeleted + ")")));
        try {
            ComponentManager framework = this.mContext.getComponentManager();
            this.mLogger.log(Level.FINE, "Unloading bootstrap for component {0}", componentName);
            framework.unloadBootstrap(componentName);
            if (isToBeDeleted && !this.mEnv.getPlatformContext().isAdminServer()) {
                if (this.mContext.getComponentQuery().getComponentInfo(componentName) != null) {
                    this.mLogger.warning(this.mTranslator.getString("IS_COMPONENT_NOT_UNINSTALLED", (Object)componentName));
                    return false;
                }
                this.getRegistry().getRepository().removeArchive(ArchiveType.COMPONENT, componentName);
                this.getRegistry().getUpdater().removeComponent("domain", componentName);
            }
        }
        catch (JBIException jbiEx) {
            this.mLogger.fine(MessageHelper.getMsgString((Exception)((Object)jbiEx)));
            throw new RuntimeException(jbiEx.getMessage());
        }
        this.mLogger.finer(this.mTranslator.getString("METHOD_EXITED", (Object)"unloadInstaller", (Object)("(" + componentName + "," + isToBeDeleted + ") -> TRUE")));
        return true;
    }

    public synchronized String installSharedLibrary(String slZipURL) {
        this.mLogger.finer(this.mTranslator.getString("METHOD_ENTERED", (Object)"installSharedLibrary", (Object)("(" + slZipURL + ")")));
        try {
            URL theURL = this.convertToProperURL(slZipURL);
            if (!this.mEnv.getPlatformContext().isAdminServer()) {
                File ar = new File(theURL.toURI());
                Archive slArchive = new Archive(ar, false);
                this.getRegistry().getRepository().addArchive(slArchive);
                this.getRegistry().getUpdater().addSharedLibrary(slArchive.getJbiName(), slArchive.getFileName(), slArchive.getUploadTimestamp());
                String path = slArchive.getPath();
                theURL = this.convertToProperURL(new File(path).toURL().toString());
                ar.delete();
            }
            String slName = this.installSharedLibraryToFramework(theURL);
            this.mLogger.finer(this.mTranslator.getString("METHOD_EXITED", (Object)"installSharedLibrary", (Object)("(" + slZipURL + ") -> " + slName)));
            return slName;
        }
        catch (IOException URLsEx) {
            String errMsg = this.mTranslator.getString("IS_URL_EXCEP", (Object)URLsEx.getMessage());
            this.mLogger.fine(errMsg);
            String jbiTaskStr = this.managementMessageExcep("installSharedLibrary", "IS_URL_EXCEP", errMsg, URLsEx);
            throw new RuntimeException(jbiTaskStr);
        }
        catch (URISyntaxException uriEx) {
            String errMsg = this.mTranslator.getString("IS_URL_EXCEP", (Object)uriEx.getMessage());
            this.mLogger.fine(errMsg);
            String jbiTaskStr = this.managementMessageExcep("loadNewInstaller", "IS_URL_EXCEP", errMsg, uriEx);
            throw new RuntimeException(jbiTaskStr);
        }
        catch (JBIException jbiEx) {
            this.mLogger.fine(MessageHelper.getMsgString((Exception)((Object)jbiEx)));
            throw new RuntimeException(jbiEx.getMessage());
        }
    }

    public synchronized boolean uninstallSharedLibrary(String slName) {
        Throwable warning = null;
        this.mLogger.finer(this.mTranslator.getString("METHOD_ENTERED", (Object)"uninstallSharedLibrary", (Object)("(" + slName + ")")));
        try {
            ComponentManager framework = this.mContext.getComponentManager();
            framework.uninstallSharedLibrary(slName);
        }
        catch (FrameworkWarningException fwEx) {
            warning = fwEx;
        }
        catch (JBIException jbiEx) {
            this.mLogger.fine(MessageHelper.getMsgString((Exception)((Object)jbiEx)));
            throw new RuntimeException(jbiEx.getMessage());
        }
        if (!this.mEnv.getPlatformContext().isAdminServer()) {
            try {
                this.getRegistry().getRepository().removeArchive(ArchiveType.SHARED_LIBRARY, slName);
                this.getRegistry().getUpdater().removeSharedLibrary("domain", slName);
            }
            catch (Exception ex) {
                warning = ex;
            }
        }
        if (null != warning) {
            String message = warning.getMessage();
            String errMsg = this.mTranslator.getString("WARNING", (Object)message);
            this.mLogger.fine(errMsg);
            ManagementMessageHolder mmHolder = new ManagementMessageHolder("STATUS_MSG");
            mmHolder.setFrameworkLocale("en_US");
            mmHolder.setTaskName("uninstallSharedLibrary");
            mmHolder.setTaskResult("SUCCESS");
            mmHolder.setStatusMessageType("WARNING");
            mmHolder.setExceptionMessageType("WARNING");
            if (message.length() > 11 && message.startsWith("JBI")) {
                mmHolder.setLocMessage(1, message.substring(11));
                mmHolder.setLocToken(1, message.substring(0, 9));
            } else {
                mmHolder.setLocMessage(1, message);
                mmHolder.setLocToken(1, "JBIFW1322");
            }
            String jbiTaskStr = this.mMMImpl.buildCompleteExceptionMessage(mmHolder);
            throw new RuntimeException(jbiTaskStr);
        }
        return true;
    }

    public ObjectName loadInstallerFromRepository(String componentName) throws JBIException {
        return null;
    }

    public String installSharedLibraryFromRepository(String sharedLibraryName) throws JBIException {
        return sharedLibraryName;
    }

    public boolean uninstallSharedLibrary(String slName, boolean keep) {
        return this.uninstallSharedLibrary(slName);
    }

    public String upgradeComponent(String componentName, String installZipPath) throws JBIException {
        this.doUpgradeComponent(componentName, installZipPath);
        return new MessageBuilder(this.mTranslator).buildFrameworkMessage("upgradeComponent", MessageBuilder.TaskResult.SUCCESS);
    }

    public void upgradeComponent(String componentName, long upgradeNumber) throws JBIException {
        this.setComponentUpgradeNumber(componentName, upgradeNumber);
    }

    private ObjectName reloadInstaller(String aComponentId, boolean force) throws JBIException {
        this.mLogger.fine(this.mTranslator.getString("METHOD_ENTERED", (Object)"reloadInstaller", (Object)("(" + aComponentId + "," + force + ")")));
        InstallationService installationService = this;
        MBeanNames jbiname = installationService.mContext.getMBeanNames();
        InstallationService installationService2 = this;
        AdminService myAS = installationService2.mContext.getAdminServiceHandle();
        ObjectName returnName = null;
        String componentRoot = this.getInstallRoot(ArchiveType.COMPONENT, aComponentId);
        if (componentRoot != null) {
            this.mLogger.finest(this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)("reloadInstaller: root = " + componentRoot)));
            if (myAS.isEngine(aComponentId)) {
                returnName = jbiname.getEngineMBeanName(aComponentId, "Installer");
                InstallationService installationService3 = this;
                if (installationService3.mContext.getMBeanServer().isRegistered(returnName)) {
                    this.mLogger.finest(this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)("reloadInstaller: found existing engine InstallationMBean = " + returnName)));
                    return returnName;
                }
            } else if (myAS.isBinding(aComponentId)) {
                returnName = jbiname.getBindingMBeanName(aComponentId, "Installer");
                InstallationService installationService4 = this;
                if (installationService4.mContext.getMBeanServer().isRegistered(returnName)) {
                    this.mLogger.finest(this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)("reloadInstaller: found existing engine InstallationMBean = " + returnName)));
                    return returnName;
                }
            }
            XmlReader jbiXml = this.getJbiXml(new File(componentRoot, PATH_TO_JBI_XML_FILE), false);
            ComponentManager framework = this.mContext.getComponentManager();
            try {
                ComponentInstallationContext cic = jbiXml.getInstallationContext();
                cic.setIsInstall(false);
                cic.setInstallRoot(componentRoot);
                this.mLogger.log(Level.FINE, "Loading the bootstrap for component {0}", aComponentId);
                returnName = framework.loadBootstrap((InstallationContext)cic, jbiXml.getBootstrapClassName(), (List)jbiXml.getBootstrapClassPath(), (List)jbiXml.getSharedLibraryIds(), force);
            }
            catch (FrameworkWarningException fwEx) {
                this.mLogger.warning(MessageHelper.getMsgString((Exception)((Object)fwEx)));
            }
            catch (JBIException jbiEx) {
                String errMsg = this.mTranslator.getString("IS_FRAMEWORK_UNINSTALL");
                String jbiTaskStr = this.managementMessageExcep("install", "IS_FRAMEWORK_UNINSTALL", jbiEx.getMessage(), jbiEx);
                throw new JBIException(jbiTaskStr);
            }
        }
        return returnName;
    }

    private URL convertToProperURL(String installJarURI) throws MalformedURLException {
        if ((installJarURI = installJarURI.replaceAll("#", "%23")).startsWith("file://")) {
            return new File(installJarURI.substring(7)).toURL();
        }
        if (installJarURI.startsWith("file:" + File.separator)) {
            return new File(installJarURI.substring(5)).toURL();
        }
        if (installJarURI.startsWith("file:/")) {
            return new File(installJarURI.substring(6)).toURL();
        }
        if (installJarURI.startsWith("file:")) {
            return new File(installJarURI.substring(5)).toURL();
        }
        try {
            return new URI(installJarURI.replaceAll(" ", "%20")).toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    private List insertPathPrefix(String aPrefix, List aClassPath) {
        Vector<String> retList = new Vector<String>();
        for (int j = 0; j < aClassPath.size(); ++j) {
            String item = aPrefix + "/" + (String)aClassPath.get(j);
            retList.add(item);
            String logMessage = this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)("insertPathPrefix: adding " + item));
            this.mLogger.finest(logMessage);
            if (!"true".equalsIgnoreCase(System.getProperty("com.sun.jbi.config.management.allowAbsolutePaths"))) continue;
            retList.add((String)aClassPath.get(j));
            logMessage = this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)("insertPathPrefix: also adding " + aClassPath.get(j)));
            this.mLogger.finest(logMessage);
        }
        return retList;
    }

    private int removeIt(String aFileOrDir) {
        int st = 0;
        File f = new File(aFileOrDir);
        if (f.exists() && !f.delete()) {
            f.deleteOnExit();
            ++st;
        }
        return st;
    }

    private int removeDirectory(String aDir) {
        String[] filesToBeRemoved;
        int st = 0;
        File d = new File(aDir);
        if (!d.exists()) {
            return st;
        }
        if (!d.isDirectory()) {
            return this.removeIt(aDir);
        }
        for (String filesToBeRemoved1 : filesToBeRemoved = d.list()) {
            String filePath = aDir + "/" + filesToBeRemoved1;
            File f = new File(filePath);
            if (f.isDirectory()) {
                st += this.removeDirectory(filePath);
                continue;
            }
            st += this.removeIt(filePath);
        }
        return st += this.removeIt(aDir);
    }

    private void moveToTrash(String aDir) {
        String logMessage = this.mTranslator.getString("METHOD_ENTERED", (Object)"moveToTrash", (Object)("(" + aDir + ")"));
        this.mLogger.fine(logMessage);
        String jbiRoot = this.getJbiInstallRoot();
        if (null == jbiRoot || "".equals(jbiRoot)) {
            logMessage = this.mTranslator.getString("IS_NO_TRASH");
            this.mLogger.warning(logMessage);
            return;
        }
        jbiRoot = jbiRoot + "/Trash";
        int dirNum = 1;
        String trashRootPath = jbiRoot + "/" + dirNum;
        File trashRoot = new File(trashRootPath);
        while (trashRoot.exists()) {
            trashRootPath = jbiRoot + "/" + ++dirNum;
            trashRoot = new File(trashRootPath);
        }
        logMessage = this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)("Creating Trash directory as " + trashRootPath));
        this.mLogger.fine(logMessage);
        if (!trashRoot.mkdirs()) {
            logMessage = this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)("Cannot create directory " + trashRootPath));
            this.mLogger.warning(logMessage);
            return;
        }
        logMessage = this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)("Now about to rename " + aDir + " to " + trashRootPath + "."));
        this.mLogger.fine(logMessage);
        File oldRoot = new File(aDir);
        if (!oldRoot.renameTo(trashRoot)) {
            logMessage = this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)("Could not rename " + aDir + " to " + trashRootPath + "."));
            this.mLogger.warning(logMessage);
        }
    }

    private ObjectName installerMBeanName(String aComponentId) {
        ObjectName mbName;
        this.mLogger.fine(this.mTranslator.getString("METHOD_ENTERED", (Object)"installerMBeanName", (Object)("(" + aComponentId + ")")));
        InstallationService installationService = this;
        AdminService admin = installationService.mContext.getAdminServiceHandle();
        ComponentInfo compInfo = this.mContext.getComponentQuery().getComponentInfo(aComponentId);
        if (compInfo == null) {
            mbName = null;
        } else if (compInfo.getComponentType() == ComponentType.ENGINE) {
            InstallationService installationService2 = this;
            mbName = installationService2.mContext.getMBeanNames().getEngineMBeanName(aComponentId, "Installer");
        } else if (compInfo.getComponentType() == ComponentType.BINDING) {
            InstallationService installationService3 = this;
            mbName = installationService3.mContext.getMBeanNames().getBindingMBeanName(aComponentId, "Installer");
        } else {
            this.mLogger.warning(this.mTranslator.getString("IS_COMPONENT_NO_INSTALL_MBEAN", (Object)aComponentId));
            mbName = null;
        }
        this.mLogger.finer(this.mTranslator.getString("METHOD_EXITED", (Object)"installerMBeanName", (Object)("(" + aComponentId + ") -> " + mbName)));
        return mbName;
    }

    private String getInstallRootPrefix() {
        InstallationService installationService = this;
        String jbiRoot = installationService.mContext.getJbiInstallRoot();
        if (null == jbiRoot || "".equals(jbiRoot)) {
            jbiRoot = System.getProperty("junit.srcroot") + "/install/lassen";
        }
        return jbiRoot;
    }

    private String getJbiInstallRoot() {
        InstallationService installationService = this;
        String jbiRoot = installationService.mContext.getJbiInstallRoot();
        this.mLogger.finest(this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)("getJbiInstallRoot: jbiRoot = " + jbiRoot)));
        if (null == jbiRoot || "".equals(jbiRoot)) {
            jbiRoot = System.getProperty("junit.srcroot") + "/install/lassen";
        }
        jbiRoot = jbiRoot.replace('\\', '/');
        this.mLogger.finer(this.mTranslator.getString("METHOD_EXITED", (Object)"getJbiInstallRoot", (Object)("() -> " + jbiRoot)));
        return jbiRoot;
    }

    void closeJarFile(JarFile aJarFile) {
        try {
            aJarFile.close();
        }
        catch (IOException ioEx) {
            String errMsg = this.mTranslator.getString("IS_IO_EXCEP", (Object)ioEx.getMessage());
            this.mLogger.finest(errMsg);
        }
    }

    private String managementMessageExcep(String methodName, String token, String message) {
        ManagementMessageHolder mmHolder = new ManagementMessageHolder("EXCEPTION_MSG");
        mmHolder.setFrameworkLocale("en_US");
        mmHolder.setTaskName(methodName);
        mmHolder.setTaskResult("FAILED");
        if (message.length() > 11 && message.startsWith("JBI")) {
            mmHolder.setLocMessage(1, message.substring(11));
            mmHolder.setLocToken(1, message.substring(0, 9));
        } else {
            mmHolder.setLocMessage(1, message);
            mmHolder.setLocToken(1, token);
        }
        mmHolder.setExceptionMessageType("ERROR");
        mmHolder.setFrameworkLocale("en_US");
        String jbiTaskStr = this.mMMImpl.buildCompleteExceptionMessage(mmHolder);
        return jbiTaskStr;
    }

    private String managementMessageExcep(String methodName, String token, String message, Throwable excep) {
        ManagementMessageHolder mmHolder = new ManagementMessageHolder("EXCEPTION_MSG");
        mmHolder.setFrameworkLocale("en_US");
        mmHolder.setTaskName(methodName);
        mmHolder.setTaskResult("FAILED");
        mmHolder.setExceptionObject(excep);
        if (message.length() > 11 && message.startsWith("JBI")) {
            mmHolder.setLocMessage(1, message.substring(11));
            mmHolder.setLocToken(1, message.substring(0, 9));
        } else {
            mmHolder.setLocMessage(1, message);
            mmHolder.setLocToken(1, token);
        }
        mmHolder.setExceptionMessageType("ERROR");
        mmHolder.setFrameworkLocale("en_US");
        String jbiTaskStr = this.mMMImpl.buildCompleteExceptionMessage(mmHolder);
        return jbiTaskStr;
    }

    private XmlReader getJbiXml(JarFile jar) throws JBIException {
        try {
            File jbiFile = this.unjar(jar, PATH_TO_JBI_XML_FILE);
            return this.getJbiXml(jbiFile, true);
        }
        catch (JBIException jbiEx) {
            this.closeJarFile(jar);
            throw jbiEx;
        }
    }

    private XmlReader getJbiXml(File jbiFile, boolean validate) throws JBIException {
        if (null == jbiFile) {
            String errMsg = this.mTranslator.getString("IS_NO_JBI_XML_IN_JAR");
            this.mLogger.fine(errMsg);
            String jbiTaskStr = this.managementMessageExcep("install", "IS_NO_JBI_XML_IN_JAR", errMsg);
            throw new JBIException(jbiTaskStr);
        }
        try {
            XmlReader jbiXml = new XmlReader();
            InstallationService installationService = this;
            jbiXml.setEnvironmentContext(installationService.mContext.getEnvironmentContext());
            jbiXml.loadAndParse(jbiFile.getAbsolutePath(), true);
            return jbiXml;
        }
        catch (JBIException jbiEx) {
            throw jbiEx;
        }
        catch (Exception e) {
            this.mLogger.fine(MessageHelper.getMsgString(e));
            String errMsg = this.mTranslator.getString("IS_VALIDATION_EXCEP", (Object)e.getMessage());
            String jbiTaskStr = this.managementMessageExcep("install", "IS_VALIDATION_EXCEP", errMsg, e);
            throw new JBIException(jbiTaskStr);
        }
    }

    String installSharedLibraryToFramework(URL aComponentURL) throws JBIException {
        this.mLogger.fine(this.mTranslator.getString("METHOD_ENTERED", (Object)"install", (Object)("(" + aComponentURL + ")")));
        Archive installArchive = this.getRepositoryArchive(aComponentURL);
        String slName = installArchive.getJbiName();
        String slInstallRoot = this.getInstallRoot(ArchiveType.SHARED_LIBRARY, slName);
        this.mLogger.finer(this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)("install Root = " + slInstallRoot)));
        this.mLogger.finer(this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)"Installing shared library to framework"));
        ComponentManager framework = this.mContext.getComponentManager();
        SharedLibraryDescriptor descr = new SharedLibraryDescriptor(installArchive.getJbiXml(false));
        try {
            framework.installSharedLibrary(slName, "The description is not persisted, should be removed.", slInstallRoot, descr.isSharedLibraryClassLoaderSelfFirst(), this.insertPathPrefix(slInstallRoot, descr.getSharedLibraryClassPathElements()));
            this.mLogger.finest(this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)("installed shared library = " + slName)));
        }
        catch (JBIException jbiEx) {
            String errMsg = this.mTranslator.getString("IS_FRAMEWORK_INSTALL");
            String jbiTaskStr = this.managementMessageExcep("install", "IS_FRAMEWORK_INSTALL", jbiEx.getMessage(), jbiEx);
            throw new JBIException(jbiTaskStr);
        }
        return slName;
    }

    ObjectName bootStrapComponent(URL aComponentURL) throws JBIException {
        ObjectName mbName;
        this.mLogger.fine(this.mTranslator.getString("METHOD_ENTERED", (Object)"bootStrapComponent", (Object)("(" + aComponentURL + ")")));
        Archive installArchive = this.getRepositoryArchive(aComponentURL);
        String compName = installArchive.getJbiName();
        String compInstallRoot = this.getInstallRoot(ArchiveType.COMPONENT, compName);
        this.mLogger.finer(this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)("install Root = " + compInstallRoot)));
        this.mLogger.finer(this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)"Loading the Component Bootstrap"));
        ComponentManager framework = this.mContext.getComponentManager();
        try {
            String workspaceRoot = compInstallRoot + File.separator + WORKSPACE;
            new File(workspaceRoot).mkdirs();
            ComponentDescriptor descr = new ComponentDescriptor(installArchive.getJbiXml(false));
            ComponentInstallationContext cic = this.getComponentInstallationContext(descr, compInstallRoot);
            cic.setIsInstall(true);
            cic.setInstallRoot(compInstallRoot);
            cic.setWorkspaceRoot(workspaceRoot);
            mbName = framework.loadBootstrap((InstallationContext)cic, descr.getBootstrapClassName(), this.insertPathPrefix(compInstallRoot, descr.getBootstrapClassPathElements()), descr.getSharedLibraryIds(), false);
            this.mLogger.finest(this.mTranslator.getString("IS_DEBUG_OUTPUT", (Object)("loadBootstrap MBean = " + mbName)));
        }
        catch (JBIException jbiEx) {
            String errMsg = this.mTranslator.getString("IS_FRAMEWORK_INSTALL");
            String jbiTaskStr = this.managementMessageExcep("loadNewInstaller", "IS_FRAMEWORK_INSTALL", jbiEx.getMessage(), jbiEx);
            throw new JBIException(jbiTaskStr);
        }
        return mbName;
    }

    private String getInstallRoot(ArchiveType type, String name) throws JBIException {
        Archive archive = null;
        String installRoot = null;
        archive = this.getRegistry().getRepository().getArchive(type, name);
        if (archive != null) {
            String archivePath = archive.getPath();
            installRoot = new File(archivePath).getParent() + File.separator + INSTALL_ROOT;
        }
        this.mLogger.log(Level.FINEST, "Install Root for component {0} is {1}", new Object[]{name, installRoot});
        return installRoot;
    }

    private Archive getRepositoryArchive(URL aURL) throws JBIException {
        try {
            return new Archive(new File(aURL.toURI()), false);
        }
        catch (Exception jbiEx) {
            String errMsg = this.mTranslator.getString("IS_FRAMEWORK_INSTALL");
            String jbiTaskStr = this.managementMessageExcep("getRepositoryArchive", "IS_FRAMEWORK_INSTALL", jbiEx.getMessage(), jbiEx);
            throw new JBIException(jbiTaskStr);
        }
    }

    private ComponentInstallationContext getComponentInstallationContext(ComponentDescriptor descr, String installRoot) throws JBIException {
        String componentClassName = descr.getComponentClassName();
        String componentName = descr.getName();
        boolean isBinding = descr.getComponentType() == ComponentType.BINDING;
        DocumentFragment docFrag = null;
        try {
            docFrag = this.getExtensionData(installRoot);
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        ComponentInstallationContext ic = new ComponentInstallationContext(componentName, isBinding ? 1 : 2, componentClassName, descr.getComponentClassPathElements(), docFrag);
        ic.setDescription(descr.getDescription());
        if (descr.isBootstrapClassLoaderSelfFirst()) {
            ic.setBootstrapClassLoaderSelfFirst();
        }
        if (descr.isComponentClassLoaderSelfFirst()) {
            ic.setComponentClassLoaderSelfFirst();
        }
        return ic;
    }

    private List<String> trim(List<String> list) {
        ArrayList<String> trimmedList = new ArrayList<String>(list.size());
        for (String str : list) {
            trimmedList.add(str.trim());
        }
        return trimmedList;
    }

    private DocumentFragment getExtensionData(String componentRoot) throws Exception {
        XmlReader jbiXml = this.getJbiXml(new File(componentRoot, PATH_TO_JBI_XML_FILE), false);
        ComponentInstallationContext cic = jbiXml.getInstallationContext();
        return cic.getInstallationDescriptorExtension();
    }

    private void extractJar(String parentDir, File archiveZip) throws IOException {
        File parent = new File(parentDir);
        parent.mkdir();
        JarFactory jarHelper = new JarFactory(parent.getAbsolutePath());
        jarHelper.unJar(archiveZip);
        this.mLogger.log(Level.FINER, "Extracted {0} in {1}", new Object[]{archiveZip.getName(), parentDir});
    }

    private boolean validateComponentForUpgrade(String componentName, String installZipURL) throws JBIException {
        boolean isUpgradeImplemented = false;
        String tempInstallRoot = this.mEnv.getJbiInstanceRoot() + File.separator + TMP_DIR + File.separator + componentName + UPGRADE_TMP_DIR + FileHelper.getTimestamp();
        try {
            File updateFile = new File(installZipURL);
            this.extractJar(tempInstallRoot, updateFile);
            Archive updateArchive = new Archive(updateFile, true);
            ComponentDescriptor descriptor = new ComponentDescriptor(updateArchive.getJbiXml(false));
            ComponentInstallationContext installationContext = this.getComponentInstallationContext(descriptor, tempInstallRoot);
            installationContext.setIsInstall(false);
            installationContext.setInstallRoot(tempInstallRoot);
            isUpgradeImplemented = this.mEnv.getComponentManager().validateComponentForUpgrade((InstallationContext)installationContext, descriptor.getBootstrapClassName(), this.insertPathPrefix(tempInstallRoot, descriptor.getBootstrapClassPathElements()), descriptor.getSharedLibraryIds());
            this.mLogger.log(Level.FINE, "Framework has validated component archive {0}", installZipURL);
            File tempInstallRootFile = new File(tempInstallRoot);
            FileHelper.cleanDirectory(tempInstallRootFile);
            tempInstallRootFile.delete();
        }
        catch (IOException ioEx) {
            File tempInstallRootFile;
            if (tempInstallRoot != null && (tempInstallRootFile = new File(tempInstallRoot)).exists()) {
                FileHelper.cleanDirectory(tempInstallRootFile);
                tempInstallRootFile.delete();
            }
            throw new JBIException(ioEx.toString());
        }
        return isUpgradeImplemented;
    }

    private String backupInstallRoot(String installRoot, String componentName) throws IOException, RegistryException {
        String installRootBkup = this.mEnv.getJbiInstanceRoot() + File.separator + TMP_DIR + File.separator + componentName + UNDERSCORE + this.getRegistry().getGenericQuery().getComponentUpgradeNumber(componentName) + UNDERSCORE + FileHelper.getTimestamp();
        FileHelper.copy(installRoot, installRootBkup);
        this.mLogger.log(Level.FINER, "Install root has been saved in {0}", installRootBkup);
        return installRootBkup;
    }

    private void invokeFrameworkUpgradeComponent(String componentName) throws JBIException {
        Archive archive = this.getRegistry().getRepository().getArchive(ArchiveType.COMPONENT, componentName);
        String compInstallRoot = this.getInstallRoot(ArchiveType.COMPONENT, componentName);
        ComponentManager framework = this.mContext.getComponentManager();
        ComponentDescriptor descr = new ComponentDescriptor(archive.getJbiXml(false));
        ComponentInstallationContext installationContext = this.getComponentInstallationContext(descr, compInstallRoot);
        installationContext.setIsInstall(true);
        installationContext.setInstallRoot(compInstallRoot);
        installationContext.setWorkspaceRoot(compInstallRoot + File.separator + WORKSPACE);
        framework.upgradeComponent((InstallationContext)installationContext, descr.getBootstrapClassName(), this.insertPathPrefix(compInstallRoot, descr.getBootstrapClassPathElements()), descr.getSharedLibraryIds());
        this.mLogger.log(Level.FINER, "framework successfully upgraded the component {0}", componentName);
    }

    private void copyWorkspaceFromBackup(String backupDir, String componentName, String componentRoot) throws IOException {
        String backupWorkspace = backupDir + File.separator + INSTALL_ROOT + File.separator + WORKSPACE;
        String workspace = componentRoot + File.separator + INSTALL_ROOT + File.separator + WORKSPACE;
        FileHelper.copy(backupWorkspace, workspace);
        this.mLogger.log(Level.FINE, "Recreated component workspace from {0} to {1}", new Object[]{backupWorkspace, workspace});
    }

    private void copyLoggerSettingsFromBackup(String backupDir, String componentName, String componentRoot) throws IOException {
        String config;
        String backupConfig = backupDir + File.separator + LOGGER_CONFIG;
        boolean result = FileHelper.copy(backupConfig, config = componentRoot + File.separator + LOGGER_CONFIG);
        if (result) {
            this.mLogger.log(Level.FINE, "Recreated component logger settings from {0} to {1}", new Object[]{backupConfig, config});
        } else if (new File(backupConfig).exists()) {
            this.mLogger.warning(this.mTranslator.getString("IS_COMPONENT_UPGRADE_LOGGER_NOT_RESTORED", (Object)componentName));
        }
    }

    private void restoreInstallRoot(String componentName, String backupComponentRoot, String componentRoot) {
        try {
            File marker;
            if (this.getRegistry().getRepository().archiveExists(ArchiveType.COMPONENT, componentName)) {
                this.getRegistry().getRepository().removeArchive(ArchiveType.COMPONENT, componentName);
            }
            if ((marker = new File(componentRoot, DELETE_ME)) != null && marker.exists()) {
                marker.delete();
            }
            FileHelper.copy(backupComponentRoot, componentRoot);
            File backupDir = new File(backupComponentRoot);
            FileHelper.cleanDirectory(backupDir);
            backupDir.delete();
            this.mLogger.log(Level.FINE, "Restored component install root from {0}", backupComponentRoot);
        }
        catch (Exception ex) {
            this.mLogger.log(Level.WARNING, "{0}{1}", new Object[]{this.mTranslator.getString("IS_COMPONENT_UPGRADE_INSTALL_ROOT_RESTORE_FAILED"), ex.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpgradeComponent(String componentName, String installZipPath) throws JBIException {
        boolean isUpgradeImplemented;
        String installZipURL;
        try {
            installZipURL = new File(this.convertToProperURL(installZipPath).toURI()).getAbsolutePath();
            isUpgradeImplemented = this.validateComponentForUpgrade(componentName, installZipURL);
        }
        catch (JBIException jbiEx) {
            this.mEnv.getComponentManager().cancelComponentUpgrade(componentName);
            this.mLogger.fine(MessageHelper.getMsgString((Exception)((Object)jbiEx)));
            throw jbiEx;
        }
        catch (MalformedURLException urlEx) {
            this.mEnv.getComponentManager().cancelComponentUpgrade(componentName);
            this.mLogger.fine(urlEx.toString());
            throw new JBIException((Throwable)urlEx);
        }
        catch (URISyntaxException uriEx) {
            this.mEnv.getComponentManager().cancelComponentUpgrade(componentName);
            this.mLogger.log(Level.FINE, uriEx.toString(), uriEx);
            throw new JBIException((Throwable)uriEx);
        }
        try {
            if (this.mEnv.getPlatformContext().isAdminServer()) {
                this.upgradeComponentInAdminServer(componentName, isUpgradeImplemented);
            } else {
                Registry registry;
                Registry registry2 = registry = this.getRegistry();
                synchronized (registry2) {
                    this.upgradeComponentInInstance(componentName, installZipURL, isUpgradeImplemented);
                }
            }
            this.mLogger.info(this.mTranslator.getString("IS_COMPONENT_UPGRADE_SUCCESSFUL", (Object)componentName));
        }
        catch (JBIException jbiEx) {
            this.mLogger.warning(this.mTranslator.getString("IS_COMPONENT_UPGRADE_FAILED", (Object)componentName));
            this.mLogger.fine(MessageHelper.getMsgString((Exception)((Object)jbiEx)));
            throw jbiEx;
        }
    }

    private void upgradeComponentInAdminServer(String componentName, boolean isUpgradeImplemented) throws JBIException {
        String suBackupDir = null;
        try {
            if (isUpgradeImplemented) {
                suBackupDir = this.backupSUsDeployedOnComponent(componentName);
            }
        }
        catch (ManagementException mEx) {
            throw new JBIException(mEx.getMessage());
        }
        try {
            this.invokeFrameworkUpgradeComponent(componentName);
        }
        catch (JBIException jbiEx) {
            try {
                if (isUpgradeImplemented) {
                    this.restoreSUsDeployedOnComponent(componentName, suBackupDir);
                }
            }
            catch (ManagementException mEx) {
                this.mLogger.fine(MessageHelper.getMsgString((Exception)((Object)mEx)));
            }
            this.mLogger.finer("Component update failed in server, install root not restored");
            throw jbiEx;
        }
    }

    private void upgradeComponentInInstance(String componentName, String installZipURL, boolean isUpgradeImplemented) throws JBIException {
        String backupDir;
        String componentRoot;
        this.mLogger.log(Level.FINER, "Entered upgradeComponentInInstance with file {0}", installZipURL);
        String suBackupDir = null;
        String existingArchiveName = null;
        Archive upgradeArchive = null;
        try {
            existingArchiveName = this.getRegistry().getGenericQuery().getComponentFileName(componentName);
            componentRoot = new File(this.getInstallRoot(ArchiveType.COMPONENT, componentName)).getParent();
            backupDir = this.backupInstallRoot(componentRoot, componentName);
            this.mLogger.log(Level.FINER, "Successfully saved install root in {0}", backupDir);
        }
        catch (IOException ioEx) {
            this.mEnv.getComponentManager().cancelComponentUpgrade(componentName);
            this.mLogger.fine(MessageHelper.getMsgString(ioEx));
            throw new JBIException(this.mTranslator.getString("IS_COMPONENT_UPGRADE_INSTALL_ROOT_BACKUP_FAILED", (Object)componentName) + ioEx.getMessage());
        }
        catch (RegistryException regEx) {
            this.mEnv.getComponentManager().cancelComponentUpgrade(componentName);
            this.mLogger.fine(MessageHelper.getMsgString((Exception)((Object)regEx)));
            throw new JBIException(this.mTranslator.getString("IS_COMPONENT_UPGRADE_INSTALL_ROOT_BACKUP_FAILED", (Object)componentName) + regEx.getMessage());
        }
        try {
            this.getRegistry().getRepository().removeArchive(ArchiveType.COMPONENT, componentName);
            this.mLogger.finer("Successfully removed install root from repository");
        }
        catch (RepositoryException repEx) {
            this.mEnv.getComponentManager().cancelComponentUpgrade(componentName);
            this.restoreInstallRoot(componentName, backupDir, componentRoot);
            this.mLogger.fine(MessageHelper.getMsgString((Exception)((Object)repEx)));
            throw new JBIException(this.mTranslator.getString("IS_COMPONENT_UPGRADE_INSTALL_ROOT_NOT_DELETED", (Object)componentName) + repEx.getMessage());
        }
        if (new File(componentRoot).exists()) {
            this.mLogger.finer("Install root was not completely deleted from repository");
            this.mEnv.getComponentManager().cancelComponentUpgrade(componentName);
            this.restoreInstallRoot(componentName, backupDir, componentRoot);
            String message = this.mTranslator.getString("IS_COMPONENT_UPGRADE_INSTALL_ROOT_NOT_DELETED", (Object)componentName);
            this.mLogger.fine(message);
            throw new JBIException(message);
        }
        try {
            upgradeArchive = this.getRegistry().getRepository().addArchive(ArchiveType.COMPONENT, installZipURL);
            this.mLogger.finer("Successfully added new archive in repository");
            this.copyWorkspaceFromBackup(backupDir, componentName, componentRoot);
            this.mLogger.finer("Successfully recreated component workspace");
            this.copyLoggerSettingsFromBackup(backupDir, componentName, componentRoot);
            this.mLogger.finer("Successfully recreated logger settings");
        }
        catch (IOException ioEx) {
            this.mEnv.getComponentManager().cancelComponentUpgrade(componentName);
            this.restoreInstallRoot(componentName, backupDir, componentRoot);
            this.mLogger.fine(MessageHelper.getMsgString(ioEx));
            throw new JBIException(this.mTranslator.getString("IS_COMPONENT_UPGRADE_INSTALL_ROOT_NOT_CREATED") + ioEx.getMessage());
        }
        catch (RepositoryException repEx) {
            this.mEnv.getComponentManager().cancelComponentUpgrade(componentName);
            this.restoreInstallRoot(componentName, backupDir, componentRoot);
            this.mLogger.fine(MessageHelper.getMsgString((Exception)((Object)repEx)));
            throw new JBIException(this.mTranslator.getString("IS_COMPONENT_UPGRADE_WORKSPACE_NOT_RESTORED", (Object)componentName) + repEx.getMessage());
        }
        try {
            if (isUpgradeImplemented) {
                suBackupDir = this.backupSUsDeployedOnComponent(componentName);
            }
        }
        catch (ManagementException mEx) {
            this.restoreInstallRoot(componentName, backupDir, componentRoot);
            this.mLogger.fine(MessageHelper.getMsgString((Exception)((Object)mEx)));
            throw new JBIException((Throwable)((Object)mEx));
        }
        try {
            this.invokeFrameworkUpgradeComponent(componentName);
            this.mLogger.finer("Successfully upgradedthe component in framework");
            this.incrementComponentUpgradeNumber(componentName);
        }
        catch (JBIException jbiEx) {
            this.restoreInstallRoot(componentName, backupDir, componentRoot);
            try {
                if (isUpgradeImplemented) {
                    this.restoreSUsDeployedOnComponent(componentName, suBackupDir);
                }
            }
            catch (ManagementException mEx) {
                this.mLogger.fine(MessageHelper.getMsgString((Exception)((Object)mEx)));
            }
            this.mLogger.fine(MessageHelper.getMsgString((Exception)((Object)jbiEx)));
            throw jbiEx;
        }
        this.modifyArchiveNameInRegistry(componentName, existingArchiveName, upgradeArchive.getFileName());
        ((GenericQueryImpl)this.getRegistry().getGenericQuery()).removeComponentFromCache(componentName);
    }

    private void incrementComponentUpgradeNumber(String componentName) throws RegistryException {
        BigInteger currNumber = this.getRegistry().getGenericQuery().getComponentUpgradeNumber(componentName);
        this.getRegistry().getUpdater().setComponentUpgradeNumber(componentName, currNumber.add(BigInteger.ONE));
        this.mLogger.log(Level.FINE, "Incremented upgrade number for component{0}", componentName);
    }

    private void setComponentUpgradeNumber(String componentName, long upgradeNumber) throws RegistryException {
        this.getRegistry().getUpdater().setComponentUpgradeNumber(componentName, BigInteger.valueOf(upgradeNumber));
        this.mLogger.log(Level.FINE, "Set upgrade number for component{0}", componentName);
    }

    private String backupSUsDeployedOnComponent(String componentName) throws ManagementException {
        String backupRoot = null;
        try {
            backupRoot = this.mEnv.getJbiInstanceRoot() + File.separator + TMP_DIR + File.separator + componentName + UNDERSCORE + this.getRegistry().getGenericQuery().getComponentUpgradeNumber(componentName) + UNDERSCORE + SU_BACKUP + UNDERSCORE + FileHelper.getTimestamp();
            ComponentInfo compInfo = this.getComponentQuery().getComponentInfo(componentName);
            if (compInfo != null) {
                List suList = compInfo.getServiceUnitList();
                for (ServiceUnitInfo suInfo : suList) {
                    String backupDir = backupRoot + File.separator + suInfo.getServiceAssemblyName() + File.separator + suInfo.getName();
                    String saRoot = this.mEnv.getJbiInstanceRoot() + File.separator + REPOSITORY_SERVICE_ASSEMBLY_STORE + File.separator + suInfo.getServiceAssemblyName() + File.separator + suInfo.getName();
                    this.mLogger.log(Level.FINE, "Saving a copy of SU root from {0} at {1}", new Object[]{saRoot, backupDir});
                    FileHelper.copy(saRoot, backupDir);
                }
            }
        }
        catch (IOException ex) {
            throw new ManagementException(ex);
        }
        catch (RegistryException regEx) {
            throw new ManagementException((Throwable)((Object)regEx));
        }
        return backupRoot;
    }

    private void restoreSUsDeployedOnComponent(String componentName, String backupDir) throws ManagementException {
        try {
            File[] saList;
            for (File saList1 : saList = new File(backupDir).listFiles()) {
                File[] suList;
                for (File suList1 : suList = saList1.listFiles()) {
                    String suRoot;
                    String suBackupDir = backupDir + File.separator + saList1.getName() + File.separator + suList1.getName();
                    if (FileHelper.copy(suBackupDir, suRoot = this.mEnv.getJbiInstanceRoot() + File.separator + REPOSITORY_SERVICE_ASSEMBLY_STORE + File.separator + saList1.getName() + File.separator + suList1.getName())) {
                        this.mLogger.log(Level.FINE, "Successfully restored SU root from {0} to {1}", new Object[]{suBackupDir, suRoot});
                        continue;
                    }
                    this.mLogger.log(Level.FINE, "Could not restore SU root in {0} from {1}", new Object[]{suRoot, suBackupDir});
                }
            }
        }
        catch (Exception ioEx) {
            throw new ManagementException(ioEx.getMessage());
        }
    }

    private void modifyArchiveNameInRegistry(String componentName, String existingName, String newName) throws RegistryException, ManagementException {
        if (!existingName.equals(newName)) {
            this.getRegistry().getUpdater().setComponentFileName(componentName, newName);
        }
    }
}

