/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.util;

import com.sun.jbi.management.util.TimeUnit;
import java.util.ArrayList;

public class ReentrantReadWriteLock {
    private Object mSync;
    private ReadLock mReadLock;
    private WriteLock mWriteLock = new WriteLock();
    private ArrayList mReaders;
    private int mReadCount = 0;
    private Thread mWriter = null;
    private int mWriterCount = 0;
    private ArrayList mWaitingReaders;
    private ArrayList mWaitingWriters;
    private int mState = 0;
    static final int NONE = 0;
    static final int READ = 1;
    static final int WRITE = 2;

    public ReentrantReadWriteLock() {
        this.mReadLock = new ReadLock();
        this.mReaders = new ArrayList();
        this.mWaitingReaders = new ArrayList();
        this.mWaitingWriters = new ArrayList();
        this.mSync = this;
    }

    public ReadLock readLock() {
        return this.mReadLock;
    }

    public WriteLock writeLock() {
        return this.mWriteLock;
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.mWriter == Thread.currentThread();
    }

    synchronized int getReaders() {
        return this.mReaders.size();
    }

    synchronized int getWaitingReaders() {
        return this.mWaitingReaders.size();
    }

    synchronized int getWriters() {
        return this.mWriterCount;
    }

    synchronized int getWaitingWriters() {
        return this.mWaitingWriters.size();
    }

    synchronized int getState() {
        return this.mState;
    }

    public class WriteLock
    implements Lock {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock(long interval, TimeUnit unit) throws InterruptedException {
            Thread t = Thread.currentThread();
            Object object = ReentrantReadWriteLock.this.mSync;
            synchronized (object) {
                long endTime = 0L;
                while (!this.doLock(t)) {
                    try {
                        if (endTime == 0L) {
                            endTime = System.currentTimeMillis() + unit.getMilliseconds() * interval;
                        }
                        ReentrantReadWriteLock.this.mSync.wait(unit.getMilliseconds() * interval);
                    }
                    finally {
                        ReentrantReadWriteLock.this.mWaitingWriters.remove(t);
                    }
                    if (System.currentTimeMillis() <= endTime) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lock() {
            Thread t = Thread.currentThread();
            Object object = ReentrantReadWriteLock.this.mSync;
            synchronized (object) {
                while (!this.doLock(t)) {
                    try {
                        try {
                            ReentrantReadWriteLock.this.mSync.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    finally {
                        ReentrantReadWriteLock.this.mWaitingWriters.remove(t);
                    }
                }
            }
        }

        private boolean doLock(Thread t) {
            if (ReentrantReadWriteLock.this.mState == 0) {
                ReentrantReadWriteLock.this.mWriter = t;
                ReentrantReadWriteLock.this.mWriterCount++;
                ReentrantReadWriteLock.this.mState = 2;
                ReentrantReadWriteLock.this.mReadCount = 0;
                return true;
            }
            if (ReentrantReadWriteLock.this.mState == 2 && ReentrantReadWriteLock.this.mWriter == t) {
                ReentrantReadWriteLock.this.mWriterCount++;
                return true;
            }
            ReentrantReadWriteLock.this.mWaitingWriters.add(t);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock() {
            Thread t = Thread.currentThread();
            boolean wakeReaders = false;
            Object object = ReentrantReadWriteLock.this.mSync;
            synchronized (object) {
                if (ReentrantReadWriteLock.this.mState == 2 && ReentrantReadWriteLock.this.mWriter == t) {
                    if (--ReentrantReadWriteLock.this.mWriterCount > 0) {
                        return;
                    }
                    ReentrantReadWriteLock.this.mWriter = null;
                    if (ReentrantReadWriteLock.this.mReaders.contains(t)) {
                        ReentrantReadWriteLock.this.mState = 1;
                    } else {
                        ReentrantReadWriteLock.this.mState = 0;
                    }
                } else {
                    throw new RuntimeException("Lock not held");
                }
                ReentrantReadWriteLock.this.mSync.notifyAll();
            }
        }
    }

    public class ReadLock
    implements Lock {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock(long interval, TimeUnit unit) throws InterruptedException {
            Thread t = Thread.currentThread();
            Object object = ReentrantReadWriteLock.this.mSync;
            synchronized (object) {
                long endTime = 0L;
                while (!this.doLock(t)) {
                    try {
                        if (endTime == 0L) {
                            endTime = System.currentTimeMillis() + unit.getMilliseconds() * interval;
                        }
                        ReentrantReadWriteLock.this.mSync.wait(unit.getMilliseconds() * interval);
                    }
                    finally {
                        ReentrantReadWriteLock.this.mWaitingReaders.remove(t);
                    }
                    if (System.currentTimeMillis() <= endTime) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lock() {
            Thread t = Thread.currentThread();
            Object object = ReentrantReadWriteLock.this.mSync;
            synchronized (object) {
                while (!this.doLock(t)) {
                    try {
                        try {
                            ReentrantReadWriteLock.this.mSync.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    finally {
                        ReentrantReadWriteLock.this.mWaitingReaders.remove(t);
                    }
                }
            }
        }

        private boolean doLock(Thread t) {
            if (ReentrantReadWriteLock.this.mState == 0) {
                ReentrantReadWriteLock.this.mReaders.add(t);
                ReentrantReadWriteLock.this.mState = 1;
                ReentrantReadWriteLock.this.mReadCount++;
                return true;
            }
            if (ReentrantReadWriteLock.this.mState == 1) {
                if (ReentrantReadWriteLock.this.mWaitingWriters.isEmpty() || ReentrantReadWriteLock.this.mReaders.contains(t) || ReentrantReadWriteLock.this.mReadCount < 4) {
                    ReentrantReadWriteLock.this.mReaders.add(t);
                    return true;
                }
            } else if (ReentrantReadWriteLock.this.mWriter == t) {
                ReentrantReadWriteLock.this.mReaders.add(t);
                return true;
            }
            ReentrantReadWriteLock.this.mWaitingReaders.add(t);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock() {
            Thread t = Thread.currentThread();
            Object object = ReentrantReadWriteLock.this.mSync;
            synchronized (object) {
                if (ReentrantReadWriteLock.this.mState == 0 || !ReentrantReadWriteLock.this.mReaders.remove(t)) {
                    throw new RuntimeException("Lock not held");
                }
                if (ReentrantReadWriteLock.this.mState == 1 && ReentrantReadWriteLock.this.mReaders.isEmpty()) {
                    ReentrantReadWriteLock.this.mState = 0;
                    ReentrantReadWriteLock.this.mSync.notifyAll();
                }
            }
        }
    }

    public static interface Lock {
        public void lock();

        public void unlock();
    }
}

