/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.impl.administration;

import com.sun.esb.management.api.administration.AdministrationService;
import com.sun.esb.management.base.services.AbstractListStateServiceMBeansImpl;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.JBIDescriptor;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import com.sun.jbi.ui.runtime.GenericsSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class AdministrationServiceMBeanImpl
extends AbstractListStateServiceMBeansImpl
implements AdministrationService,
Serializable {
    static final long serialVersionUID = -1L;

    public AdministrationServiceMBeanImpl(EnvironmentContext anEnvContext) {
        super(anEnvContext);
    }

    @Override
    public Map<String, String[]> listTargetNames() throws ManagementRemoteException {
        return super.listTargetNames();
    }

    public Map<String, Properties> getRuntimeDetails() throws ManagementRemoteException {
        HashMap<String, Properties> result = null;
        result = new HashMap<String, Properties>();
        Map<String, String[]> targetNameToInstancesMap = null;
        targetNameToInstancesMap = this.listTargetNames();
        if (targetNameToInstancesMap != null) {
            for (String targetName : targetNameToInstancesMap.keySet()) {
                ObjectName objectName = null;
                String value = null;
                Properties properties = new Properties();
                if (targetName.equals("server")) {
                    objectName = super.getAdminServiceMBeanObjectName();
                    if (objectName == null) continue;
                    value = (String)this.getAttributeValue(objectName, "SystemInfo");
                    if (value != null) {
                        properties.setProperty("SystemInfo", value);
                    }
                    if ((value = (String)this.getAttributeValue(objectName, "BuildNumber")) != null) {
                        properties.setProperty("BuildNumber", value);
                    }
                    if ((value = (String)this.getAttributeValue(objectName, "Copyright")) != null) {
                        properties.setProperty("Copyright", value);
                    }
                    if ((value = (String)this.getAttributeValue(objectName, "FullProductName")) != null) {
                        properties.setProperty("FullProductName", value);
                    }
                    if ((value = (String)this.getAttributeValue(objectName, "MajorVersion")) != null) {
                        properties.setProperty("MajorVersion", value);
                    }
                    if ((value = (String)this.getAttributeValue(objectName, "MinorVersion")) != null) {
                        properties.setProperty("MinorVersion", value);
                    }
                    if ((value = (String)this.getAttributeValue(objectName, "ShortProductName")) != null) {
                        properties.setProperty("ShortProductName", value);
                    }
                    result.put(targetName, properties);
                    continue;
                }
                objectName = this.getAdminServiceMBeanObjectName(targetName);
                if (objectName == null) continue;
                value = (String)this.getAttributeValue(objectName, "SystemInfo");
                if (value != null) {
                    properties.setProperty("SystemInfo", value);
                }
                result.put(targetName, properties);
            }
        }
        return result;
    }

    @Override
    public boolean isTargetUp(String targetName) throws ManagementRemoteException {
        return super.isTargetUp(targetName);
    }

    public String getComponentInstallationDescriptor(String componentName) throws ManagementRemoteException {
        String targetName = "domain";
        String jbiXml = this.getInstallationDescriptor(componentName, targetName);
        return jbiXml;
    }

    @Override
    public String getComponentState(String componentName, String targetName) throws ManagementRemoteException {
        return super.getComponentState(componentName, targetName);
    }

    public String getComponentType(String componentName, String targetName) throws ManagementRemoteException {
        String result = null;
        String xmlText = null;
        List infoList = null;
        String state = null;
        String sharedLibraryName = null;
        String serviceAssemblyName = null;
        try {
            xmlText = this.listComponents(ComponentType.BINDING, state, sharedLibraryName, serviceAssemblyName, targetName);
            if (xmlText != null && xmlText.length() > 0) {
                infoList = JBIComponentInfo.readFromXmlText((String)xmlText);
                for (JBIComponentInfo info : infoList) {
                    if (!info.getName().equals(componentName)) continue;
                    return info.getType();
                }
            }
        }
        catch (ManagementRemoteException e) {
            // empty catch block
        }
        try {
            xmlText = this.listComponents(ComponentType.ENGINE, state, sharedLibraryName, serviceAssemblyName, targetName);
            if (xmlText != null && xmlText.length() > 0) {
                infoList = JBIComponentInfo.readFromXmlText((String)xmlText);
                for (JBIComponentInfo info : infoList) {
                    if (!info.getName().equals(componentName)) continue;
                    return info.getType();
                }
            }
        }
        catch (ManagementRemoteException e) {
            // empty catch block
        }
        try {
            ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
            this.checkForValidTarget(installerServiceObjectName, targetName);
            List frameworkCompInfoList = this.getFrameworkComponentInfoListForSharedLibraries(null, targetName);
            List uiCompInfoList = new ArrayList();
            uiCompInfoList = this.toUiComponentInfoList(frameworkCompInfoList, targetName);
            xmlText = JBIComponentInfo.writeAsXmlText(uiCompInfoList);
            if (xmlText != null && xmlText.length() > 0) {
                infoList = JBIComponentInfo.readFromXmlText((String)xmlText);
                for (JBIComponentInfo info : infoList) {
                    if (!info.getName().equals(componentName)) continue;
                    return info.getType();
                }
            }
        }
        catch (ManagementRemoteException e) {
            // empty catch block
        }
        return result;
    }

    public String[] getConsumingEndpoints(String componentName, String targetName) throws ManagementRemoteException {
        ArrayList<String> endpointsList = new ArrayList<String>();
        Map<String, ObjectName[]> targetToObjectNamesMap = null;
        targetToObjectNamesMap = this.findLiveExtensionMBeanObjectNames(componentName, "Statistics", targetName);
        if (targetToObjectNamesMap != null) {
            for (String instanceName : targetToObjectNamesMap.keySet()) {
                ObjectName[] objectNames = targetToObjectNamesMap.get(instanceName);
                if (objectNames == null) continue;
                for (ObjectName objectName : objectNames) {
                    String[] consumingEndpoints = null;
                    consumingEndpoints = (String[])this.getAttributeValue(targetName, objectName, "ConsumingEndpoints");
                    if (consumingEndpoints == null) continue;
                    for (String endpoint : consumingEndpoints) {
                        if (endpointsList.contains(endpoint)) continue;
                        endpointsList.add(endpoint);
                    }
                }
            }
        }
        return GenericsSupport.toArray(endpointsList, String.class);
    }

    public String[] getProvisioningEndpoints(String componentName, String targetName) throws ManagementRemoteException {
        ArrayList<String> endpointsList = new ArrayList<String>();
        Map<String, ObjectName[]> targetToObjectNamesMap = null;
        targetToObjectNamesMap = this.findLiveExtensionMBeanObjectNames(componentName, "Statistics", targetName);
        if (targetToObjectNamesMap != null) {
            for (String instanceName : targetToObjectNamesMap.keySet()) {
                ObjectName[] objectNames = targetToObjectNamesMap.get(instanceName);
                if (objectNames == null) continue;
                for (ObjectName objectName : objectNames) {
                    String[] provisioningEndpoints = null;
                    provisioningEndpoints = (String[])this.getAttributeValue(targetName, objectName, "ProvisioningEndpoints");
                    if (provisioningEndpoints == null) continue;
                    for (String endpoint : provisioningEndpoints) {
                        if (endpointsList.contains(endpoint)) continue;
                        endpointsList.add(endpoint);
                    }
                }
            }
        }
        return GenericsSupport.toArray(endpointsList, String.class);
    }

    public String getServiceAssemblyDeploymentDescriptor(String serviceAssemblyName) throws ManagementRemoteException {
        String targetName = "domain";
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        AdministrationServiceMBeanImpl.logDebug("Calling deploy on DeploymentServiceMBean = " + deploymentServiceObjectName);
        Object resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "getServiceAssemblyDescriptor", serviceAssemblyName);
        if (resultObject != null) {
            return resultObject.toString();
        }
        Exception exception = this.createManagementException("ui.mbean.deploy.error", null, null);
        throw new ManagementRemoteException((Throwable)exception);
    }

    public String getServiceAssemblyState(String serviceAssemblyName, String targetName) throws ManagementRemoteException {
        String result = "Unknown";
        String xmlText = null;
        List infoList = null;
        String state = null;
        String componentName = null;
        try {
            ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
            this.checkForValidTarget(installerServiceObjectName, targetName);
            this.validateUiServiceAssemblyInfoState(state);
            List saInfoList = this.getServiceAssemblyInfoList(AdministrationServiceMBeanImpl.toFrameworkServiceAssemblyState(state), componentName, targetName);
            xmlText = ServiceAssemblyInfo.writeAsXmlTextWithProlog((List)saInfoList);
            if (xmlText != null && xmlText.length() > 0) {
                infoList = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)xmlText);
                for (ServiceAssemblyInfo info : infoList) {
                    if (!info.getName().equals(serviceAssemblyName)) continue;
                    return info.getState();
                }
            }
        }
        catch (ManagementRemoteException e) {
            // empty catch block
        }
        return result;
    }

    public String getServiceUnitDeploymentDescriptor(String serviceAssemblyName, String serviceUnitName) throws ManagementRemoteException {
        String targetName = "domain";
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        AdministrationServiceMBeanImpl.logDebug("Calling deploy on DeploymentServiceMBean = " + deploymentServiceObjectName);
        Object[] params = new Object[]{serviceAssemblyName, serviceUnitName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        Object resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "getServiceUnitDescriptor", params, signature);
        if (resultObject != null) {
            return resultObject.toString();
        }
        Exception exception = this.createManagementException("ui.mbean.deploy.error", null, null);
        throw new ManagementRemoteException((Throwable)exception);
    }

    public String getSharedLibraryInstallationDescriptor(String sharedLibraryName) throws ManagementRemoteException {
        String targetName = "domain";
        String jbiXml = this.getSharedLibraryDescriptor(sharedLibraryName, targetName);
        return jbiXml;
    }

    public String getWSDLDefinition(String componentName, String endpoint, String targetName) throws ManagementRemoteException {
        String wsdlDefinition = "";
        Map<String, ObjectName[]> targetToObjectNamesMap = null;
        targetToObjectNamesMap = this.findLiveExtensionMBeanObjectNames(componentName, "Statistics", targetName);
        if (targetToObjectNamesMap != null) {
            for (String instanceName : targetToObjectNamesMap.keySet()) {
                ObjectName[] objectNames = targetToObjectNamesMap.get(instanceName);
                if (objectNames != null) {
                    String[] signature;
                    Object[] params;
                    ObjectName objectName;
                    Object resultObject;
                    ObjectName[] arr$ = objectNames;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && ((resultObject = this.invokeMBeanOperation(targetName, objectName = arr$[i$], "getWSDLDefinition", params = new Object[]{endpoint}, signature = new String[]{"java.lang.String"})) == null || (wsdlDefinition = resultObject.toString()) == null || wsdlDefinition.length() <= 0); ++i$) {
                    }
                }
                if (wsdlDefinition == null || wsdlDefinition.length() <= 0) continue;
                break;
            }
        }
        return wsdlDefinition;
    }

    public String getWSDLImportedResource(String componentName, String endpoint, String targetNamespace, String targetName) throws ManagementRemoteException {
        String importedResource = "";
        Map<String, ObjectName[]> targetToObjectNamesMap = null;
        targetToObjectNamesMap = this.findLiveExtensionMBeanObjectNames(componentName, "Statistics", targetName);
        if (targetToObjectNamesMap != null) {
            for (String instanceName : targetToObjectNamesMap.keySet()) {
                ObjectName[] objectNames = targetToObjectNamesMap.get(instanceName);
                if (objectNames != null) {
                    for (ObjectName objectName : objectNames) {
                        Object[] params = new Object[]{endpoint, targetNamespace};
                        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
                        Object resultObject = this.invokeMBeanOperation(targetName, objectName, "getWSDLImportedResource", params, signature);
                        if (resultObject != null) {
                            importedResource = resultObject.toString();
                        }
                        if (importedResource != null && importedResource.length() > 0) break;
                    }
                }
                if (importedResource == null || importedResource.length() <= 0) continue;
                break;
            }
        }
        return importedResource;
    }

    public boolean isBindingComponent(String componentName) throws ManagementRemoteException {
        boolean isBindingComponent = false;
        String descriptorString = this.getComponentInstallationDescriptor(componentName);
        try {
            JBIDescriptor descriptor = JBIDescriptor.createJBIDescriptor((String)descriptorString);
            isBindingComponent = descriptor.isBindingComponentDescriptor();
        }
        catch (Exception e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        return isBindingComponent;
    }

    public boolean isJBIComponentInstalled(String componentName, String targetName) throws ManagementRemoteException {
        String xmlText = null;
        List infoList = null;
        String state = null;
        String sharedLibraryName = null;
        String serviceAssemblyName = null;
        try {
            xmlText = this.listComponents(ComponentType.BINDING, state, sharedLibraryName, serviceAssemblyName, targetName);
            if (xmlText != null && xmlText.length() > 0) {
                infoList = JBIComponentInfo.readFromXmlText((String)xmlText);
                for (JBIComponentInfo info : infoList) {
                    if (!componentName.equals(info.getName())) continue;
                    return true;
                }
            }
        }
        catch (ManagementRemoteException e) {
            // empty catch block
        }
        try {
            xmlText = this.listComponents(ComponentType.ENGINE, state, sharedLibraryName, serviceAssemblyName, targetName);
            if (xmlText != null && xmlText.length() > 0) {
                infoList = JBIComponentInfo.readFromXmlText((String)xmlText);
                for (JBIComponentInfo info : infoList) {
                    if (!componentName.equals(info.getName())) continue;
                    return true;
                }
            }
        }
        catch (ManagementRemoteException e) {
            // empty catch block
        }
        try {
            ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
            this.checkForValidTarget(installerServiceObjectName, targetName);
            List frameworkCompInfoList = this.getFrameworkComponentInfoListForSharedLibraries(null, targetName);
            List uiCompInfoList = new ArrayList();
            uiCompInfoList = this.toUiComponentInfoList(frameworkCompInfoList, targetName);
            xmlText = JBIComponentInfo.writeAsXmlText(uiCompInfoList);
            if (xmlText != null && xmlText.length() > 0) {
                infoList = JBIComponentInfo.readFromXmlText((String)xmlText);
                for (JBIComponentInfo info : infoList) {
                    if (!componentName.equals(info.getName())) continue;
                    return true;
                }
            }
        }
        catch (ManagementRemoteException e) {
            // empty catch block
        }
        return false;
    }

    public boolean isJBIRuntimeEnabled() throws ManagementRemoteException {
        return true;
    }

    public boolean isServiceAssemblyDeployed(String serviceAssemblyName, String targetName) throws ManagementRemoteException {
        String xmlText = null;
        List infoList = null;
        String state = null;
        String componentName = null;
        try {
            ObjectName installerServiceObjectName = this.getInstallationServiceMBeanObjectName(targetName);
            this.checkForValidTarget(installerServiceObjectName, targetName);
            this.validateUiServiceAssemblyInfoState(state);
            List saInfoList = this.getServiceAssemblyInfoList(AdministrationServiceMBeanImpl.toFrameworkServiceAssemblyState(state), componentName, targetName);
            xmlText = ServiceAssemblyInfo.writeAsXmlTextWithProlog((List)saInfoList);
            if (xmlText != null && xmlText.length() > 0) {
                infoList = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)xmlText);
                for (ServiceAssemblyInfo info : infoList) {
                    if (!serviceAssemblyName.equals(info.getName())) continue;
                    return true;
                }
            }
        }
        catch (ManagementRemoteException e) {
            // empty catch block
        }
        return false;
    }

    public boolean isServiceEngine(String componentName) throws ManagementRemoteException {
        boolean isServiceEngine = false;
        String descriptorString = this.getComponentInstallationDescriptor(componentName);
        try {
            JBIDescriptor descriptor = JBIDescriptor.createJBIDescriptor((String)descriptorString);
            isServiceEngine = descriptor.isServiceEngineDescriptor();
        }
        catch (Exception e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        return isServiceEngine;
    }

    protected String getInstallationDescriptor(String componentName, String targetName) {
        ComponentQuery componentQuery = null;
        ComponentInfo componentInfo = null;
        String jbiXml = null;
        componentQuery = this.environmentContext.getComponentQuery(targetName);
        if (componentQuery != null && (componentInfo = componentQuery.getComponentInfo(componentName)) != null) {
            jbiXml = componentInfo.getInstallationDescriptor();
        }
        return jbiXml;
    }

    protected String getSharedLibraryDescriptor(String libraryName, String targetName) {
        ComponentQuery componentQuery = null;
        ComponentInfo componentInfo = null;
        String jbiXml = null;
        componentQuery = this.environmentContext.getComponentQuery(targetName);
        if (componentQuery != null && (componentInfo = componentQuery.getSharedLibraryInfo(libraryName)) != null) {
            jbiXml = componentInfo.getInstallationDescriptor();
        }
        return jbiXml;
    }

    public String getAdminServerName() throws ManagementRemoteException {
        return super.getPlatformContextAdminServerName();
    }

    public boolean isAdminServer() throws ManagementRemoteException {
        return super.isPlatformContextAdminServer();
    }

    public String getInstanceName() throws ManagementRemoteException {
        return super.getPlatformContextInstanceName();
    }

    public boolean isInstanceUp(String instanceName) throws ManagementRemoteException {
        return super.isPlatformContextInstanceUp(instanceName);
    }

    public boolean supportsMultipleServers() throws ManagementRemoteException {
        return super.platformContextSupportsMultipleServers();
    }

    public String getTargetName() throws ManagementRemoteException {
        return super.getPlatformContextTargetName();
    }

    public String getTargetName(String instanceName) throws ManagementRemoteException {
        return super.getPlatformContextTargetName(instanceName);
    }

    public Set<String> getStandaloneServerNames() throws ManagementRemoteException {
        return super.getPlatformContextStandaloneServerNames();
    }

    public Set<String> getClusteredServerNames() throws ManagementRemoteException {
        return super.getPlatformContextClusteredServerNames();
    }

    public Set<String> getClusterNames() throws ManagementRemoteException {
        return super.getPlatformContextClusterNames();
    }

    public Set<String> getServersInCluster(String clusterName) throws ManagementRemoteException {
        return super.getPlatformContextServersInCluster(clusterName);
    }

    public boolean isValidTarget(String targetName) throws ManagementRemoteException {
        return super.isPlatformContextValidTarget(targetName);
    }

    public boolean isCluster(String targetName) throws ManagementRemoteException {
        return super.isPlatformContextCluster(targetName);
    }

    public boolean isStandaloneServer(String targetName) throws ManagementRemoteException {
        return super.isPlatformContextStandaloneServer(targetName);
    }

    public boolean isClusteredServer(String targetName) throws ManagementRemoteException {
        return super.isPlatformContextClusteredServer(targetName);
    }

    public boolean isInstanceClustered(String instanceName) throws ManagementRemoteException {
        return super.isPlatformContextInstanceClustered(instanceName);
    }

    public String getJmxRmiPort() throws ManagementRemoteException {
        return super.getPlatformContextJmxRmiPort();
    }

    public String getInstanceRoot() throws ManagementRemoteException {
        return super.getPlatformContextInstanceRoot();
    }

    public String getInstallRoot() throws ManagementRemoteException {
        return super.getPlatformContextInstallRoot();
    }

    public MBeanServerConnection getConnectionForInstance(String instanceName) throws ManagementRemoteException {
        MBeanServerConnection connection = null;
        try {
            connection = this.getPlatformContext().getMBeanServerConnection(instanceName);
        }
        catch (Exception e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        return connection;
    }
}

