/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.runtime;

import com.sun.jbi.ui.runtime.ComponentConfiguration;
import com.sun.jbi.ui.runtime.DisplayInformation;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ComponentConfigurationParser
extends DefaultHandler
implements Serializable {
    private boolean parsingInProgress;
    private Stack<String> qNameStack = new Stack();
    private ComponentConfiguration configuration = new ComponentConfiguration();
    private String[] displayKeys;
    private DisplayInformation[] displayInfo = null;
    private static final String CONFIGURATION_KEY = "Configuration";
    private static final String DISPLAYNAME_KEY = "displayName";
    private static final String DISPLAYDESCRIPTION_KEY = "displayDescription";
    private static final String ISPASSWORDFIELD_KEY = "isPasswordField";
    private static final String NAME_KEY = "name";

    public ComponentConfigurationParser(String[] keys) {
        this.displayKeys = new String[keys.length];
        this.displayInfo = new DisplayInformation[keys.length];
        for (int index = 0; index < keys.length; ++index) {
            this.displayKeys[index] = keys[index];
            this.displayInfo[index] = new DisplayInformation();
        }
    }

    public ComponentConfiguration getComponentConfiguration() {
        return this.configuration;
    }

    @Override
    public void startDocument() throws SAXException {
        this.parsingInProgress = true;
        this.qNameStack.removeAllElements();
    }

    @Override
    public void endDocument() throws SAXException {
        this.parsingInProgress = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String displayName = null;
        String displayDescription = null;
        String password = null;
        boolean isPasswordField = false;
        if (qName.endsWith(CONFIGURATION_KEY)) {
            String name = attributes.getValue(NAME_KEY);
            this.configuration.setName(name);
        } else {
            for (int index = 0; index < this.displayKeys.length; ++index) {
                if (this.displayKeys[index] == null || !qName.endsWith(this.displayKeys[index])) continue;
                isPasswordField = false;
                displayName = attributes.getValue(DISPLAYNAME_KEY);
                displayDescription = attributes.getValue(DISPLAYDESCRIPTION_KEY);
                password = attributes.getValue(ISPASSWORDFIELD_KEY);
                if (displayName != null && displayDescription != null && password != null) {
                    isPasswordField = Boolean.parseBoolean(password);
                    System.out.println("displayName:" + displayName + " displayDescription:" + displayDescription + " password:" + password + " isPasswordField:" + isPasswordField);
                    this.displayInfo[index] = new DisplayInformation(this.displayKeys[index], displayName, displayDescription, isPasswordField);
                    continue;
                }
                System.out.println("displayName:" + displayName + " displayDescription:" + displayDescription + " password:" + password);
            }
        }
        this.qNameStack.push(qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String chars = new String(ch, start, length);
        String qName = this.qNameStack.peek();
        if (!qName.endsWith(CONFIGURATION_KEY)) {
            for (int index = 0; index < this.displayKeys.length; ++index) {
                if (this.displayKeys[index] == null || !qName.endsWith(this.displayKeys[index])) continue;
                if (chars != null) {
                    this.displayInfo[index].setDefaultValue(chars);
                    continue;
                }
                this.displayInfo[index].setDefaultValue("");
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.qNameStack.pop();
        if (qName.endsWith(CONFIGURATION_KEY)) {
            for (int index = 0; index < this.displayKeys.length; ++index) {
                if (this.displayKeys[index] != null && this.displayInfo[index] != null) {
                    this.configuration.addDisplayDetail(this.displayKeys[index], this.displayInfo[index]);
                    continue;
                }
                System.out.println("Index " + index + " displayKeys or displayInfo is null.");
                if (this.displayKeys[index] != null) {
                    System.out.println("displayKeys[" + index + "] is: " + this.displayKeys[index]);
                }
                if (this.displayInfo[index] == null) continue;
                System.out.println("displayInfo[" + index + "] is: ");
                this.displayInfo[index].dump();
            }
        }
    }

    public static ComponentConfigurationParser parse(String uriString, String[] keys) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        URI uri = new URI(uriString);
        InputStream inputStream = uri.toURL().openStream();
        InputSource inputSource = new InputSource(inputStream);
        ComponentConfigurationParser parser = new ComponentConfigurationParser(keys);
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser;
    }

    public static ComponentConfigurationParser parseFromString(String xmlData, String[] keys) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlData.getBytes("UTF-8"));
        InputSource inputSource = new InputSource(inputStream);
        ComponentConfigurationParser parser = new ComponentConfigurationParser(keys);
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser;
    }

    public static void main(String[] args) {
        String uri = "file:///${jbicomps_home}/cachese/jbiadapter/componentconfiguration.xml";
        String[] keys = null;
        String propertiesFile = System.getProperty("JBICOMPS_HOME") + "/cachese/jbiadapter/config.properties";
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(propertiesFile));
        }
        catch (IOException e) {
            // empty catch block
        }
        keys = new String[properties.size()];
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            keys[index] = (String)entry.getKey();
            ++index;
        }
        try {
            ComponentConfigurationParser parser = ComponentConfigurationParser.parse(uri, keys);
            parser.getComponentConfiguration().dump();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

