/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.impl;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.openhft.affinity.IAffinity;

public enum NullAffinity implements IAffinity
{
    INSTANCE;

    private static final Logger LOGGER;

    @Override
    public long getAffinity() {
        return -1L;
    }

    @Override
    public void setAffinity(long affinity) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("unable to set mask to " + Long.toHexString(affinity) + " as the JNIa nd JNA libraries and not loaded");
        }
    }

    @Override
    public int getCpu() {
        return -1;
    }

    @Override
    public int getProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        return Integer.parseInt(name.split("@")[0]);
    }

    @Override
    public int getThreadId() {
        throw new UnsupportedOperationException();
    }

    static {
        LOGGER = Logger.getLogger(NullAffinity.class.getName());
    }
}

