/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessRunner.class);

    public static Process runClass(Class<?> clazz, String ... args) throws IOException {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List jvmArgsWithoutJavaAgents = runtimeMxBean.getInputArguments().stream().filter(arg -> !arg.startsWith("-javaagent:")).filter(arg -> !arg.startsWith("-agentlib:")).collect(Collectors.toList());
        String classPath = System.getProperty("java.class.path");
        String className = clazz.getName();
        String javaBin = ProcessRunner.findJavaBinPath().toString();
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.add(javaBin);
        allArgs.addAll(jvmArgsWithoutJavaAgents);
        allArgs.add("-cp");
        allArgs.add(classPath);
        allArgs.add(className);
        allArgs.addAll(Arrays.asList(args));
        ProcessBuilder processBuilder = new ProcessBuilder(allArgs.toArray(new String[0]));
        return processBuilder.start();
    }

    public static void printProcessOutput(String processName, Process process) {
        LOGGER.info("\nOutput for " + processName + "\nstdout:\n" + ProcessRunner.copyStreamToString(process.getInputStream()) + "\nstderr:\n" + ProcessRunner.copyStreamToString(process.getErrorStream()));
    }

    private static String copyStreamToString(InputStream inputStream) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int read;
            while (inputStream.available() > 0 && (read = inputStream.read(buffer)) >= 0) {
                os.write(buffer, 0, read);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new String(os.toByteArray(), Charset.defaultCharset());
    }

    private static Path findJavaBinPath() {
        Path javaBinPath = Paths.get(System.getProperty("java.home"), new String[0]).resolve("bin");
        Path linuxJavaExecutable = javaBinPath.resolve("java");
        if (linuxJavaExecutable.toFile().exists()) {
            return linuxJavaExecutable;
        }
        Path windowsJavaExecutable = javaBinPath.resolve("java.exe");
        if (windowsJavaExecutable.toFile().exists()) {
            return windowsJavaExecutable;
        }
        throw new IllegalStateException("Couldn't locate java executable!");
    }
}

