/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum BootClassPath {
    INSTANCE;

    private final Set<String> bootClassPathResources = Collections.unmodifiableSet(BootClassPath.getResourcesOnBootClasspath());

    private static Set<String> getResourcesOnBootClasspath() {
        Logger logger = LoggerFactory.getLogger(BootClassPath.class);
        HashSet<String> resources = new HashSet<String>();
        String bootClassPath = System.getProperty("sun.boot.class.path", "");
        if (!bootClassPath.isEmpty()) {
            String[] pathElements;
            logger.trace("Boot class-path is: {}", (Object)bootClassPath);
            String pathSeparator = File.pathSeparator;
            logger.trace("Path separator is: '{}'", (Object)pathSeparator);
            for (String pathElement : pathElements = bootClassPath.split(pathSeparator)) {
                resources.addAll(BootClassPath.findResources(Paths.get(pathElement, new String[0]), logger));
            }
        } else {
            resources.addAll(BootClassPath.findResourcesInJrt(logger));
        }
        return resources;
    }

    private static Set<String> findResourcesInJrt(Logger logger) {
        final HashSet<String> jrtResources = new HashSet<String>();
        try {
            FileSystem fs;
            try {
                fs = FileSystems.getFileSystem(URI.create("jrt:/"));
            }
            catch (FileSystemNotFoundException | ProviderNotFoundException e) {
                fs = FileSystems.newFileSystem(URI.create("jrt:/"), Collections.emptyMap());
            }
            final Path modules = fs.getPath("/modules", new String[0]);
            Files.walkFileTree(modules, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                @NotNull
                public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                    Path relative;
                    if (file.getFileName().toString().endsWith(".class") && (relative = modules.relativize(file)).getNameCount() > 1) {
                        Path classPath = relative.subpath(1, relative.getNameCount());
                        jrtResources.add(classPath.toString());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            logger.warn("Error walking jrt filesystem", (Throwable)e);
        }
        return jrtResources;
    }

    private static Set<String> findResources(Path path, Logger logger) {
        if (!Files.exists(path, new LinkOption[0])) {
            return Collections.emptySet();
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return BootClassPath.findResourcesInDirectory(path, logger);
        }
        return BootClassPath.findResourcesInJar(path, logger);
    }

    private static Set<String> findResourcesInJar(Path path, Logger logger) {
        HashSet<String> jarResources = new HashSet<String>();
        try (JarFile jarFile = new JarFile(path.toFile());){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!jarEntry.getName().endsWith(".class")) continue;
                jarResources.add(jarEntry.getName());
            }
        }
        catch (IOException e) {
            logger.warn("Not a jar file: {}", (Object)path);
        }
        return jarResources;
    }

    private static Set<String> findResourcesInDirectory(final Path path, Logger logger) {
        final HashSet<String> dirResources = new HashSet<String>();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                @NotNull
                public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(".class")) {
                        dirResources.add(path.relativize(file).toString());
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            logger.warn("Error walking dir: {}", (Object)path, (Object)e);
        }
        return dirResources;
    }

    public final boolean has(String binaryClassName) {
        String resourceClassName = binaryClassName.replace('.', '/').concat(".class");
        return this.bootClassPathResources.contains(resourceClassName);
    }
}

