/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.bytes;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.bytes.AccessCommon;
import net.openhft.chronicle.algo.bytes.ArrayAccessors;
import net.openhft.chronicle.algo.bytes.ByteBufferAccessor;
import net.openhft.chronicle.algo.bytes.BytesAccessors;
import net.openhft.chronicle.algo.bytes.CharSequenceAccessor;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.bytes.BytesStore;

public interface Accessor<S, T, A extends AccessCommon<T>> {
    public static <B extends BytesStore<B, U>, U> Full<B, ?> checkedBytesStoreAccessor() {
        return BytesAccessors.Generic.INSTANCE;
    }

    public static Full<ByteBuffer, ?> uncheckedByteBufferAccessor(ByteBuffer buffer) {
        return ByteBufferAccessor.unchecked(buffer);
    }

    public static Full<boolean[], boolean[]> booleanArrayAccessor() {
        return ArrayAccessors.Boolean.INSTANCE;
    }

    public static Full<byte[], byte[]> byteArrayAccessor() {
        return ArrayAccessors.Byte.INSTANCE;
    }

    public static Full<char[], char[]> charArrayAccessor() {
        return ArrayAccessors.Char.INSTANCE;
    }

    public static Full<short[], short[]> shortArrayAccessor() {
        return ArrayAccessors.Short.INSTANCE;
    }

    public static Full<int[], int[]> intArrayAccessor() {
        return ArrayAccessors.Int.INSTANCE;
    }

    public static Full<long[], long[]> longArrayAccessor() {
        return ArrayAccessors.Long.INSTANCE;
    }

    public static Read<String, ?> stringAccessor() {
        return CharSequenceAccessor.stringAccessor;
    }

    public static Read<CharSequence, CharSequence> checkedNativeCharSequenceAccessor() {
        return CharSequenceAccessor.nativeCharSequenceAccessor();
    }

    public static Read<CharSequence, CharSequence> checkedCharSequenceAccess(ByteOrder order) {
        return order == ByteOrder.LITTLE_ENDIAN ? CharSequenceAccessor.LITTLE_ENDIAN : CharSequenceAccessor.BIG_ENDIAN;
    }

    public A access();

    public T handle(S var1);

    public long offset(S var1, long var2);

    default public long size(long size) {
        return size;
    }

    public static interface Full<S, T>
    extends Accessor<S, T, Access<T>> {
    }

    public static interface Read<S, T>
    extends Accessor<S, T, ReadAccess<T>> {
    }
}

