/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.analytics.internal;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalTime;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

enum FilesUtil {

    private static final String CHRONICLE_ANALYTICS_LAST_FILE_NAME = "/.chronicle.analytics.last";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String acquireClientId(@NotNull String clientIdFileName, @NotNull Consumer<String> debugLogger) {
        Path path = Paths.get(clientIdFileName, new String[0]);
        try (Stream<String> lines = Files.lines(path, StandardCharsets.UTF_8);){
            String string = lines.findFirst().map(UUID::fromString).orElseThrow(NoSuchElementException::new).toString();
            return string;
        }
        catch (Exception e) {
            debugLogger.accept("Client id file not present: " + path.toAbsolutePath() + ' ' + e);
            String id = UUID.randomUUID().toString();
            try {
                Files.write(path, id.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                return id;
            }
            catch (IOException ioe) {
                debugLogger.accept("Unable to create client id file: " + path.toAbsolutePath() + ' ' + ioe);
            }
            return id;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isSameAsLastUsedFileTimeStampSecond(int currentSecondOfDay) {
        Path path = FilesUtil.lastPath();
        try (Stream<String> lines = Files.lines(path, StandardCharsets.UTF_8);){
            boolean same;
            int secondOfDay = lines.findFirst().map(Integer::parseInt).orElse(0);
            boolean bl = same = secondOfDay == currentSecondOfDay;
            if (!same) {
                FilesUtil.touchLastContent(path);
            }
            boolean bl2 = same;
            return bl2;
        }
        catch (IOException fileNotFound) {
            FilesUtil.touchLastContent(path);
            return false;
        }
    }

    static void touchLastContent(Path path) {
        try {
            Files.write(path, Integer.toString(LocalTime.now().toSecondOfDay()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void removeLastUsedFileTimeStampSecond() {
        try {
            Files.delete(FilesUtil.lastPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Path lastPath() {
        String fileName = Optional.ofNullable(System.getProperty("user.home")).orElse(".") + CHRONICLE_ANALYTICS_LAST_FILE_NAME;
        return Paths.get(fileName, new String[0]);
    }
}

