/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.bytes.Access;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class HeapBytesStore<Underlying>
implements BytesStore<HeapBytesStore<Underlying>, Underlying> {
    private static final Memory MEMORY = OS.memory();
    final Object realUnderlyingObject;
    final int dataOffset;
    final int capacity;
    private final AtomicLong refCount = new AtomicLong(1L);
    private final Underlying underlyingObject;

    private HeapBytesStore(ByteBuffer byteBuffer) {
        this.underlyingObject = byteBuffer;
        this.realUnderlyingObject = byteBuffer.array();
        this.dataOffset = Unsafe.ARRAY_BYTE_BASE_OFFSET;
        this.capacity = byteBuffer.capacity();
    }

    static HeapBytesStore<ByteBuffer> wrap(ByteBuffer bb) {
        return new HeapBytesStore<ByteBuffer>(bb);
    }

    public void reserve() {
        this.refCount.incrementAndGet();
    }

    public void release() {
        this.refCount.decrementAndGet();
    }

    public long refCount() {
        return this.refCount.get();
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public Underlying underlyingObject() {
        return this.underlyingObject;
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int value) {
        return MEMORY.compareAndSwapInt(this.realUnderlyingObject, (long)this.dataOffset + offset, expected, value);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) {
        return MEMORY.compareAndSwapLong(this.realUnderlyingObject, (long)this.dataOffset + offset, expected, value);
    }

    @Override
    public Access<Underlying> access() {
        return Access.nativeAccess();
    }

    @Override
    public byte readByte(long offset) {
        this.checkOffset(offset, 1);
        return MEMORY.readByte(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public short readShort(long offset) {
        this.checkOffset(offset, 2);
        return MEMORY.readShort(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public int readInt(long offset) {
        this.checkOffset(offset, 4);
        return MEMORY.readInt(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public long readLong(long offset) {
        this.checkOffset(offset, 8);
        return MEMORY.readLong(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public float readFloat(long offset) {
        this.checkOffset(offset, 4);
        return MEMORY.readFloat(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public double readDouble(long offset) {
        this.checkOffset(offset, 8);
        return MEMORY.readDouble(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    public void checkOffset(long offset, int size) {
        if (offset < this.start() || offset + (long)size > (long)this.capacity) {
            throw new BufferOverflowException();
        }
    }

    @Override
    public HeapBytesStore<Underlying> writeByte(long offset, byte b) {
        this.checkOffset(offset, 1);
        MEMORY.writeByte(this.realUnderlyingObject, (long)this.dataOffset + offset, b);
        return this;
    }

    @Override
    public HeapBytesStore<Underlying> writeShort(long offset, short i16) {
        this.checkOffset(offset, 2);
        MEMORY.writeShort(this.realUnderlyingObject, (long)this.dataOffset + offset, i16);
        return this;
    }

    @Override
    public HeapBytesStore writeInt(long offset, int i32) {
        this.checkOffset(offset, 4);
        MEMORY.writeInt(this.realUnderlyingObject, (long)this.dataOffset + offset, i32);
        return this;
    }

    @Override
    public HeapBytesStore<Underlying> writeOrderedInt(long offset, int i32) {
        this.checkOffset(offset, 4);
        MEMORY.writeOrderedInt(this.realUnderlyingObject, (long)this.dataOffset + offset, i32);
        return this;
    }

    @Override
    public HeapBytesStore<Underlying> writeLong(long offset, long i64) {
        this.checkOffset(offset, 8);
        MEMORY.writeLong(this.realUnderlyingObject, (long)this.dataOffset + offset, i64);
        return this;
    }

    @Override
    public HeapBytesStore<Underlying> writeOrderedLong(long offset, long i) {
        this.checkOffset(offset, 8);
        MEMORY.writeOrderedLong(this.realUnderlyingObject, (long)this.dataOffset + offset, i);
        return this;
    }

    @Override
    public HeapBytesStore<Underlying> writeFloat(long offset, float f) {
        this.checkOffset(offset, 4);
        MEMORY.writeFloat(this.realUnderlyingObject, (long)this.dataOffset + offset, f);
        return this;
    }

    @Override
    public HeapBytesStore<Underlying> writeDouble(long offset, double d) {
        this.checkOffset(offset, 8);
        MEMORY.writeDouble(this.realUnderlyingObject, (long)this.dataOffset + offset, d);
        return this;
    }

    @Override
    public HeapBytesStore<Underlying> write(long offsetInRDO, byte[] bytes, int offset, int length) {
        this.checkOffset(offset, length);
        MEMORY.copyMemory(bytes, offset, this.realUnderlyingObject, (long)this.dataOffset + offsetInRDO, length);
        return this;
    }

    @Override
    public HeapBytesStore<Underlying> write(long offsetInRDO, ByteBuffer bytes, int offset, int length) {
        this.checkOffset(offset, length);
        if (bytes.isDirect()) {
            MEMORY.copyMemory(((DirectBuffer)((Object)bytes)).address(), this.realUnderlyingObject, (long)this.dataOffset + offsetInRDO, length);
        } else {
            MEMORY.copyMemory(bytes.array(), offset, this.realUnderlyingObject, (long)this.dataOffset + offsetInRDO, length);
        }
        return this;
    }

    @Override
    public HeapBytesStore<Underlying> write(long offsetInRDO, Bytes bytes, long offset, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long address() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Underlying accessHandle() {
        return (Underlying)this.realUnderlyingObject;
    }

    @Override
    public long accessOffset(long randomOffset) {
        return (long)this.dataOffset + randomOffset;
    }

    @Override
    public void nativeRead(long position, long address, long size) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void nativeWrite(long address, long position, long size) {
        throw new UnsupportedOperationException("todo");
    }
}

