/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.crypto.Cipher;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.HeapBytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.ReferenceCounted;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BytesStore<B extends BytesStore<B, Underlying>, Underlying>
extends RandomDataInput,
RandomDataOutput<B>,
ReferenceCounted,
CharSequence {
    public static BytesStore from(@NotNull CharSequence cs) {
        if (cs instanceof BytesStore) {
            return ((BytesStore)cs).copy();
        }
        return BytesStore.wrap(cs.toString().getBytes(StandardCharsets.ISO_8859_1));
    }

    public static HeapBytesStore<byte[]> wrap(@NotNull byte[] bytes) {
        return HeapBytesStore.wrap(bytes);
    }

    @NotNull
    public static BytesStore<?, ByteBuffer> wrap(@NotNull ByteBuffer bb) {
        return bb.isDirect() ? NativeBytesStore.wrap(bb) : HeapBytesStore.wrap(bb);
    }

    @NotNull
    public static PointerBytesStore nativePointer() {
        return new PointerBytesStore();
    }

    @NotNull
    public static PointerBytesStore wrap(long address, long length) {
        PointerBytesStore pbs = BytesStore.nativePointer();
        pbs.set(address, length);
        return pbs;
    }

    public static BytesStore empty() {
        return NoBytesStore.noBytesStore();
    }

    @Override
    public boolean isDirectMemory();

    public BytesStore<B, Underlying> copy();

    @Override
    @NotNull
    default public Bytes<Underlying> bytesForRead() throws IllegalStateException {
        try {
            return (Bytes)((Bytes)this.bytesForWrite().readLimit(this.writeLimit())).readPosition(this.start());
        }
        catch (BufferUnderflowException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    @NotNull
    default public Bytes<Underlying> bytesForWrite() throws IllegalStateException {
        return new VanillaBytes(this, this.writePosition(), this.writeLimit());
    }

    default public boolean isClear() {
        return true;
    }

    @Override
    default public long realCapacity() {
        return this.capacity();
    }

    @Override
    public long capacity();

    @Nullable
    public Underlying underlyingObject();

    default public boolean inside(long offset) {
        return this.start() <= offset && offset < this.safeLimit();
    }

    default public long safeLimit() {
        return this.capacity();
    }

    default public long copyTo(@NotNull BytesStore store) {
        long readPos = this.readPosition();
        long writePos = store.writePosition();
        long copy = Math.min(this.readRemaining(), store.capacity());
        try {
            long i;
            for (i = 0L; i < copy - 7L; i += 8L) {
                store.writeLong(writePos + i, this.readLong(readPos + i));
            }
            while (i < copy) {
                store.writeByte(writePos + i, this.readByte(readPos + i));
                ++i;
            }
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
        return copy;
    }

    default public void copyTo(@NotNull OutputStream out) throws IOException {
        BytesInternal.copy(this, out);
    }

    @Override
    @NotNull
    default public B zeroOut(long start, long end) {
        if (end <= start) {
            return (B)this;
        }
        if (start < this.start()) {
            start = this.start();
        }
        if (end > this.capacity()) {
            end = this.capacity();
        }
        try {
            long i;
            for (i = start; i < end - 7L; i += 8L) {
                this.writeLong(i, 0L);
            }
            while (i < end) {
                this.writeByte(i, 0);
                ++i;
            }
        }
        catch (IllegalArgumentException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
        return (B)this;
    }

    @Override
    default public int length() {
        return (int)Math.min(Integer.MAX_VALUE, this.readRemaining());
    }

    @Override
    default public char charAt(int index) throws IndexOutOfBoundsException {
        try {
            return (char)this.readUnsignedByte(this.readPosition() + (long)index);
        }
        catch (BufferUnderflowException e) {
            throw new IndexOutOfBoundsException(this.readPosition() + (long)index + " >= " + this.readLimit());
        }
    }

    @Override
    @NotNull
    default public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException("todo");
    }

    @NotNull
    default public String toDebugString() {
        return this.toDebugString(512L);
    }

    @NotNull
    default public String toDebugString(long maxLength) {
        return BytesInternal.toDebugString(this, maxLength);
    }

    @Nullable
    default public BytesStore bytesStore() {
        return this;
    }

    default public boolean equalBytes(@NotNull BytesStore bytesStore, long length) throws BufferUnderflowException {
        return length == 8L ? this.readLong(this.readPosition()) == bytesStore.readLong(bytesStore.readPosition()) : BytesInternal.equalBytesAny(this, bytesStore, length);
    }

    default public int byteCheckSum() throws IORuntimeException {
        return this.byteCheckSum(this.readPosition(), this.readLimit());
    }

    default public int byteCheckSum(long start, long end) {
        int sum = 0;
        for (long i = start; i < end; ++i) {
            sum += this.readByte(i);
        }
        return sum & 0xFF;
    }

    @Deprecated
    default public long longCheckSum() {
        long sum = 0L;
        try {
            long i;
            for (i = this.readPosition(); i < this.readLimit() - 7L; i += 8L) {
                sum += this.readLong(i);
            }
            if (i < this.readLimit()) {
                sum += this.readIncompleteLong(i);
            }
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
        return sum;
    }

    default public boolean endsWith(char c) {
        try {
            return this.readRemaining() > 0L && this.readUnsignedByte(this.readLimit() - 1L) == c;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public boolean startsWith(char c) {
        try {
            return this.readRemaining() > 0L && this.readUnsignedByte(this.readPosition()) == c;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public boolean contentEquals(@Nullable BytesStore bytesStore) {
        return BytesInternal.contentEqual(this, bytesStore);
    }

    default public boolean startsWith(@Nullable BytesStore bytesStore) {
        return BytesInternal.startsWith(this, bytesStore);
    }

    @NotNull
    default public String to8bitString() throws IllegalArgumentException {
        return BytesInternal.to8bitString(this);
    }

    @Deprecated
    default public byte addAndGetByteNotAtomic(long offset, byte adding) throws BufferUnderflowException {
        try {
            byte r = (byte)(this.readByte(offset) + adding);
            this.writeByte(offset, r);
            return r;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public int addAndGetUnsignedByteNotAtomic(long offset, int adding) throws BufferUnderflowException {
        try {
            int r = this.readUnsignedByte(offset) + adding & 0xFF;
            this.writeByte(offset, (byte)r);
            return r;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public short addAndGetShortNotAtomic(long offset, short adding) throws BufferUnderflowException {
        try {
            short r = (short)(this.readShort(offset) + adding);
            this.writeByte(offset, r);
            return r;
        }
        catch (IllegalArgumentException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Deprecated
    default public int addAndGetUnsignedShortNotAtomic(long offset, int adding) throws BufferUnderflowException {
        try {
            int r = this.readUnsignedShort(offset) + adding & 0xFFFF;
            this.writeShort(offset, (short)r);
            return r;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public int addAndGetIntNotAtomic(long offset, int adding) throws BufferUnderflowException {
        try {
            int r = this.readInt(offset) + adding;
            this.writeInt(offset, r);
            return r;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Deprecated
    default public long addAndGetUnsignedIntNotAtomic(long offset, int adding) throws BufferUnderflowException {
        try {
            int r = this.readInt(offset) + adding;
            this.writeInt(offset, r);
            return r;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Deprecated
    default public long addAndGetLongNotAtomic(long offset, long adding) throws BufferUnderflowException {
        try {
            long r = this.readLong(offset) + adding;
            this.writeLong(offset, r);
            return r;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public float addAndGetFloatNotAtomic(long offset, float adding) throws BufferUnderflowException {
        try {
            float r = this.readFloat(offset) + adding;
            this.writeFloat(offset, r);
            return r;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Deprecated
    default public double addAndGetDoubleNotAtomic(long offset, double adding) throws BufferUnderflowException {
        try {
            double r = this.readDouble(offset) + adding;
            this.writeDouble(offset, r);
            return r;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Deprecated
    default public void isPresent(boolean isPresent) throws IllegalArgumentException {
        if (!isPresent) {
            throw new IllegalArgumentException("isPresent=false not supported");
        }
    }

    @Deprecated
    default public boolean isPresent() {
        return true;
    }

    public void move(long var1, long var3, long var5) throws BufferUnderflowException;

    default public void writeMaxLong(long offset, long atLeast) throws BufferUnderflowException {
        try {
            long v;
            do {
                if ((v = this.readVolatileLong(offset)) < atLeast) continue;
                return;
            } while (!this.compareAndSwapLong(offset, v, atLeast));
            return;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    default public boolean isEmpty() {
        return this.readRemaining() == 0L;
    }

    default public void cipher(@NotNull Cipher cipher, @NotNull Bytes outBytes, @NotNull ByteBuffer using1, @NotNull ByteBuffer using2) throws IllegalStateException {
        long readPos = outBytes.readPosition();
        try {
            NativeBytesStore<Void> inBytes;
            long writePos = outBytes.writePosition();
            long size = this.readRemaining();
            if (this.isDirectMemory()) {
                inBytes = this;
            } else {
                inBytes = NativeBytesStore.nativeStore(size);
                this.copyTo(inBytes);
            }
            BytesInternal.assignBytesStoreToByteBuffer(inBytes, using1);
            int outputSize = cipher.getOutputSize(Math.toIntExact(size));
            outBytes.ensureCapacity(writePos + (long)outputSize);
            outBytes.readPositionRemaining(writePos, outputSize);
            BytesInternal.assignBytesStoreToByteBuffer(outBytes, using2);
            int len = cipher.update(using1, using2);
            if (!1.$assertionsDisabled && (len += cipher.doFinal(using1, using2)) != using2.position()) {
                throw new AssertionError();
            }
            outBytes.writePosition(writePos + (long)using2.position());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                outBytes.readPosition(readPos);
            }
            catch (BufferUnderflowException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    default public void cipher(@NotNull Cipher cipher, @NotNull Bytes outBytes) throws IllegalStateException {
        this.cipher(cipher, outBytes, BytesInternal.BYTE_BUFFER_TL.get(), BytesInternal.BYTE_BUFFER2_TL.get());
    }

    default public boolean readWrite() {
        return true;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

