/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.OS;
import org.jetbrains.annotations.NotNull;

public class UncheckedBytes<Underlying>
extends AbstractBytes<Underlying> {
    final Bytes underlyingBytes;

    public UncheckedBytes(@NotNull Bytes underlyingBytes) throws IllegalStateException {
        super(underlyingBytes.bytesStore(), underlyingBytes.writePosition(), underlyingBytes.writeLimit());
        this.underlyingBytes = underlyingBytes;
        this.readPosition(underlyingBytes.readPosition());
    }

    @Override
    public void ensureCapacity(long size) throws IllegalArgumentException {
        if (size > this.realCapacity()) {
            this.underlyingBytes.ensureCapacity(size);
            this.bytesStore = this.underlyingBytes.bytesStore();
        }
    }

    @Override
    @NotNull
    public Bytes<Underlying> unchecked(boolean unchecked) {
        return this;
    }

    @Override
    public boolean unchecked() {
        return true;
    }

    @Override
    void writeCheckOffset(long offset, long adding) {
    }

    @Override
    void readCheckOffset(long offset, long adding, boolean given) {
    }

    @Override
    void prewriteCheckOffset(long offset, long subtracting) {
    }

    @Override
    @NotNull
    public Bytes<Underlying> readPosition(long position) {
        this.readPosition = position;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> readLimit(long limit) {
        this.uncheckedWritePosition(limit);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writePosition(long position) {
        this.uncheckedWritePosition(position);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> readSkip(long bytesToSkip) {
        this.readPosition += bytesToSkip;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeSkip(long bytesToSkip) {
        this.uncheckedWritePosition(this.writePosition() + bytesToSkip);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeLimit(long limit) {
        this.writeLimit = limit;
        return this;
    }

    @Override
    @NotNull
    public BytesStore<Bytes<Underlying>, Underlying> copy() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public boolean isElastic() {
        return false;
    }

    @Override
    protected long readOffsetPositionMoved(long adding) {
        long offset = this.readPosition;
        this.readPosition += adding;
        return offset;
    }

    @Override
    protected long writeOffsetPositionMoved(long adding, long advance) {
        long oldPosition = this.writePosition();
        this.uncheckedWritePosition(this.writePosition() + advance);
        return oldPosition;
    }

    @Override
    protected long prewriteOffsetPositionMoved(long subtracting) throws BufferOverflowException {
        return this.readPosition -= subtracting;
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(@NotNull BytesStore bytes, long offset, long length) throws BufferOverflowException, IllegalArgumentException {
        if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else if (bytes.underlyingObject() == null && this.bytesStore.isDirectMemory() && length >= 32L) {
            this.rawCopy(bytes, offset, length);
        } else {
            super.write(bytes, offset, length);
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> append8bit(@NotNull CharSequence cs) throws BufferOverflowException, BufferUnderflowException {
        if (cs instanceof BytesStore) {
            return (Bytes)this.write((BytesStore)cs);
        }
        int length = cs.length();
        long offset = this.writeOffsetPositionMoved(length);
        for (int i = 0; i < length; ++i) {
            int c = cs.charAt(i);
            if (c > 255) {
                c = 63;
            }
            this.writeByte(offset, (byte)c);
        }
        return this;
    }

    public void rawCopy(@NotNull BytesStore bytes, long offset, long length) throws BufferOverflowException, IllegalArgumentException {
        long len = Math.min(this.writeRemaining(), Math.min(bytes.capacity() - offset, length));
        if (len > 0L) {
            this.writeCheckOffset(this.writePosition(), len);
            OS.memory().copyMemory(bytes.addressForRead(offset), this.addressForWrite(this.writePosition()), len);
            this.writeSkip(len);
        }
    }
}

