/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.channels.FileLock;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.Monitorable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractReference
extends AbstractCloseable
implements Byteable,
Closeable {
    @Nullable
    protected BytesStore<?, ?> bytes;
    protected long offset;

    protected AbstractReference() {
        this.singleThreadedCheckDisabled(true);
    }

    public void bytesStore(@NotNull BytesStore bytes, @NonNegative long offset, @NonNegative long length) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
        this.throwExceptionIfClosedInSetter();
        bytes.readInt(offset);
        BytesStore bytesStore = bytes.bytesStore();
        this.acceptNewBytesStore(bytesStore);
        this.offset = offset;
    }

    @Nullable
    public BytesStore bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    protected void acceptNewBytesStore(@NotNull BytesStore bytes) throws IllegalStateException {
        if (this.bytes != null) {
            this.bytes.release((ReferenceOwner)this);
        }
        this.bytes = bytes.bytesStore();
        this.bytes.reserve((ReferenceOwner)this);
    }

    protected void performClose() {
        if (this.bytes == null) {
            return;
        }
        BytesStore<?, ?> bytes0 = this.bytes;
        this.bytes = null;
        try {
            bytes0.release((ReferenceOwner)this);
        }
        catch (ClosedIllegalStateException closedIllegalStateException) {
            // empty catch block
        }
    }

    @Override
    public long address() throws IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        return this.bytesStore().addressForRead(this.offset);
    }

    @Override
    public FileLock lock(boolean shared) throws IOException {
        if (this.bytesStore() instanceof MappedBytesStore) {
            MappedBytesStore mbs = (MappedBytesStore)this.bytesStore();
            return mbs.lock(this.offset, this.maxSize(), shared);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock tryLock(boolean shared) throws IOException {
        if (this.bytesStore() instanceof MappedBytesStore) {
            MappedBytesStore mbs = (MappedBytesStore)this.bytesStore();
            return mbs.tryLock(this.offset, this.maxSize(), shared);
        }
        throw new UnsupportedOperationException();
    }

    public void unmonitor() {
        super.unmonitor();
        Monitorable.unmonitor(this.bytes);
    }
}

