/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Objects;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UncheckedBytes<U>
extends AbstractBytes<U> {
    private Bytes<?> underlyingBytes;

    public UncheckedBytes(@NotNull Bytes<?> underlyingBytes) throws IllegalStateException {
        super((BytesStore)Jvm.uncheckedCast(Objects.requireNonNull(underlyingBytes.bytesStore())), underlyingBytes.writePosition(), Math.min(underlyingBytes.writeLimit(), underlyingBytes.realCapacity()));
        this.underlyingBytes = underlyingBytes;
        this.readPosition(underlyingBytes.readPosition());
        if (this.writeLimit > this.capacity()) {
            this.writeLimit(this.capacity());
        }
    }

    public void setBytes(@NotNull Bytes<?> bytes) throws IllegalStateException {
        Objects.requireNonNull(bytes);
        BytesStore<?, ?> underlying = bytes.bytesStore();
        if (this.bytesStore != underlying) {
            this.bytesStore.release((ReferenceOwner)this);
            this.bytesStore((BytesStore)Jvm.uncheckedCast(underlying));
            this.bytesStore.reserve((ReferenceOwner)this);
        }
        this.readPosition(bytes.readPosition());
        this.uncheckedWritePosition(bytes.writePosition());
        this.writeLimit = bytes.writeLimit();
        this.underlyingBytes = bytes;
    }

    @Override
    public void ensureCapacity(@NonNegative long desiredCapacity) throws IllegalArgumentException, IllegalStateException {
        if (desiredCapacity > this.realCapacity()) {
            this.underlyingBytes.ensureCapacity(desiredCapacity);
            this.bytesStore((BytesStore)Jvm.uncheckedCast(this.underlyingBytes.bytesStore()));
        }
    }

    @Override
    @NotNull
    public Bytes<U> unchecked(boolean unchecked) {
        this.throwExceptionIfReleased();
        return this;
    }

    @Override
    public boolean unchecked() {
        return true;
    }

    @Override
    protected void writeCheckOffset(@NonNegative long offset, @NonNegative long adding) {
    }

    @Override
    protected void readCheckOffset(@NonNegative long offset, long adding, boolean given) {
    }

    @Override
    void prewriteCheckOffset(@NonNegative long offset, long subtracting) {
    }

    @Override
    @NotNull
    public Bytes<U> readPosition(@NonNegative long position) {
        this.readPosition = position;
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> readLimit(@NonNegative long limit) {
        this.uncheckedWritePosition(limit);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writePosition(@NonNegative long position) {
        this.uncheckedWritePosition(position);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> readSkip(long bytesToSkip) {
        this.readPosition += bytesToSkip;
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeSkip(long bytesToSkip) {
        this.uncheckedWritePosition(this.writePosition() + bytesToSkip);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeLimit(@NonNegative long limit) {
        this.writeLimit = limit;
        return this;
    }

    @Override
    @NotNull
    public BytesStore<Bytes<U>, U> copy() {
        this.throwExceptionIfReleased();
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public boolean isElastic() {
        return false;
    }

    @Override
    protected long readOffsetPositionMoved(@NonNegative long adding) {
        long offset = this.readPosition;
        this.readPosition += adding;
        return offset;
    }

    @Override
    protected long writeOffsetPositionMoved(@NonNegative long adding, @NonNegative long advance) {
        long oldPosition = this.writePosition();
        this.uncheckedWritePosition(this.writePosition() + advance);
        return oldPosition;
    }

    @Override
    protected long prewriteOffsetPositionMoved(@NonNegative long subtracting) throws BufferOverflowException {
        this.readPosition -= subtracting;
        return this.readPosition;
    }

    @Override
    @NotNull
    public Bytes<U> write(@NotNull RandomDataInput bytes, @NonNegative long offset, @NonNegative long length) throws BufferOverflowException, IllegalArgumentException, IllegalStateException, BufferUnderflowException {
        Objects.requireNonNull(bytes);
        if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else {
            super.write(bytes, offset, length);
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> write(@NotNull BytesStore<?, ?> bytes, @NonNegative long offset, @NonNegative long length) throws BufferOverflowException, IllegalArgumentException, IllegalStateException, BufferUnderflowException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        Longs.requireNonNegative((long)offset);
        Longs.requireNonNegative((long)length);
        if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else if (bytes.underlyingObject() == null && this.bytesStore.isDirectMemory() && length >= 32L) {
            this.rawCopy(bytes, offset, length);
        } else {
            super.write(bytes, offset, length);
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> append8bit(@NotNull CharSequence cs) throws BufferOverflowException, BufferUnderflowException, IllegalStateException {
        Objects.requireNonNull(cs);
        if (cs instanceof RandomDataInput) {
            return this.write((RandomDataInput)((Object)cs));
        }
        int length = cs.length();
        long offset = this.writeOffsetPositionMoved(length);
        for (int i = 0; i < length; ++i) {
            int c = cs.charAt(i);
            if (c > 255) {
                c = 63;
            }
            this.writeByte(offset++, (byte)c);
        }
        return this;
    }

    long rawCopy(@NotNull BytesStore<?, ?> bytes, @NonNegative long offset, @NonNegative long length) throws BufferOverflowException, IllegalStateException, BufferUnderflowException {
        Objects.requireNonNull(bytes);
        long len = Math.min(this.writeRemaining(), Math.min(bytes.capacity() - offset, length));
        if (len > 0L) {
            this.writeCheckOffset(this.writePosition(), len);
            this.throwExceptionIfReleased();
            OS.memory().copyMemory(bytes.addressForRead(offset), this.addressForWritePosition(), len);
            this.writeSkip(len);
        }
        return len;
    }

    @Override
    @NotNull
    public Bytes<U> writeByte(byte i8) throws BufferOverflowException, IllegalStateException {
        long offset = this.writeOffsetPositionMoved(1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeUtf8(@Nullable String text) throws BufferOverflowException, IllegalStateException {
        if (text == null) {
            BytesInternal.writeStopBitNeg1(this);
            return this;
        }
        if (Jvm.isJava9Plus()) {
            byte[] strBytes = StringUtils.extractBytes((String)text);
            byte coder = StringUtils.getStringCoder((String)text);
            long utfLength = AppendableUtil.findUtf8Length(strBytes, coder);
            this.writeStopBit(utfLength);
            this.appendUtf8(strBytes, 0, text.length(), coder);
        } else {
            char[] chars = StringUtils.extractChars((String)text);
            long utfLength = AppendableUtil.findUtf8Length(chars);
            this.writeStopBit(utfLength);
            if (utfLength == (long)chars.length) {
                this.append8bit(chars);
            } else {
                this.appendUtf8(chars, 0, chars.length);
            }
        }
        return this;
    }

    void append8bit(@NotNull char[] chars) throws BufferOverflowException, IllegalArgumentException, IllegalStateException {
        Objects.requireNonNull(chars);
        long wp = this.writePosition();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            this.bytesStore.writeByte(wp++, (byte)c);
        }
        this.uncheckedWritePosition(wp);
    }

    @Override
    @NotNull
    public Bytes<U> appendUtf8(char[] chars, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException, IllegalArgumentException, IllegalStateException {
        char c;
        int i;
        long wp;
        block3: {
            Objects.requireNonNull(chars);
            wp = this.writePosition();
            for (i = 0; i < length; ++i) {
                c = chars[offset + i];
                if (c <= '\u007f') {
                    this.bytesStore.writeByte(wp++, (byte)c);
                    continue;
                }
                break block3;
            }
            this.uncheckedWritePosition(wp);
            return this;
        }
        while (i < length) {
            c = chars[offset + i];
            BytesInternal.appendUtf8Char(this, c);
            ++i;
        }
        this.uncheckedWritePosition(wp);
        return this;
    }
}

