/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.util.concurrent.atomic.AtomicLong;

public class ReferenceCounter {
    private final AtomicLong value = new AtomicLong(1L);
    private final Runnable onRelease;

    private ReferenceCounter(Runnable onRelease) {
        this.onRelease = onRelease;
    }

    public static ReferenceCounter onReleased(Runnable onRelease) {
        return new ReferenceCounter(onRelease);
    }

    public void reserve() throws IllegalStateException {
        long v;
        do {
            if ((v = this.value.get()) > 0L) continue;
            throw new IllegalStateException("Released");
        } while (!this.value.compareAndSet(v, v + 1L));
    }

    public void release() throws IllegalStateException {
        block1: {
            long v;
            do {
                if ((v = this.value.get()) > 0L) continue;
                throw new IllegalStateException("Released");
            } while (!this.value.compareAndSet(v, v - 1L));
            if (v != 1L) break block1;
            this.onRelease.run();
        }
    }

    public long get() {
        return this.value.get();
    }

    public String toString() {
        return Long.toString(this.value.get());
    }

    public void releaseAll() {
        if (this.value.get() > 0L) {
            this.onRelease.run();
        }
    }
}

