/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.util.URIEncoder;

public class WebExceptionHandler
implements ExceptionHandler {
    private final Properties properties = new Properties();
    private final ExceptionHandler fallBack;
    private final String baseURI;

    public WebExceptionHandler(String propertiesFile, ExceptionHandler fallBack) {
        assert (fallBack != null);
        this.fallBack = fallBack;
        InputStream stream = WebExceptionHandler.class.getResourceAsStream(propertiesFile);
        try {
            if (stream != null) {
                this.properties.load(stream);
            }
        }
        catch (IOException e) {
            Slf4jExceptionHandler.WARN.on(this.getClass(), "Unable to load " + propertiesFile, e);
        }
        this.baseURI = this.properties.getProperty("baseUri", "http://stackoverflow.com/search?q=%5Bjava%5D");
    }

    @Override
    public void on(Class clazz, String message, Throwable t) {
        while (t.getCause() != null && t.getCause() != t) {
            t = t.getCause();
        }
        String uri = this.properties.getProperty(t.getClass().getName());
        if (uri == null) {
            uri = this.baseURI;
            String version = System.getProperty("java.version");
            if (version.compareTo("1.5") >= 0) {
                String[] parts = version.split("\\.");
                version = parts[1];
            }
            uri = uri + "+" + version + "+" + URIEncoder.encodeURI(t.toString()) + "+" + URIEncoder.encodeURI(clazz.getSimpleName());
            if (message != null) {
                uri = uri + "+" + URIEncoder.encodeURI(message);
            }
        }
        try {
            if (Jvm.isDebug() && Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(uri));
            } else {
                this.fallBack.on(clazz, message, t);
            }
        }
        catch (Exception e) {
            this.fallBack.on(WebExceptionHandler.class, "Failed to open browser", e);
        }
    }
}

