/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.jlbh;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.openhft.affinity.Affinity;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.jlbh.JLBHTask;
import org.jetbrains.annotations.NotNull;

public class JLBHOptions {
    int throughput = 10000;
    TimeUnit throughputTimeUnit = TimeUnit.SECONDS;
    boolean accountForCoordinatedOmission = true;
    int recordJitterGreaterThanNs = 1000;
    boolean recordOSJitter = true;
    int warmUpIterations = Jvm.compileThreshold() * 6 / 5;
    int runs = 3;
    int iterations = 100000;
    JLBHTask jlbhTask;
    int pauseAfterWarmupMS = 0;
    @NotNull
    SKIP_FIRST_RUN skipFirstRun = SKIP_FIRST_RUN.NOT_SET;
    boolean jitterAffinity;
    Supplier<AffinityLock> acquireLock = Affinity::acquireLock;
    long timeout;

    @NotNull
    public JLBHOptions throughput(int throughput) {
        return this.throughput(throughput, TimeUnit.SECONDS);
    }

    @NotNull
    public JLBHOptions throughput(int throughput, TimeUnit throughputTimeUnit) {
        this.throughput = throughput;
        this.throughputTimeUnit = throughputTimeUnit;
        return this;
    }

    @NotNull
    public JLBHOptions accountForCoordinatedOmmission(boolean accountForCoordinatedOmmission) {
        this.accountForCoordinatedOmission = accountForCoordinatedOmmission;
        return this;
    }

    @NotNull
    public JLBHOptions recordJitterGreaterThanNs(int recordJitterGreaterThanNs) {
        this.recordJitterGreaterThanNs = recordJitterGreaterThanNs;
        return this;
    }

    @NotNull
    public JLBHOptions recordOSJitter(boolean recordOSJitter) {
        this.recordOSJitter = recordOSJitter;
        return this;
    }

    @NotNull
    public JLBHOptions warmUpIterations(int warmUp) {
        this.warmUpIterations = warmUp;
        return this;
    }

    @NotNull
    public JLBHOptions runs(int runs) {
        this.runs = runs;
        return this;
    }

    @NotNull
    public JLBHOptions iterations(int iterations) {
        this.iterations = iterations;
        return this;
    }

    @NotNull
    public JLBHOptions jlbhTask(JLBHTask JLBHTask2) {
        this.jlbhTask = JLBHTask2;
        return this;
    }

    @NotNull
    public JLBHOptions pauseAfterWarmupMS(int pauseMS) {
        this.pauseAfterWarmupMS = pauseMS;
        return this;
    }

    @NotNull
    public JLBHOptions skipFirstRun(boolean skip) {
        this.skipFirstRun = skip ? SKIP_FIRST_RUN.SKIP : SKIP_FIRST_RUN.NO_SKIP;
        return this;
    }

    @NotNull
    public JLBHOptions jitterAffinity(boolean jitterAffinity) {
        this.jitterAffinity = jitterAffinity;
        return this;
    }

    public JLBHOptions acquireLock(Supplier<AffinityLock> acquireLock) {
        this.acquireLock = acquireLock;
        return this;
    }

    public JLBHOptions timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    static enum SKIP_FIRST_RUN {
        NOT_SET,
        SKIP,
        NO_SKIP;

    }
}

