/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.analytics;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.stream.Stream;
import net.openhft.chronicle.core.Jvm;
import org.jetbrains.annotations.NotNull;

public final class ReflectionUtil {
    private static final String ANALYTICS_NAME = "net.openhft.chronicle.analytics.Analytics";

    public static boolean analyticsPresent() {
        try {
            Class.forName(ANALYTICS_NAME);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    @NotNull
    public static Object analyticsBuilder(@NotNull String measurementId, @NotNull String apiSecret) {
        try {
            Method method = ReflectionUtil.methodOrThrow(ANALYTICS_NAME, "builder", String.class, String.class);
            return method.invoke(null, measurementId, apiSecret);
        }
        catch (ReflectiveOperationException e) {
            Jvm.rethrow(e);
            return null;
        }
    }

    @NotNull
    public static Method methodOrThrow(@NotNull String className, @NotNull String methodName, Class<?> ... parameterTypes) {
        try {
            Class<?> analyticsClass = Class.forName(className);
            Method method = analyticsClass.getMethod(methodName, parameterTypes);
            return method;
        }
        catch (ReflectiveOperationException e) {
            Jvm.rethrow(e);
            return null;
        }
    }

    public static Object invokeOrThrow(@NotNull Method m, @NotNull Object target, Object ... params) {
        try {
            return m.invoke(target, params);
        }
        catch (ReflectiveOperationException e) {
            Jvm.rethrow(e);
            return null;
        }
    }

    @NotNull
    public static <T> T reflectiveProxy(@NotNull Class<T> interf, @NotNull Object delegate) {
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{interf}, (InvocationHandler)new ReflectiveInvocationHandler(delegate, false));
    }

    @NotNull
    public static <T> T reflectiveProxy(@NotNull Class<T> interf, @NotNull Object delegate, boolean returnProxy) {
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{interf}, (InvocationHandler)new ReflectiveInvocationHandler(delegate, returnProxy));
    }

    private static final class ReflectiveInvocationHandler
    implements InvocationHandler {
        private final Object delegate;
        private final boolean returnProxy;

        public ReflectiveInvocationHandler(@NotNull Object delegate, boolean returnProxy) {
            this.delegate = delegate;
            this.returnProxy = returnProxy;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object[] parameterTypes = args == null ? null : (Class[])Stream.of(args).map(Object::getClass).toArray(Class[]::new);
            Method delegateMethod = this.delegate.getClass().getMethod(method.getName(), (Class<?>[])parameterTypes);
            if (delegateMethod == null) {
                throw new RuntimeException(String.format("Class %s does not have a method %s(%s)", this.delegate.getClass(), method.getName(), Arrays.toString(parameterTypes)));
            }
            Object result = delegateMethod.invoke(this.delegate, args);
            if (this.returnProxy && !"build".equals(method.getName())) {
                return proxy;
            }
            return result;
        }
    }
}

