/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import net.openhft.chronicle.core.internal.JvmExceptionTracker;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.threads.CleaningThread;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.testframework.internal.ExceptionTracker;
import org.junit.After;
import org.junit.Before;

public class CoreTestCommon {
    protected ThreadDump threadDump;
    private ExceptionTracker<?> exceptionTracker;

    @Before
    public void enableReferenceTracing() {
        AbstractReferenceCounted.enableReferenceTracing();
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Before
    public void createExceptionTracker() {
        this.exceptionTracker = JvmExceptionTracker.create();
    }

    public void expectException(String message) {
        this.exceptionTracker.expectException(message);
    }

    public void ignoreException(String message) {
        this.exceptionTracker.ignoreException(message);
    }

    @After
    public void afterChecks() {
        CleaningThread.performCleanup((Thread)Thread.currentThread());
        System.gc();
        AbstractCloseable.waitForCloseablesToClose((long)100L);
        AbstractReferenceCounted.assertReferencesReleased();
        this.checkThreadDump();
        this.exceptionTracker.checkExceptions();
        AbstractReferenceCounted.disableReferenceTracing();
    }
}

