/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import junit.framework.TestCase;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.testframework.FlakyTestRunner;
import org.junit.Test;

public class JvmSafepointTest {
    @Test
    public void testSafepoint() throws InterruptedException {
        int min;
        Thread t = new Thread(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() < start + 1000L && !Thread.interrupted()) {
                    for (int i = 0; i < 10000; ++i) {
                        Jvm.safepoint();
                    }
                }
            }
        };
        t.start();
        Jvm.pause((long)5L);
        int counter = 0;
        int n = min = Jvm.isAzulZing() ? 0 : 200;
        while (t.isAlive() && counter <= min) {
            StackTraceElement[] stackTrace = t.getStackTrace();
            if (stackTrace.length <= 1) continue;
            String s = stackTrace[1].toString();
            if (s.contains("safepoint")) {
                ++counter;
                continue;
            }
            if (!t.isAlive() || s.contains("interrupted")) continue;
            System.out.println(s);
        }
        t.interrupt();
        t.join();
        System.out.println("counter: " + counter);
        TestCase.assertTrue((String)("counter: " + counter), (counter > min ? 1 : 0) != 0);
    }

    @Test
    public void safePointPerf() {
        FlakyTestRunner.run((boolean)true, this::safePointPerf0, (int)3);
    }

    public void safePointPerf0() {
        for (int t = 0; t <= 5; ++t) {
            block5: {
                long start = System.nanoTime();
                int count = 10000;
                for (int i = 0; i < count; ++i) {
                    Jvm.safepoint();
                }
                long time = System.nanoTime() - start;
                if (t > 2) {
                    long avg = time / (long)count;
                    System.out.println("avg: " + avg);
                    int maxAvg = Jvm.isArm() ? 400 : 200;
                    try {
                        TestCase.assertTrue((String)("avg: " + avg), (1L <= avg && avg < (long)maxAvg ? 1 : 0) != 0);
                        break;
                    }
                    catch (AssertionError e) {
                        if (t != 5) break block5;
                        throw e;
                    }
                }
            }
            Jvm.pause((long)5L);
        }
    }
}

