/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.StringInterner;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class MathsTest {
    static final double err = 5.1E-9;
    private ThreadDump threadDump;

    @Test
    public void round1scan() {
        double factor = 10.0;
        this.roundEither(10.0, Maths::round1);
        this.roundUp(10.0, Maths::round1up);
        this.roundEither(10.0, d -> Maths.roundNup((double)d, (int)1));
        this.roundUp(10.0, d -> Maths.roundNup((double)d, (int)1));
    }

    @Test
    public void round2scan() {
        double factor = 100.0;
        this.roundEither(100.0, Maths::round2);
        this.roundUp(100.0, Maths::round2up);
        this.roundEither(100.0, d -> Maths.roundNup((double)d, (int)2));
        this.roundUp(100.0, d -> Maths.roundNup((double)d, (int)2));
    }

    @Test
    public void round3scan() {
        double factor = 1000.0;
        this.roundEither(1000.0, Maths::round3);
        this.roundUp(1000.0, Maths::round3up);
        this.roundEither(1000.0, d -> Maths.roundNup((double)d, (int)3));
        this.roundUp(1000.0, d -> Maths.roundNup((double)d, (int)3));
    }

    @Test
    public void round4scan() {
        double factor = 10000.0;
        this.roundEither(10000.0, Maths::round4);
        this.roundUp(10000.0, Maths::round4up);
        this.roundEither(10000.0, d -> Maths.roundNup((double)d, (int)4));
        this.roundUp(10000.0, d -> Maths.roundNup((double)d, (int)4));
    }

    @Test
    public void round5scan() {
        double factor = 100000.0;
        this.roundEither(100000.0, Maths::round5);
        this.roundUp(100000.0, Maths::round5up);
        this.roundEither(100000.0, d -> Maths.roundNup((double)d, (int)5));
        this.roundUp(100000.0, d -> Maths.roundNup((double)d, (int)5));
    }

    @Test
    public void round6scan() {
        double factor = 1000000.0;
        this.roundEither(1000000.0, Maths::round6);
        this.roundUp(1000000.0, Maths::round6up);
        this.roundEither(1000000.0, d -> Maths.roundNup((double)d, (int)6));
        this.roundUp(1000000.0, d -> Maths.roundNup((double)d, (int)6));
    }

    @Test
    public void round7scan() {
        double factor = 1.0E7;
        this.roundEither(1.0E7, Maths::round7);
        this.roundUp(1.0E7, Maths::round7up);
        this.roundEither(1.0E7, d -> Maths.roundNup((double)d, (int)7));
        this.roundUp(1.0E7, d -> Maths.roundNup((double)d, (int)7));
    }

    @Test
    public void round8scan() {
        double factor = 1.0E8;
        this.roundEither(1.0E8, Maths::round8);
        this.roundUp(1.0E8, Maths::round8up);
        this.roundEither(1.0E8, d -> Maths.roundNup((double)d, (int)8));
        this.roundUp(1.0E8, d -> Maths.roundNup((double)d, (int)8));
    }

    public void roundEither(double factor, Rounder rounder) {
        double factor2 = 2.0 * factor;
        for (int i = 1; i < 20000000; i += 2) {
            double dm = (double)i / factor2;
            double ulp = Math.ulp(dm);
            double d = dm + ulp;
            double d0 = dm - ulp * 2.0;
            double e = (double)(i + 1) / factor2;
            double e0 = (double)(i - 1) / factor2;
            String msg = "i: " + i;
            Assert.assertEquals((String)msg, (double)e, (double)rounder.round(d), (double)0.0);
            Assert.assertEquals((String)msg, (double)e0, (double)rounder.round(d0), (double)0.0);
        }
    }

    public void roundUp(double factor, Rounder rounder) {
        double factor2 = 2.0 * factor;
        for (int i = 1; i < 20000000; i += 2) {
            double d = (double)i / factor2;
            double d0 = d - Math.ulp(d) * 2.0;
            double e = (double)(i + 1) / factor2;
            double e0 = (double)(i - 1) / factor2;
            String msg = "i: " + i;
            Assert.assertEquals((String)msg, (double)e, (double)rounder.round(d), (double)0.0);
            Assert.assertEquals((String)msg, (double)e0, (double)rounder.round(d0), (double)0.0);
        }
    }

    @Test
    public void nanTest() {
        Stream.of(Maths::round1, Maths::round1up, Maths::round2, Maths::round2up, Maths::round3, Maths::round3up, Maths::round4, Maths::round4up, Maths::round5, Maths::round5up, Maths::round6, Maths::round6up, Maths::round7, Maths::round7up, Maths::round8, Maths::round8up).mapToDouble(rounder -> rounder.round(Double.NaN)).forEach(d -> Assert.assertTrue((boolean)Double.isNaN(d)));
    }

    @Test
    public void digits() {
        Assert.assertEquals((long)1L, (long)Maths.digits((long)0L));
        Assert.assertEquals((long)1L, (long)Maths.digits((long)1L));
        Assert.assertEquals((long)1L, (long)Maths.digits((long)9L));
        Assert.assertEquals((long)2L, (long)Maths.digits((long)10L));
        Assert.assertEquals((long)2L, (long)Maths.digits((long)99L));
        Assert.assertEquals((long)3L, (long)Maths.digits((long)100L));
    }

    @Test
    public void roundN() {
        Assert.assertEquals((double)1.5, (double)Maths.roundN((double)1.25, (double)0.3f), (double)0.0);
        Assert.assertEquals((double)1.0, (double)Maths.roundN((double)1.4999999, (int)0), (double)0.0);
        Assert.assertEquals((double)2.0, (double)Maths.roundN((double)1.5, (int)0), (double)0.0);
        Assert.assertEquals((double)1.0, (double)Maths.roundN((double)1.24999999, (double)0.3), (double)0.0);
        Assert.assertEquals((double)1.25, (double)Maths.roundN((double)1.24999999, (double)0.6), (double)0.0);
        Assert.assertEquals((double)1.5, (double)Maths.roundN((double)1.375, (double)0.6), (double)0.0);
        Assert.assertEquals((double)1.5, (double)Maths.roundN((double)1.624, (double)0.6), (double)0.0);
        Assert.assertEquals((double)1.0, (double)Maths.roundN((double)1.09999999999, (double)0.7), (double)0.0);
        Assert.assertEquals((double)1.2, (double)Maths.roundN((double)1.10000000001, (double)0.7), (double)0.0);
        Assert.assertEquals((double)1.2, (double)Maths.roundN((double)1.29999999999, (double)0.7), (double)0.0);
        Assert.assertEquals((double)1.4, (double)Maths.roundN((double)1.30000000001, (double)0.7), (double)0.0);
        Assert.assertEquals((double)1.1, (double)Maths.roundN((double)1.1499999900000002, (int)1), (double)0.0);
        Assert.assertEquals((double)1.2, (double)Maths.roundN((double)1.1500000000000001, (int)1), (double)0.0);
        Assert.assertEquals((double)1.11115, (double)Maths.roundN((double)1.111174999999, (double)4.3), (double)0.0);
        Assert.assertEquals((double)1.1112, (double)Maths.roundN((double)1.111175, (double)4.3), (double)0.0);
    }

    @Test
    public void ceilN() throws Exception {
        Assert.assertEquals((double)2.0, (double)Maths.ceilN((double)2.0, (int)0), (double)0.0);
        Assert.assertEquals((double)2.0, (double)Maths.ceilN((double)1.0000000051, (int)0), (double)0.0);
        Assert.assertEquals((double)1.5, (double)Maths.ceilN((double)1.5, (double)0.3f), (double)0.0);
        Assert.assertEquals((double)2.0, (double)Maths.ceilN((double)1.5000000051, (double)0.3f), (double)0.0);
        Assert.assertEquals((double)1.2, (double)Maths.ceilN((double)1.2, (int)1), (double)0.0);
        Assert.assertEquals((double)1.2, (double)Maths.ceilN((double)1.1000000051, (int)1), (double)0.0);
    }

    @Test
    public void floorN() throws Exception {
        Assert.assertEquals((double)1.0, (double)Maths.floorN((double)1.9999999949, (int)0), (double)0.0);
        Assert.assertEquals((double)2.0, (double)Maths.floorN((double)2.0, (int)0), (double)0.0);
        Assert.assertEquals((double)1.0, (double)Maths.floorN((double)1.4999999949, (double)0.3f), (double)0.0);
        Assert.assertEquals((double)1.5, (double)Maths.floorN((double)1.5, (double)0.3f), (double)0.0);
        Assert.assertEquals((double)1.1, (double)Maths.floorN((double)1.1999999949, (int)1), (double)0.0);
        Assert.assertEquals((double)1.2, (double)Maths.floorN((double)1.2, (int)1), (double)0.0);
    }

    @Test
    public void round1() throws Exception {
        Assert.assertEquals((double)1.1, (double)Maths.round1((double)1.1499999900000002), (double)0.0);
        Assert.assertEquals((double)1.2, (double)Maths.round1((double)1.1500000000000001), (double)0.0);
    }

    @Test
    public void round2() throws Exception {
        Assert.assertEquals((double)1.1, (double)Maths.round2((double)1.1049999990000001), (double)0.0);
        Assert.assertEquals((double)1.11, (double)Maths.round2((double)1.105), (double)0.0);
    }

    @Test
    public void round3() throws Exception {
        Assert.assertEquals((double)1.1, (double)Maths.round3((double)1.1004999999), (double)0.0);
        Assert.assertEquals((double)1.101, (double)Maths.round3((double)1.1005), (double)0.0);
    }

    @Test
    public void round4() throws Exception {
        Assert.assertEquals((double)1.1, (double)Maths.round4((double)1.1000499999900002), (double)0.0);
        Assert.assertEquals((double)1.1001, (double)Maths.round4((double)1.1000500000000002), (double)0.0);
    }

    @Test
    public void round5() throws Exception {
        Assert.assertEquals((double)1.1, (double)Maths.round5((double)1.100004999999), (double)0.0);
        Assert.assertEquals((double)1.10001, (double)Maths.round5((double)1.1000050000000001), (double)0.0);
    }

    @Test
    public void round6() throws Exception {
        Assert.assertEquals((double)1.1, (double)Maths.round6((double)1.1000004999999), (double)0.0);
        Assert.assertEquals((double)1.100001, (double)Maths.round6((double)1.1000005000000002), (double)0.0);
    }

    @Test
    public void round7() throws Exception {
        Assert.assertEquals((double)1.1, (double)Maths.round7((double)1.10000004999999), (double)0.0);
        Assert.assertEquals((double)1.1000001, (double)Maths.round7((double)1.10000005), (double)0.0);
    }

    @Test
    public void round8() throws Exception {
        Assert.assertEquals((double)1.0, (double)Maths.round8((double)1.0), (double)0.0);
        Assert.assertEquals((double)1.1, (double)Maths.round8((double)1.1000000049999992), (double)0.0);
        Assert.assertEquals((double)1.10000001, (double)Maths.round8((double)1.100000005), (double)0.0);
        Assert.assertEquals((double)9.223372036854776E18, (double)Maths.round8((double)9.223372036854776E18), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)Maths.round8((double)Double.NaN), (double)0.0);
    }

    @Test
    public void floorNX() {
        Assert.assertEquals((double)1.14563, (double)Maths.floorN((double)1.14563, (int)5), (double)0.0);
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Test
    public void testIntLog2() throws IllegalArgumentException {
        for (int i = 0; i < 63; ++i) {
            long l = 1L << i;
            Assert.assertEquals((long)i, (long)Maths.intLog2((long)l));
            if (i <= 0) continue;
            Assert.assertEquals((long)(i - 1), (long)Maths.intLog2((long)(l - 1L)));
        }
        Assert.assertEquals((long)62L, (long)Maths.intLog2((long)Long.MAX_VALUE));
        try {
            Assert.assertEquals((long)0L, (long)Maths.intLog2((long)0L));
            throw new AssertionError((Object)"expected IllegalArgumentException Math.intLong2(0)");
        }
        catch (IllegalArgumentException i) {
            for (int i2 = 0; i2 < 64; ++i2) {
                try {
                    long l = -1L << i2;
                    Maths.intLog2((long)l);
                    throw new AssertionError((Object)("expected IllegalArgumentException Math.intLong2 " + l));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
            }
            return;
        }
    }

    @Test
    public void testRounding() {
        @NotNull Random rand = new Random(1L);
        for (int i = 0; i < 1000; ++i) {
            double d = Math.pow(1.0E18, rand.nextDouble()) / 1000000.0;
            @NotNull BigDecimal bd = new BigDecimal(d);
            Assert.assertEquals((double)bd.setScale(2, 4).doubleValue(), (double)Maths.round2((double)d), (double)0.05);
            Assert.assertEquals((double)bd.setScale(4, 4).doubleValue(), (double)Maths.round4((double)d), (double)5.0E-4);
            Assert.assertEquals((double)bd.setScale(6, 4).doubleValue(), (double)Maths.round6((double)d), (double)5.0E-6);
            if (!(d < 1.0E8)) continue;
            Assert.assertEquals((double)bd.setScale(8, 4).doubleValue(), (double)Maths.round8((double)d), (double)5.0E-8);
        }
    }

    @Test
    @Ignore(value="Long running")
    public void longRunningRound() {
        @NotNull double[] ds = new double[17];
        ds[0] = 1.0E-4;
        for (int i = 1; i < ds.length; ++i) {
            ds[i] = 2.0 * ds[i - 1];
        }
        DoubleStream.of(ds).parallel().forEach(x -> {
            for (double d = x; d <= 2.0 * x && d < 10.0; d += Math.ulp(d)) {
                if (Double.toString(Maths.round4((double)d)).length() <= 6) continue;
                Assert.fail((String)("d: " + d));
            }
        });
    }

    @Test
    public void testDivideRoundUp() {
        Assert.assertEquals((long)2L, (long)Maths.divideRoundUp((long)10L, (long)5L));
        Assert.assertEquals((long)3L, (long)Maths.divideRoundUp((long)11L, (long)5L));
        Assert.assertEquals((long)-2L, (long)Maths.divideRoundUp((long)-10L, (long)5L));
        Assert.assertEquals((long)-2L, (long)Maths.divideRoundUp((long)10L, (long)-5L));
        Assert.assertEquals((long)2L, (long)Maths.divideRoundUp((long)-10L, (long)-5L));
        Assert.assertEquals((long)-3L, (long)Maths.divideRoundUp((long)-11L, (long)5L));
        Assert.assertEquals((long)-3L, (long)Maths.divideRoundUp((long)11L, (long)-5L));
        Assert.assertEquals((long)3L, (long)Maths.divideRoundUp((long)-11L, (long)-5L));
    }

    @Test
    public void sameFloating() {
        Assert.assertTrue((boolean)Maths.same((double)1.0, (double)1.0));
        Assert.assertTrue((boolean)Maths.same((float)1.0f, (float)1.0f));
        Assert.assertTrue((boolean)Maths.same((double)0.0, (double)-0.0));
        Assert.assertTrue((boolean)Maths.same((float)0.0f, (float)-0.0f));
        Assert.assertTrue((boolean)Maths.same((double)-0.0, (double)0.0));
        Assert.assertTrue((boolean)Maths.same((float)-0.0f, (float)0.0f));
        Assert.assertTrue((boolean)Maths.same((double)Double.NaN, (double)Double.NaN));
        Assert.assertTrue((boolean)Maths.same((float)Float.NaN, (float)Float.NaN));
        Assert.assertFalse((boolean)Maths.same((double)1.0, (double)2.0));
        Assert.assertFalse((boolean)Maths.same((float)1.0f, (float)2.0f));
        Assert.assertFalse((boolean)Maths.same((double)3.0, (double)2.0));
        Assert.assertFalse((boolean)Maths.same((float)3.0f, (float)2.0f));
        Assert.assertFalse((boolean)Maths.same((double)1.0, (double)Double.NaN));
        Assert.assertFalse((boolean)Maths.same((float)1.0f, (float)Float.NaN));
        Assert.assertFalse((boolean)Maths.same((double)Double.NaN, (double)1.0));
        Assert.assertFalse((boolean)Maths.same((float)Float.NaN, (float)1.0f));
    }

    @Test
    public void testHashStringBuilderFromInterner() throws Exception {
        @NotNull StringInterner interner = new StringInterner(16);
        @NotNull String csToHash = "557";
        @NotNull StringBuilder sb = new StringBuilder((CharSequence)csToHash);
        long hash = Maths.hash64((StringBuilder)sb);
        @Nullable String intern = interner.intern((CharSequence)csToHash);
        StringUtils.set((StringBuilder)sb, (CharSequence)intern);
        long actual = Maths.hash64((StringBuilder)sb);
        Assert.assertEquals((long)hash, (long)actual);
        StringUtils.set((StringBuilder)sb, (CharSequence)"xxxx");
        @Nullable String intern2 = interner.intern((CharSequence)csToHash);
        StringUtils.set((StringBuilder)sb, (CharSequence)intern2);
        long actual2 = Maths.hash64((StringBuilder)sb);
        Assert.assertEquals((long)hash, (long)actual2);
    }

    @Test
    public void testHash64ForString() throws Exception {
        String e1 = "";
        long eh1 = Maths.hash64((String)e1);
        Assert.assertEquals((long)0L, (long)eh1);
        String a1 = "Test";
        long ah1 = Maths.hash64((String)a1);
        String a2 = "T" + "e" + "st";
        long ah2 = Maths.hash64((String)a2);
        Assert.assertEquals((long)ah1, (long)ah2);
        String u1 = "\u20ac";
        long uh1 = Maths.hash64((String)u1);
        if (Jvm.isJava9Plus()) {
            Assert.assertEquals((long)-11958288497246124L, (long)uh1);
        } else {
            Assert.assertEquals((long)1177128352603971756L, (long)uh1);
        }
        String u2 = "\u20ac\u20ac".substring(0, 1);
        long uh2 = Maths.hash64((String)u2);
        Assert.assertEquals((long)uh1, (long)uh2);
        StringBuilder mixedSb = new StringBuilder().append("\u20ac");
        mixedSb.setLength(0);
        mixedSb.append("X");
        Assert.assertEquals((long)Maths.hash64((String)"X"), (long)Maths.hash64((String)mixedSb.toString()));
        Assert.assertNotEquals((long)Maths.hash64((String)"\u0394"), (long)Maths.hash64((String)"\u0393"));
    }

    @Test
    public void floorNceilN() {
        double d = 64.0915946999999;
        BigDecimal bd = BigDecimal.valueOf(d);
        for (int i = 0; i < 19; ++i) {
            double ceil0 = bd.setScale(i, RoundingMode.CEILING).doubleValue();
            double floor0 = bd.setScale(i, RoundingMode.FLOOR).doubleValue();
            double ceil = Maths.ceilN((double)d, (int)i);
            double floor = Maths.floorN((double)d, (int)i);
            Assert.assertEquals((String)("i: " + i), (double)ceil0, (double)ceil, (double)0.0);
            Assert.assertEquals((String)("i: " + i), (double)floor0, (double)floor, (double)0.0);
        }
    }

    @FunctionalInterface
    public static interface Rounder {
        public double round(double var1);
    }
}

