/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.util.MisAlignedAssertionError;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnsafeMemoryTest {
    private static final float EPSILON = 1.0E-7f;
    private static final byte BYTE_VAL = 127;
    private static final short SHORT_VAL = Short.MAX_VALUE;
    private static final int INT_VAL = 305419896;
    private static final long LONG_VAL = Long.MAX_VALUE;
    private static final float FLOAT_VAL = 1.0f;
    private static final double DOUBLE_VAL = 1.0;
    private final UnsafeMemory memory;
    private Boolean onHeap;
    private Object object;
    private long addr;

    public UnsafeMemoryTest(String name, UnsafeMemory memory, Boolean onHeap) {
        this.memory = memory;
        this.onHeap = onHeap;
        if (Boolean.TRUE.equals(onHeap)) {
            this.object = new byte[128];
            this.addr = UnsafeMemory.MEMORY.arrayBaseOffset(byte[].class);
        } else {
            this.object = null;
            this.addr = UnsafeMemory.UNSAFE.allocateMemory(128L);
        }
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        UnsafeMemory memory1 = new UnsafeMemory();
        UnsafeMemory.ARMMemory memory2 = new UnsafeMemory.ARMMemory();
        Object[][] intel = new Object[][]{{"UnsafeMemory offheap", memory1, false}, {"UnsafeMemory onheap", memory1, true}, {"UnsafeMemory offheap (null)", memory1, null}};
        Object[][] arm = new Object[][]{{"ARMMemory offheap", memory2, false}, {"ARMMemory onheap", memory2, true}, {"ARMMemory offheap (null)", memory2, null}};
        ArrayList all = new ArrayList();
        Collections.addAll(all, intel);
        Collections.addAll(all, arm);
        return Jvm.isArm() ? Arrays.asList(arm) : all;
    }

    @After
    public void tearDown() {
        if (this.object == null) {
            UnsafeMemory.UNSAFE.freeMemory(this.addr);
        }
    }

    @Test
    public void writeShort() {
        for (int i = 0; i <= 64; ++i) {
            if (this.onHeap == null) {
                this.memory.writeShort(this.addr + (long)i, (short)-21555);
                Assert.assertEquals((long)-21555L, (long)this.memory.readShort(this.addr + (long)i));
                continue;
            }
            this.memory.writeShort(this.object, this.addr + (long)i, (short)-21555);
            Assert.assertEquals((long)-21555L, (long)this.memory.readShort(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void readShort() {
        if (this.onHeap == null) {
            this.memory.writeLong(this.addr, 81985529216486895L);
            Assert.assertEquals((long)-12817L, (long)this.memory.readShort(this.addr));
            Assert.assertEquals((long)-21555L, (long)this.memory.readShort(this.addr + 1L));
        } else {
            this.memory.writeLong(this.object, this.addr, 81985529216486895L);
            Assert.assertEquals((long)-12817L, (long)this.memory.readShort(this.object, this.addr));
            Assert.assertEquals((long)-21555L, (long)this.memory.readShort(this.object, this.addr + 1L));
        }
    }

    @Test
    public void readWriteInt() {
        for (int i = 0; i <= 64; ++i) {
            if (this.onHeap == null) {
                this.memory.writeInt(this.addr + (long)i, 305419896);
                Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.addr + (long)i));
                continue;
            }
            this.memory.writeInt(this.object, this.addr + (long)i, 305419896);
            Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void writeOrderedInt() {
        for (int i = 0; i <= 64; ++i) {
            if (this.onHeap == null) {
                this.memory.writeOrderedInt(this.addr + (long)i, 305419896);
                Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.addr + (long)i));
                continue;
            }
            this.memory.writeOrderedInt(this.object, this.addr + (long)i, 305419896);
            Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void readWriteLong() {
        for (int i = 0; i <= 64; ++i) {
            if (this.onHeap == null) {
                this.memory.writeLong(this.addr + (long)i, Long.MAX_VALUE);
                Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.addr + (long)i));
                continue;
            }
            this.memory.writeLong(this.object, this.addr + (long)i, Long.MAX_VALUE);
            Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void readWriteFloat() {
        for (int i = 0; i <= 64; ++i) {
            if (this.onHeap == null) {
                this.memory.writeFloat(this.addr + (long)i, 1.0f);
                Assert.assertEquals((float)1.0f, (float)this.memory.readFloat(this.addr + (long)i), (float)1.0E-7f);
                continue;
            }
            this.memory.writeFloat(this.object, this.addr + (long)i, 1.0f);
            Assert.assertEquals((float)1.0f, (float)this.memory.readFloat(this.object, this.addr + (long)i), (float)1.0E-7f);
        }
    }

    @Test
    public void readWriteDouble() {
        for (int i = 0; i <= 64; ++i) {
            if (this.onHeap == null) {
                this.memory.writeDouble(this.addr + (long)i, 1.0);
                Assert.assertEquals((double)1.0, (double)this.memory.readDouble(this.addr + (long)i), (double)1.0E-7f);
                continue;
            }
            this.memory.writeDouble(this.object, this.addr + (long)i, 1.0);
            Assert.assertEquals((double)1.0, (double)this.memory.readDouble(this.object, this.addr + (long)i), (double)1.0E-7f);
        }
    }

    @Test
    public void writeOrderedLong() {
        for (int i = 0; i <= 64; i += 8) {
            if (this.onHeap == null) {
                this.memory.writeOrderedLong(this.addr + (long)i, Long.MAX_VALUE);
                Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.addr + (long)i));
                continue;
            }
            this.memory.writeOrderedLong(this.object, this.addr + (long)i, Long.MAX_VALUE);
            Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void compareAndSwapInt() throws MisAlignedAssertionError {
        for (int i = 0; i <= 64; i += 4) {
            try {
                boolean actual;
                if (this.onHeap == null) {
                    this.memory.writeInt(this.addr + (long)i, 0);
                    actual = this.memory.compareAndSwapInt(this.addr + (long)i, 0, 305419896);
                    Assert.assertTrue((boolean)actual);
                    Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.addr + (long)i));
                    continue;
                }
                this.memory.writeInt(this.object, this.addr + (long)i, 0);
                actual = this.memory.compareAndSwapInt(this.object, this.addr + (long)i, 0, 305419896);
                Assert.assertTrue((boolean)actual);
                Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.object, this.addr + (long)i));
                continue;
            }
            catch (MisAlignedAssertionError e) {
                if (!this.memory.safeAlignedInt(this.addr + (long)i)) continue;
                throw e;
            }
        }
    }

    @Test
    public void compareAndSwapLong() throws MisAlignedAssertionError {
        for (int i = 0; i <= 64; i += 8) {
            try {
                boolean actual;
                if (this.onHeap == null) {
                    this.memory.writeLong(this.addr + (long)i, 0L);
                    actual = this.memory.compareAndSwapLong(this.addr + (long)i, 0L, Long.MAX_VALUE);
                    Assert.assertTrue((boolean)actual);
                    Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.addr + (long)i));
                    continue;
                }
                this.memory.writeLong(this.object, this.addr + (long)i, 0L);
                actual = this.memory.compareAndSwapLong(this.object, this.addr + (long)i, 0L, Long.MAX_VALUE);
                Assert.assertTrue((boolean)actual);
                Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.object, this.addr + (long)i));
                continue;
            }
            catch (MisAlignedAssertionError e) {
                if (!this.memory.safeAlignedLong(this.addr + (long)i)) continue;
                throw e;
            }
        }
    }

    @Test
    public void readVolatileByte() {
        for (int i = 0; i <= 64; ++i) {
            byte actual;
            if (this.onHeap == null) {
                this.memory.writeByte(this.addr + (long)i, (byte)127);
                actual = this.memory.readVolatileByte(this.addr + (long)i);
                Assert.assertEquals((long)127L, (long)actual);
                continue;
            }
            this.memory.writeByte(this.object, this.addr + (long)i, (byte)127);
            actual = this.memory.readVolatileByte(this.object, this.addr + (long)i);
            Assert.assertEquals((long)127L, (long)actual);
        }
    }

    @Test
    public void readVolatileShort() {
        for (int i = 0; i <= 64; i += 2) {
            short actual;
            if (this.onHeap == null) {
                this.memory.writeShort(this.addr + (long)i, (short)Short.MAX_VALUE);
                actual = this.memory.readVolatileShort(this.addr + (long)i);
                Assert.assertEquals((long)32767L, (long)actual);
                continue;
            }
            this.memory.writeShort(this.object, this.addr + (long)i, (short)Short.MAX_VALUE);
            actual = this.memory.readVolatileShort(this.object, this.addr + (long)i);
            Assert.assertEquals((long)32767L, (long)actual);
        }
    }

    @Test
    public void readVolatileInt() {
        for (int i = 0; i <= 64; i += 4) {
            int actual;
            if (this.onHeap == null) {
                this.memory.writeInt(this.addr + (long)i, 305419896);
                actual = this.memory.readVolatileInt(this.addr + (long)i);
                Assert.assertEquals((long)305419896L, (long)actual);
                continue;
            }
            this.memory.writeInt(this.object, this.addr + (long)i, 305419896);
            actual = this.memory.readVolatileInt(this.object, this.addr + (long)i);
            Assert.assertEquals((long)305419896L, (long)actual);
        }
    }

    @Test
    public void readVolatileFloat() {
        for (int i = 0; i <= 64; i += 4) {
            float actual;
            if (this.onHeap == null) {
                this.memory.writeFloat(this.addr + (long)i, 1.0f);
                actual = this.memory.readVolatileFloat(this.addr + (long)i);
                Assert.assertEquals((float)1.0f, (float)actual, (float)1.0E-7f);
                continue;
            }
            this.memory.writeFloat(this.object, this.addr + (long)i, 1.0f);
            actual = this.memory.readVolatileFloat(this.object, this.addr + (long)i);
            Assert.assertEquals((float)1.0f, (float)actual, (float)1.0E-7f);
        }
    }

    @Test
    public void readVolatileLong() {
        for (int i = 0; i <= 64; i += 8) {
            long actual;
            if (this.onHeap == null) {
                this.memory.writeLong(this.addr + (long)i, Long.MAX_VALUE);
                actual = this.memory.readVolatileLong(this.addr + (long)i);
                Assert.assertEquals((long)Long.MAX_VALUE, (long)actual);
                continue;
            }
            this.memory.writeLong(this.object, this.addr + (long)i, Long.MAX_VALUE);
            actual = this.memory.readVolatileLong(this.object, this.addr + (long)i);
            Assert.assertEquals((long)Long.MAX_VALUE, (long)actual);
        }
    }

    @Test
    public void readVolatileDouble() {
        for (int i = 0; i <= 64; i += 8) {
            double actual;
            if (this.onHeap == null) {
                this.memory.writeDouble(this.addr + (long)i, 1.0);
                actual = this.memory.readVolatileDouble(this.addr + (long)i);
                Assert.assertEquals((double)1.0, (double)actual, (double)1.0E-7f);
                continue;
            }
            this.memory.writeDouble(this.object, this.addr + (long)i, 1.0);
            actual = this.memory.readVolatileDouble(this.object, this.addr + (long)i);
            Assert.assertEquals((double)1.0, (double)actual, (double)1.0E-7f);
        }
    }

    @Test
    public void writeVolatileByte() {
        for (int i = 0; i <= 64; ++i) {
            if (this.onHeap == null) {
                this.memory.writeVolatileByte(this.addr + (long)i, (byte)127);
                Assert.assertEquals((long)127L, (long)this.memory.readByte(this.addr + (long)i));
                continue;
            }
            this.memory.writeVolatileByte(this.object, this.addr + (long)i, (byte)127);
            Assert.assertEquals((long)127L, (long)this.memory.readByte(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void writeVolatileShort() {
        for (int i = 0; i <= 64; i += 2) {
            if (this.onHeap == null) {
                this.memory.writeVolatileShort(this.addr + (long)i, (short)Short.MAX_VALUE);
                Assert.assertEquals((long)32767L, (long)this.memory.readShort(this.addr + (long)i));
                continue;
            }
            this.memory.writeVolatileShort(this.object, this.addr + (long)i, (short)Short.MAX_VALUE);
            Assert.assertEquals((long)32767L, (long)this.memory.readShort(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void writeVolatileInt() {
        for (int i = 0; i <= 64; i += 4) {
            if (this.onHeap == null) {
                this.memory.writeVolatileInt(this.addr + (long)i, 305419896);
                Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.addr + (long)i));
                continue;
            }
            this.memory.writeVolatileInt(this.object, this.addr + (long)i, 305419896);
            Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void writeVolatileFloat() {
        for (int i = 0; i <= 64; i += 4) {
            if (this.onHeap == null) {
                this.memory.writeVolatileFloat(this.addr + (long)i, 1.0f);
                Assert.assertEquals((float)1.0f, (float)this.memory.readFloat(this.addr + (long)i), (float)1.0E-7f);
                continue;
            }
            this.memory.writeVolatileFloat(this.object, this.addr + (long)i, 1.0f);
            Assert.assertEquals((float)1.0f, (float)this.memory.readFloat(this.object, this.addr + (long)i), (float)1.0E-7f);
        }
    }

    @Test
    public void writeVolatileLong() {
        for (int i = 0; i <= 64; i += 8) {
            if (this.onHeap == null) {
                this.memory.writeVolatileLong(this.addr + (long)i, Long.MAX_VALUE);
                Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.addr + (long)i));
                continue;
            }
            this.memory.writeVolatileLong(this.object, this.addr + (long)i, Long.MAX_VALUE);
            Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.object, this.addr + (long)i));
        }
    }

    @Test
    public void writeVolatileDouble() {
        for (int i = 0; i <= 64; i += 8) {
            if (this.onHeap == null) {
                this.memory.writeVolatileDouble(this.addr + (long)i, 1.0);
                Assert.assertEquals((double)1.0, (double)this.memory.readDouble(this.addr + (long)i), (double)1.0E-7f);
                continue;
            }
            this.memory.writeVolatileDouble(this.object, this.addr + (long)i, 1.0);
            Assert.assertEquals((double)1.0, (double)this.memory.readDouble(this.object, this.addr + (long)i), (double)1.0E-7f);
        }
    }

    @Test
    public void addInt() throws MisAlignedAssertionError {
        for (int i = 0; i <= 64; i += 4) {
            try {
                int actual;
                if (this.onHeap == null) {
                    this.memory.writeInt(this.addr + (long)i, 0);
                    actual = this.memory.addInt(this.addr + (long)i, 305419896);
                    Assert.assertEquals((long)305419896L, (long)actual);
                    Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.addr + (long)i));
                    continue;
                }
                this.memory.writeInt(this.object, this.addr + (long)i, 0);
                actual = this.memory.addInt(this.object, this.addr + (long)i, 305419896);
                Assert.assertEquals((long)305419896L, (long)actual);
                Assert.assertEquals((long)305419896L, (long)this.memory.readInt(this.object, this.addr + (long)i));
                continue;
            }
            catch (MisAlignedAssertionError e) {
                if (!this.memory.safeAlignedInt(this.addr + (long)i)) continue;
                throw e;
            }
        }
    }

    @Test
    public void addLong() throws MisAlignedAssertionError {
        for (int i = 0; i <= 64; i += 8) {
            try {
                long actual;
                if (this.onHeap == null) {
                    this.memory.writeLong(this.addr + (long)i, 0L);
                    actual = this.memory.addLong(this.addr + (long)i, Long.MAX_VALUE);
                    Assert.assertEquals((long)Long.MAX_VALUE, (long)actual);
                    Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.addr + (long)i));
                    continue;
                }
                this.memory.writeLong(this.object, this.addr + (long)i, 0L);
                actual = this.memory.addLong(this.object, this.addr + (long)i, Long.MAX_VALUE);
                Assert.assertEquals((long)Long.MAX_VALUE, (long)actual);
                Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(this.object, this.addr + (long)i));
                continue;
            }
            catch (MisAlignedAssertionError e) {
                if (!this.memory.safeAlignedLong(this.addr + (long)i)) continue;
                throw e;
            }
        }
    }
}

