/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.analytics;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.analytics.AnalyticsFacade;
import net.openhft.chronicle.core.internal.analytics.MuteAnalytics;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AnalyticsFacadeTest {
    private static final String TEST_RESPONSE = "A";

    @Before
    public void setSystemProp() {
        System.clearProperty("chronicle.analytics.disable");
    }

    @Test
    public void systemProp() {
        System.setProperty("chronicle.analytics.disable", "true");
        AnalyticsFacade facade = AnalyticsFacade.builder((String)"measurementId", (String)"apiSecret").withReportDespiteJUnit().build();
        Assert.assertTrue((boolean)(facade instanceof MuteAnalytics));
    }

    @Test
    public void analytics() {
        AnalyticsFacade.Builder builder = AnalyticsFacade.builder((String)"measurementId", (String)"apiSecret").putEventParameter("e", "1").putUserProperty("u", "2").withClientIdFileName("file_name").withDebugLogger(System.out::println).withErrorLogger(System.err::println).withUrl("url").withFrequencyLimit(1, 1L, TimeUnit.SECONDS);
        AnalyticsFacade analyticsFacade = builder.build();
        Assert.assertFalse((boolean)(analyticsFacade instanceof MuteAnalytics));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void analyticsWithRealWebServer() throws IOException {
        String clientIdFileName = "client_id_file_name.txt";
        AnalyticsFacade dummyFacade = AnalyticsFacade.builder((String)"measurementId", (String)"apiSecret").withClientIdFileName("client_id_file_name.txt").build();
        CopyOnWriteArrayList debugResponses = new CopyOnWriteArrayList();
        CopyOnWriteArrayList errorResponses = new CopyOnWriteArrayList();
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setBody(TEST_RESPONSE));
        server.start();
        try {
            HttpUrl url = server.url("mp/collect");
            AnalyticsFacade.Builder builder = AnalyticsFacade.builder((String)"measurementId", (String)"apiSecret").putEventParameter("e", "1").putUserProperty("u", "2").withClientIdFileName("client_id_file_name.txt").withDebugLogger(debugResponses::add).withErrorLogger(errorResponses::add).withUrl(url.url().toString()).withReportDespiteJUnit().withFrequencyLimit(1, 1L, TimeUnit.SECONDS);
            AnalyticsFacade analyticsFacade = builder.build();
            analyticsFacade.sendEvent("test");
            while (debugResponses.stream().noneMatch(TEST_RESPONSE::equals)) {
            }
            Assert.assertTrue((boolean)errorResponses.isEmpty());
            Assert.assertTrue((boolean)debugResponses.stream().anyMatch(TEST_RESPONSE::equals));
        }
        finally {
            server.shutdown();
            new File("client_id_file_name.txt").delete();
        }
    }
}

