/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class AbstractReferenceCountedTest
extends CoreTestCommon {
    @Test
    public void reserve() throws IllegalStateException, IllegalArgumentException {
        Assume.assumeTrue((boolean)Jvm.isResourceTracing());
        MyReferenceCounted rc = new MyReferenceCounted();
        Assert.assertEquals((long)1L, (long)rc.refCount());
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        rc.reserve(a);
        Assert.assertEquals((long)2L, (long)rc.refCount());
        ReferenceOwner b = ReferenceOwner.temporary((String)"b");
        rc.reserve(b);
        Assert.assertEquals((long)3L, (long)rc.refCount());
        try {
            rc.reserve(a);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)rc.refCount());
        rc.release(b);
        Assert.assertEquals((long)2L, (long)rc.refCount());
        rc.release(a);
        Assert.assertEquals((long)1L, (long)rc.refCount());
        Assert.assertEquals((long)0L, (long)rc.performRelease);
        rc.releaseLast();
        Assert.assertEquals((long)0L, (long)rc.refCount());
        Assert.assertEquals((long)1L, (long)rc.performRelease);
    }

    static class MyReferenceCounted
    extends AbstractReferenceCounted {
        int performRelease;

        protected void performRelease() {
            ++this.performRelease;
        }
    }
}

