/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.stream.IntStream;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.cleaner.impl.CleanerTestUtil;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Time;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class IOToolsTest
extends CoreTestCommon {
    @Test
    public void readFileManyTimesByPath() {
        int iterations = 10000;
        LongAccumulator accumulator = new LongAccumulator(Long::sum, 0L);
        IntStream.range(0, 10000).parallel().forEach(i -> {
            try {
                IOTools.readFile(IOToolsTest.class, (String)"readFileManyTimes.txt");
                accumulator.accumulate(1L);
            }
            catch (IOException ioe) {
                Jvm.rethrow((Throwable)ioe);
            }
        });
        Assert.assertEquals((long)10000L, (long)accumulator.get());
    }

    @Test
    public void readFileManyTimesByFile() throws IOException {
        int iterations = 10000;
        LongAccumulator accumulator = new LongAccumulator(Long::sum, 0L);
        String file = OS.getTarget() + "/readFileManyTimes.txt";
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write("Delete me\n".getBytes(StandardCharsets.UTF_8));
        }
        IntStream.range(0, 10000).parallel().forEach(i -> {
            try {
                IOTools.readFile(IOToolsTest.class, (String)file);
                accumulator.accumulate(1L);
            }
            catch (IOException ioe) {
                Jvm.rethrow((Throwable)ioe);
            }
        });
        Assert.assertEquals((long)10000L, (long)accumulator.get());
    }

    @Test
    public void shouldCleanDirectBuffer() {
        CleanerTestUtil.test(IOTools::clean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createDirectoriesWithBrokenLink() throws IOException, IllegalStateException {
        Assume.assumeTrue((boolean)OS.isLinux());
        String path = OS.getTarget();
        Path link = Paths.get(path, "link2nowhere" + Time.uniqueId());
        Path nowhere = Paths.get(path, "nowhere");
        if (Files.isSymbolicLink(link)) {
            Files.delete(link);
            if (Files.isSymbolicLink(link)) {
                throw new IllegalStateException("Still exists");
            }
        }
        Files.createSymbolicLink(link, nowhere, new FileAttribute[0]);
        try {
            IOTools.createDirectories((Path)Paths.get(link.toString(), "subdir" + Time.uniqueId()));
            Assert.fail();
        }
        catch (IOException ioe) {
            Assert.assertSame(IOException.class, ioe.getClass());
            Assert.assertTrue((boolean)ioe.getMessage().startsWith("Symbolic link from "));
            Assert.assertTrue((boolean)ioe.getMessage().endsWith("nowhere is broken"));
        }
        finally {
            Files.delete(link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createDirectoriesReadOnly() throws IOException, IllegalStateException {
        Assume.assumeTrue((boolean)OS.isLinux());
        String path = OS.getTarget();
        Path ro = Paths.get(path, "read-only" + Time.uniqueId());
        IOTools.createDirectories((Path)ro);
        if (!ro.toFile().setWritable(false)) {
            throw new IllegalStateException("Cannot make read-only");
        }
        Assert.assertFalse((boolean)ro.toFile().canWrite());
        try {
            IOTools.createDirectories((Path)Paths.get(ro.toString(), "subdir" + Time.uniqueId()));
        }
        catch (IOException ioe) {
            Assert.assertSame(IOException.class, ioe.getClass());
            Assert.assertTrue((boolean)ioe.getMessage().startsWith("Cannot write to "));
        }
        finally {
            if (!ro.toFile().setWritable(true)) {
                throw new IllegalStateException("Cannot make read-write");
            }
            Files.delete(ro);
        }
    }

    @Test
    public void cannotTurnAfileIntoADirectory() throws IOException {
        Assume.assumeTrue((boolean)OS.isLinux());
        String path = OS.getTarget();
        Path file = Paths.get(path, "test-file" + Time.uniqueId());
        file.toFile().delete();
        file.toFile().deleteOnExit();
        Assert.assertTrue((boolean)file.toFile().createNewFile());
        try {
            IOTools.createDirectories((Path)Paths.get(file.toString(), "subdir" + Time.uniqueId()));
        }
        catch (IOException ioe) {
            Assert.assertSame(IOException.class, ioe.getClass());
            Assert.assertTrue((boolean)ioe.getMessage().startsWith("Cannot create a directory with the same name as a file "));
        }
    }

    @Test
    public void isDirectBuffer() {
        Assert.assertTrue((boolean)IOTools.isDirectBuffer((ByteBuffer)ByteBuffer.allocateDirect(1)));
        Assert.assertFalse((boolean)IOTools.isDirectBuffer((ByteBuffer)ByteBuffer.allocate(1)));
    }

    @Test
    public void addressFor() {
        Assert.assertNotEquals((long)0L, (long)IOTools.addressFor((ByteBuffer)ByteBuffer.allocateDirect(1)));
    }

    @Test
    public void addressFor2() {
        ByteBuffer bb = ByteBuffer.allocate(1);
        try {
            IOTools.addressFor((ByteBuffer)bb);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void normaliseIOStatus() {
        int actual = -3;
        Assert.assertEquals((long)-3L, (long)-3L);
        Assert.assertEquals((long)-3L, (long)IOTools.normaliseIOStatus((int)-3));
    }
}

