/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import java.util.Arrays;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.DynamicEnumClass;
import net.openhft.chronicle.core.pool.EcnDynamic;
import net.openhft.chronicle.core.pool.EnumCache;
import net.openhft.chronicle.core.pool.YesNo;
import org.junit.Assert;
import org.junit.Test;

public class DynamicEnumPooledClassTest {
    @Test
    public void additionalEnum() {
        EnumCache yesNoEnumCache = EnumCache.of(YesNo.class);
        Assert.assertEquals((Object)((Object)YesNo.Yes), (Object)yesNoEnumCache.valueOf("Yes"));
        Assert.assertEquals((Object)((Object)YesNo.No), (Object)yesNoEnumCache.valueOf("No"));
        Assert.assertEquals((Object)"[Yes, No]", (Object)Arrays.toString(yesNoEnumCache.asArray()));
        YesNo maybe = (YesNo)((Object)yesNoEnumCache.valueOf("Maybe"));
        Assert.assertEquals((Object)"Maybe", (Object)maybe.name());
        Assert.assertEquals((long)2L, (long)maybe.ordinal());
        Assert.assertEquals((Object)"[Yes, No, Maybe]", (Object)Arrays.toString(yesNoEnumCache.asArray()));
        YesNo unknown = (YesNo)((Object)yesNoEnumCache.valueOf("Unknown"));
        Assert.assertEquals((Object)"Unknown", (Object)unknown.name());
        Assert.assertEquals((long)3L, (long)unknown.ordinal());
        Assert.assertEquals((Object)"[Yes, No, Maybe, Unknown]", (Object)Arrays.toString(yesNoEnumCache.asArray()));
        for (YesNo yesNo : (YesNo[])yesNoEnumCache.asArray()) {
            Assert.assertEquals((Object)yesNo.name(), (Object)yesNo.toString());
        }
        DynamicEnumClass dynamicEnumClass = (DynamicEnumClass)yesNoEnumCache;
        dynamicEnumClass.reset();
        Assert.assertEquals((Object)"[Yes, No]", (Object)Arrays.toString(yesNoEnumCache.asArray()));
    }

    @Test
    public void testInitialSize() throws IllegalArgumentException {
        EnumCache ecnEnumCache = EnumCache.of(EcnDynamic.class);
        Assert.assertEquals((long)32L, (long)Maths.nextPower2((int)ecnEnumCache.size(), (int)1));
    }
}

