/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import java.util.stream.Stream;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.EnumInterner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class EnumInternerTest {
    static final int MASK = 63;

    public static void main(String[] args) {
        for (int i = 0; i < 100000; ++i) {
            int h;
            String s = Long.toString(i, 36);
            if (!Character.isJavaIdentifierStart(s.charAt(0)) || (h = Maths.hash32((String)s) & 0x3F) != 0) continue;
            System.out.println(s + ",");
        }
    }

    @Test
    public void clashTest() {
        for (TestEnum value : TestEnum.values()) {
            Assertions.assertEquals((int)0, (int)(Maths.hash32((String)value.toString()) & 0x3F));
        }
        EnumInterner testEnum = new EnumInterner(TestEnum.class);
        ((Stream)Stream.of(TestEnum.values()).parallel()).forEach(te -> {
            String cs = te.toString();
            for (int i = 0; i < 20000; ++i) {
                TestEnum interned = (TestEnum)testEnum.intern((CharSequence)cs);
                Assert.assertEquals((String)("i: " + i), (Object)((Object)interned), (Object)te);
            }
        });
    }

    static enum TestEnum {
        c1,
        cq,
        db,
        ho,
        id,
        k6,
        kv,
        la,
        m5,
        mu,
        nb,
        qg,
        s8,
        sx,
        uz,
        va,
        yj;

    }
}

