/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import net.openhft.chronicle.core.time.LongTime;
import org.junit.Assert;
import org.junit.Test;

public class LongTimeTest {
    @Test
    public void secs() {
        long epoch = 0L;
        Assert.assertTrue((boolean)LongTime.isSecs((long)epoch));
        Assert.assertTrue((boolean)LongTime.isSecs((long)9223372036L));
        Assert.assertFalse((boolean)LongTime.isSecs((long)9223372037L));
        Assert.assertTrue((boolean)LongTime.isSecs((long)0x8CBCCCL));
        Assert.assertEquals((long)epoch, (long)LongTime.toSecs((long)LongTime.toSecs((long)epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toSecs((long)LongTime.toMillis((long)epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toSecs((long)LongTime.toMicros((long)epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toSecs((long)LongTime.toNanos((long)epoch)));
    }

    @Test
    public void millis() {
        long epoch = 9223372037L;
        Assert.assertTrue((boolean)LongTime.isMillis((long)epoch));
        Assert.assertTrue((boolean)LongTime.isMillis((long)9223372036854L));
        Assert.assertFalse((boolean)LongTime.isMillis((long)9223372037000L));
        Assert.assertTrue((boolean)LongTime.isMillis((long)9223372036000L));
        Assert.assertTrue((boolean)LongTime.isMillis((long)9223372037L));
        Assert.assertEquals((long)(epoch - epoch % 1000L), (long)LongTime.toMillis((long)LongTime.toSecs((long)epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toMillis((long)LongTime.toMillis((long)epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toMillis((long)LongTime.toMicros((long)epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toMillis((long)LongTime.toNanos((long)epoch)));
    }

    @Test
    public void micros() {
        long epoch = 9223372037000L;
        Assert.assertTrue((boolean)LongTime.isMicros((long)epoch));
        Assert.assertTrue((boolean)LongTime.isMicros((long)9223372036854775L));
        Assert.assertFalse((boolean)LongTime.isMicros((long)9223372037000000L));
        Assert.assertTrue((boolean)LongTime.isMicros((long)9223372036854000L));
        Assert.assertTrue((boolean)LongTime.isMicros((long)9223372037000L));
        Assert.assertEquals((long)(epoch - epoch % 1000000L), (long)LongTime.toMicros((long)LongTime.toSecs((long)epoch)));
        Assert.assertEquals((long)(epoch - epoch % 1000L), (long)LongTime.toMicros((long)LongTime.toMillis((long)epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toMicros((long)LongTime.toMicros((long)epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toMicros((long)LongTime.toNanos((long)epoch)));
    }

    @Test
    public void nanos() {
        long epoch = 9223372037000000L;
        Assert.assertTrue((boolean)LongTime.isNanos((long)epoch));
        Assert.assertTrue((boolean)LongTime.isNanos((long)Long.MAX_VALUE));
        Assert.assertTrue((boolean)LongTime.isNanos((long)9223372036854775000L));
        Assert.assertEquals((long)(epoch - epoch % 1000000000L), (long)LongTime.toNanos((long)LongTime.toSecs((long)epoch)));
        Assert.assertEquals((long)(epoch - epoch % 1000000L), (long)LongTime.toNanos((long)LongTime.toMillis((long)epoch)));
        Assert.assertEquals((long)(epoch - epoch % 1000L), (long)LongTime.toNanos((long)LongTime.toMicros((long)epoch)));
        Assert.assertEquals((long)epoch, (long)LongTime.toNanos((long)LongTime.toNanos((long)epoch)));
    }
}

