/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import net.openhft.chronicle.core.util.GenericReflection;
import net.openhft.chronicle.core.util.TypeOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GenericReflectionTest {
    GenericReflectionTest() {
    }

    @Test
    void getReturnType() {
        Assertions.assertEquals(String.class, (Object)GenericReflection.getReturnType((Method)Returns.class.getMethods()[0], ReturnsString.class));
        Assertions.assertEquals(Integer.class, (Object)GenericReflection.getReturnType((Method)Returns.class.getMethods()[0], ReturnsInteger.class));
        Assertions.assertEquals(Double.class, (Object)GenericReflection.getReturnType((Method)Returns2.class.getMethods()[0], Returns2Double.class));
        Type t = GenericReflection.getReturnType((Method)ReturnsReturnsAString.class.getMethods()[0], ReturnsReturnsAString.class);
        Assertions.assertEquals((Object)new TypeOf<Returns<String>>(){}.type(), (Object)t);
    }

    @Test
    public void getMethodReturnTypes() {
        Type returnString = new TypeOf<Returns<String>>(){}.type();
        Set methodReturnTypes = GenericReflection.getMethodReturnTypes(ReturnsString.class);
        Assertions.assertEquals((Object)methodReturnTypes, (Object)GenericReflection.getMethodReturnTypes((Type)returnString));
    }

    @Test
    public void getGenericInterfaces() {
        Type returnString = new TypeOf<Returns<String>>(){}.type();
        Object[] genericInterfaces = GenericReflection.getGenericInterfaces(ReturnsString.class);
        Assertions.assertArrayEquals((Object[])genericInterfaces, (Object[])GenericReflection.getGenericInterfaces((Type)returnString));
    }

    @Test
    public void getGenericSuperclass() {
        Type returnString = new TypeOf<Returns<String>>(){}.type();
        Type genericSuperclass = GenericReflection.getGenericSuperclass(ReturnsString.class);
        Assertions.assertEquals((Object)genericSuperclass, (Object)GenericReflection.getGenericSuperclass((Type)returnString));
    }

    class Returns2Double
    extends Returns2<Double> {
        Returns2Double() {
        }

        @Override
        public Double ret() {
            return 1.0;
        }
    }

    class Returns2<A> {
        Returns2() {
        }

        public A ret() {
            return null;
        }
    }

    class ReturnsInteger
    implements Returns<Integer> {
        ReturnsInteger() {
        }

        @Override
        public Integer ret() {
            return null;
        }
    }

    static interface ReturnsString
    extends Returns<String> {
    }

    static interface ReturnsReturnsAString {
        public Returns<String> retRS();
    }

    static interface Returns<A> {
        public A ret();
    }
}

