/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import net.openhft.chronicle.core.util.Histogram;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class HistogramTest {
    public static void main(String[] args) throws IOException, NumberFormatException {
        Histogram hist = new Histogram(32, 7);
        for (File f : new File(args[0]).listFiles()) {
            if (f.getName().endsWith(".png")) continue;
            try (BufferedReader br = new BufferedReader(new FileReader(f));){
                String line;
                while ((line = br.readLine()) != null) {
                    hist.sampleNanos(Long.parseLong(line));
                }
            }
        }
        System.out.println(hist.toLongMicrosFormat());
    }

    @Test
    public void percentilesFor() {
        Assert.assertEquals((Object)"[0.5, 0.9, 0.99, 0.997, 0.999, 0.9997, 0.9999, 0.99997, 0.99999, 0.999997, 1.0]", (Object)Arrays.toString(Histogram.percentilesFor((long)50000000L)));
    }

    @Test
    public void singleSample() {
        Histogram h = new Histogram();
        h.sampleNanos(100000L);
        Assert.assertEquals((Object)"50/90 97/99 99.7/99.9 99.97/99.99 - worst was 100.0 / 100.0  100.0 / 100.0  100.0 / 100.0  100.0 / 100.0 - 100.0", (Object)h.toLongMicrosFormat());
    }

    @Test
    public void testSampleRange() {
        @NotNull Histogram h = new Histogram(40, 2);
        double base = 1.0;
        for (int i = 0; i < 40; ++i) {
            Assert.assertEquals((long)(i * 4 + 0), (long)h.sample(base));
            Assert.assertEquals((long)(i * 4 + 1), (long)h.sample(base * 1.25));
            Assert.assertEquals((long)(i * 4 + 2), (long)h.sample(base * 1.5));
            Assert.assertEquals((long)(i * 4 + 3), (long)h.sample(base * 1.75));
            base *= 2.0;
        }
    }

    @Test
    public void testSamples() {
        int i;
        @NotNull Histogram h = new Histogram(7, 5);
        for (i = 1; i <= 100; ++i) {
            h.sample((double)i);
        }
        Assert.assertEquals((double)101.0, (double)h.percentile(1.0), (double)0.0);
        Assert.assertEquals((double)95.0, (double)h.percentile(0.95), (double)0.0);
        Assert.assertEquals((double)91.0, (double)h.percentile(0.9), (double)0.0);
        Assert.assertEquals((double)85.0, (double)h.percentile(0.85), (double)0.0);
        Assert.assertEquals((double)81.0, (double)h.percentile(0.8), (double)0.0);
        Assert.assertEquals((double)71.0, (double)h.percentile(0.71), (double)0.0);
        Assert.assertEquals((float)62.0f, (float)((long)h.percentile(0.62)), (float)0.0f);
        Assert.assertEquals((float)50.0f, (float)((long)h.percentile(0.5)), (float)0.0f);
        Assert.assertEquals((float)40.0f, (float)((long)h.percentile(0.4)), (float)0.0f);
        Assert.assertEquals((float)30.0f, (float)((long)h.percentile(0.3)), (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)((long)h.percentile(0.0)), (float)0.0f);
        for (i = 1; i <= 100; ++i) {
            Assert.assertEquals((double)i, (double)h.percentageLessThan((double)i), (double)(i >> 6));
        }
    }
}

