/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.util.function.IntPredicate;
import net.openhft.chronicle.core.util.IntBiPredicate;
import net.openhft.chronicle.core.util.IntTriPredicate;
import net.openhft.chronicle.core.util.Ints;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class IntsTest {
    @Test
    public void require1Arg() {
        this.test(1, 0, v -> Ints.require((IntPredicate)Ints.positive(), (int)v));
        this.test(1, -1, v -> Ints.require((IntPredicate)Ints.positive(), (int)v));
    }

    @Test
    public void require2Arg() {
        this.test(1, 0, v -> Ints.require((IntBiPredicate)Ints.equalTo(), (int)v, (int)1));
    }

    @Test
    public void require3Ard() {
        this.test(0, 16, v -> Ints.require((IntTriPredicate)Ints.between(), (int)v, (int)0, (int)16));
        this.test(15, -1, v -> Ints.require((IntTriPredicate)Ints.between(), (int)v, (int)0, (int)16));
    }

    private void test(int happy, int sad, @NotNull IntUnaryOperator mapper) {
        try {
            long result = mapper.applyAsInt(happy);
            Assert.assertEquals((long)happy, (long)result);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        try {
            long result2 = mapper.applyAsInt(sad);
            Assert.fail((String)(result2 + " is not valid!"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static interface IntUnaryOperator {
        public long applyAsInt(int var1) throws IllegalArgumentException;
    }
}

